/*
 * Decompiled with CFR 0.152.
 */
package paulscode.sound.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemLogger;
import paulscode.sound.utils.XMLNode;

public class XMLParser {
    private static SoundSystemLogger logger;

    public static XMLNode parseXML(URL uRL) {
        return new XMLNode(XMLParser.trimSpaces(XMLParser.readString(uRL)));
    }

    public static String getRawXML(URL uRL) {
        return XMLParser.trimSpaces(XMLParser.readString(uRL));
    }

    private static String readString(URL uRL) {
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
        }
        catch (IOException iOException) {
            XMLParser.errorMessage("Unable to open inputstream in method 'readString'");
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = null;
        BufferedReader bufferedReader = null;
        String string = "";
        byte[] byArray = new byte[4096];
        int n = 0;
        try {
            do {
                if ((n = inputStream.read(byArray)) == -1) continue;
                byteArrayOutputStream.write(byArray, 0, n);
            } while (n != -1);
            byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
            String string2 = "";
            do {
                if ((string2 = bufferedReader.readLine()) == null) continue;
                string = string + "\n" + string2;
            } while (string2 != null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (byteArrayOutputStream != null) {
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (byteArrayInputStream != null) {
            try {
                byteArrayInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        inputStream = null;
        byteArrayOutputStream = null;
        byteArrayInputStream = null;
        bufferedReader = null;
        return string;
    }

    public static String trimSpaces(String string) {
        String[] stringArray = XMLParser.seperateWords(string);
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        String string2 = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string2 = string2 + " " + stringArray[i];
        }
        return string2;
    }

    public static String[] seperateWords(String string) {
        if (string == null) {
            return null;
        }
        while (string.length() > 0 && string.substring(0, 1).matches("\\s")) {
            string = string.substring(1);
        }
        if (string.length() == 0) {
            return null;
        }
        String[] stringArray = string.split("\\s+");
        return stringArray;
    }

    protected static void errorMessage(String string) {
        if (logger == null) {
            logger = SoundSystemConfig.getLogger();
        }
        if (logger == null) {
            logger = new SoundSystemLogger();
            SoundSystemConfig.setLogger(logger);
        }
        logger.errorMessage("XMLParser", string, 0);
    }
}

