/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import java.util.Vector;
import org.joone.engine.Pattern;
import org.joone.util.OutputConverterPlugIn;

public class UnNormalizerOutputPlugIn
extends OutputConverterPlugIn {
    private double min = 0.0;
    private double max = 1.0;
    private double datamax = 0.0;
    private double datamin = 0.0;
    private transient double datadiff = 0.0;
    private transient double tmpmin = 0.0;
    private transient double tmpmax = 0.0;
    static final long serialVersionUID = 5322361123972428588L;

    public UnNormalizerOutputPlugIn() {
    }

    public UnNormalizerOutputPlugIn(String string, double d, double d2, double d3, double d4) {
        this.setAdvancedSerieSelector(string);
        this.setInDataMin(d);
        this.setInDataMax(d2);
        this.setOutDataMin(d3);
        this.setOutDataMax(d4);
    }

    public double getOutDataMax() {
        return this.max;
    }

    public double getOutDataMin() {
        return this.min;
    }

    public void setOutDataMax(double d) {
        if (this.max != d) {
            this.max = d;
            super.fireDataChanged();
        }
    }

    public void setOutDataMin(double d) {
        if (this.min != d) {
            this.min = d;
            super.fireDataChanged();
        }
    }

    public double getInDataMax() {
        return this.datamax;
    }

    public double getInDataMin() {
        return this.datamin;
    }

    public void setInDataMax(double d) {
        if (this.datamax != d) {
            this.datamax = d;
            super.fireDataChanged();
        }
    }

    public void setInDataMin(double d) {
        if (this.datamin != d) {
            this.datamin = d;
            super.fireDataChanged();
        }
    }

    protected boolean convert(int n) {
        boolean bl = false;
        Vector vector = this.getInputVector();
        double d = 0.0;
        int n2 = 0;
        int n3 = 0;
        n3 = vector.size();
        if (vector != null && n >= 0) {
            if (this.datamax == 0.0 && this.datamin == 0.0) {
                this.setupMinMax(n, vector);
            } else {
                this.tmpmin = this.datamin;
                this.tmpmax = this.datamax;
            }
            this.datadiff = this.tmpmax - this.tmpmin;
            for (n2 = 0; n2 < n3; ++n2) {
                if (this.datadiff != 0.0) {
                    d = this.getValuePoint(n2, n);
                    d = (d - this.tmpmin) / this.datadiff;
                    d = d * (this.getOutDataMax() - this.getOutDataMin()) + this.getOutDataMin();
                } else {
                    d = this.getOutDataMin();
                }
                ((Pattern)vector.elementAt(n2)).setValue(n, d);
                bl = true;
            }
        }
        return bl;
    }

    protected void convert_pattern(int n) {
        Pattern pattern = this.getPattern();
        double d = 0.0;
        if (pattern != null && n >= 0) {
            if (this.datamax != 0.0 || this.datamin != 0.0) {
                this.datadiff = this.datamax - this.datamin;
                if (this.datadiff != 0.0) {
                    d = pattern.getArray()[n];
                    d = (d - this.datamin) / this.datadiff;
                    d = d * (this.getOutDataMax() - this.getOutDataMin()) + this.getOutDataMin();
                } else {
                    d = this.getOutDataMin();
                }
                pattern.setValue(n, d);
            }
            return;
        }
    }

    private void setupMinMax(int n, Vector vector) {
        int n2 = vector.size();
        this.tmpmin = this.tmpmax = this.getValuePoint(0, n);
        for (int i = 0; i < n2; ++i) {
            double d = this.getValuePoint(i, n);
            if (d > this.tmpmax) {
                this.tmpmax = d;
                continue;
            }
            if (!(d < this.tmpmin)) continue;
            this.tmpmin = d;
        }
    }
}

