/*
 * Decompiled with CFR 0.152.
 */
package org.joone.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.Pattern;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;
import org.joone.util.CSVParser;
import org.joone.util.PlugInEvent;
import org.joone.util.PlugInListener;

public abstract class AbstractConverterPlugIn
implements Serializable,
PlugInListener {
    private static final long serialVersionUID = 5698511686417862414L;
    private static final ILogger log = LoggerFactory.getLogger(AbstractConverterPlugIn.class);
    private AbstractConverterPlugIn nextPlugIn = null;
    private String name;
    private boolean connected;
    protected Vector pluginListeners;
    private transient Vector InputVector;
    private String AdvancedSerieSelector = "";
    private transient int[] serieSelected;

    public AbstractConverterPlugIn() {
    }

    public AbstractConverterPlugIn(String string) {
        this.setAdvancedSerieSelector(string);
    }

    public void convertPatterns() {
        this.apply();
        this.cascade();
    }

    protected boolean apply() {
        boolean bl = false;
        Vector vector = this.getInputVector();
        if (vector != null && !vector.isEmpty()) {
            bl = this.applyOnColumns() | this.applyOnRows();
        } else {
            log.warn(this.getName() + " : Plugin has no input data to convert.");
        }
        return bl;
    }

    protected boolean applyOnColumns() {
        boolean bl = false;
        Pattern pattern = (Pattern)this.getInputVector().elementAt(0);
        int n = pattern.getArray().length;
        if (this.getAdvancedSerieSelector() != null && !this.getAdvancedSerieSelector().equals("")) {
            int[] nArray = this.getSerieSelected();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] - 1 < n) {
                    bl = this.convert(nArray[i] - 1) | bl;
                    continue;
                }
                log.warn(this.getName() + " : Advanced Serie Selector contains too many serie. Check the number of columns in the appropriate input synapse.");
            }
        }
        return bl;
    }

    protected boolean applyOnRows() {
        return false;
    }

    protected void cascade() {
        if (this.getNextPlugIn() != null) {
            AbstractConverterPlugIn abstractConverterPlugIn = this.getNextPlugIn();
            abstractConverterPlugIn.setInputVector(this.getInputVector());
            abstractConverterPlugIn.convertPatterns();
        }
    }

    protected abstract boolean convert(int var1);

    protected double getValuePoint(int n, int n2) {
        Pattern pattern = (Pattern)this.getInputVector().elementAt(n);
        return pattern.getArray()[n2];
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
    }

    public synchronized void addPlugInListener(PlugInListener plugInListener) {
        if (!this.getPluginListeners().contains(plugInListener)) {
            this.getPluginListeners().add(plugInListener);
        }
    }

    public synchronized void removePlugInListener(PlugInListener plugInListener) {
        if (this.getPluginListeners().contains(plugInListener)) {
            this.getPluginListeners().remove(plugInListener);
        }
    }

    protected Vector getPluginListeners() {
        if (this.pluginListeners == null) {
            this.pluginListeners = new Vector();
        }
        return this.pluginListeners;
    }

    public void dataChanged(PlugInEvent plugInEvent) {
        this.fireDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireDataChanged() {
        Object[] objectArray;
        AbstractConverterPlugIn abstractConverterPlugIn = this;
        synchronized (abstractConverterPlugIn) {
            objectArray = this.getPluginListeners().toArray();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            PlugInListener plugInListener = (PlugInListener)objectArray[i];
            if (plugInListener == null) continue;
            plugInListener.dataChanged(new PlugInEvent(this));
        }
    }

    public String getAdvancedSerieSelector() {
        return this.AdvancedSerieSelector;
    }

    public void setAdvancedSerieSelector(String string) {
        if (this.AdvancedSerieSelector == null || !this.AdvancedSerieSelector.equals(string)) {
            this.AdvancedSerieSelector = string;
            this.serieSelected = null;
            this.fireDataChanged();
        }
    }

    protected int[] getSerieSelected() {
        if (this.serieSelected == null) {
            CSVParser cSVParser = new CSVParser(this.getAdvancedSerieSelector(), true);
            this.serieSelected = cSVParser.parseInt();
        }
        return this.serieSelected;
    }

    public boolean addPlugIn(AbstractConverterPlugIn abstractConverterPlugIn) {
        if (this.nextPlugIn == abstractConverterPlugIn) {
            log.warn("Plugin already connected to plugin stack. Ignoring request.");
            return false;
        }
        if (abstractConverterPlugIn == null) {
            if (this.nextPlugIn != null) {
                this.nextPlugIn.setConnected(false);
            }
            this.nextPlugIn = null;
            this.fireDataChanged();
            return true;
        }
        if (abstractConverterPlugIn.isConnected()) {
            return false;
        }
        if (this.nextPlugIn == null) {
            abstractConverterPlugIn.setConnected(true);
            abstractConverterPlugIn.addPlugInListener(this);
            this.nextPlugIn = abstractConverterPlugIn;
            this.fireDataChanged();
            return true;
        }
        return this.nextPlugIn.addPlugIn(abstractConverterPlugIn);
    }

    public void removeAllPlugIns() {
        if (this.nextPlugIn != null) {
            this.nextPlugIn.setConnected(false);
            this.nextPlugIn.removeAllPlugIns();
            this.nextPlugIn = null;
        } else {
            this.fireDataChanged();
        }
    }

    public boolean setNextPlugin(AbstractConverterPlugIn abstractConverterPlugIn) {
        if (abstractConverterPlugIn == this.nextPlugIn) {
            return false;
        }
        if (abstractConverterPlugIn == null) {
            this.nextPlugIn.setConnected(false);
        } else {
            if (abstractConverterPlugIn.isConnected()) {
                return false;
            }
            abstractConverterPlugIn.setConnected(true);
            abstractConverterPlugIn.addPlugInListener(this);
        }
        this.nextPlugIn = abstractConverterPlugIn;
        this.fireDataChanged();
        return true;
    }

    public AbstractConverterPlugIn getNextPlugIn() {
        return this.nextPlugIn;
    }

    public void setNextPlugIn(AbstractConverterPlugIn abstractConverterPlugIn) {
        this.addPlugIn(abstractConverterPlugIn);
    }

    public void setInputVector(Vector vector) {
        this.InputVector = vector;
    }

    protected Vector getInputVector() {
        return this.InputVector;
    }

    public TreeSet check(TreeSet treeSet) {
        if (this.AdvancedSerieSelector == null || this.AdvancedSerieSelector.equals("")) {
            treeSet.add(new NetCheck(0, "Advanced Serie Selector should be populated, e.g 1,2,4.", this));
        }
        if (this.getNextPlugIn() != null) {
            this.getNextPlugIn().check(treeSet);
        }
        return treeSet;
    }

    protected int getSerieIndexNumber(int n) {
        CSVParser cSVParser = new CSVParser(this.getAdvancedSerieSelector(), true);
        int[] nArray = cSVParser.parseInt();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n + 1) continue;
            return i;
        }
        return -1;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.getAdvancedSerieSelector() == null) {
            this.setAdvancedSerieSelector("1");
        }
    }
}

