/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.util;

import org.joone.exception.JooneRuntimeException;
import org.joone.io.MemoryInputTokenizer;
import org.joone.io.StreamInputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class EncoderInputSynapse
extends StreamInputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(EncoderInputSynapse.class);
    private int size = 0;
    private double upperBit = 1.0;
    private double lowerBit = 0.0;

    public EncoderInputSynapse() {
    }

    public EncoderInputSynapse(double d, double d2) {
        this.lowerBit = d;
        this.upperBit = d2;
    }

    protected void initInputStream() throws JooneRuntimeException {
        this.setAdvancedColumnSelector("1-" + this.size);
        this.setTokens(new MemoryInputTokenizer(this.createEncoderArray()));
    }

    public void setSize(int n) {
        this.size = n;
    }

    public int getSize() {
        return this.size;
    }

    public int getNumOfPatterns() {
        return this.size;
    }

    protected double[][] createEncoderArray() {
        int n = this.getNumOfPatterns();
        double[][] dArray = new double[n][this.getSize()];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.getSize(); ++j) {
                dArray[i][j] = this.getLowerBit();
            }
            dArray[i][i] = this.getUpperBit();
        }
        return dArray;
    }

    public void setUpperBit(double d) {
        this.upperBit = d;
    }

    public double getUpperBit() {
        return this.upperBit;
    }

    public void setLowerBit(double d) {
        this.lowerBit = d;
    }

    public double getLowerBit() {
        return this.lowerBit;
    }
}

