/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.xor;

import org.joone.engine.FullSynapse;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.io.MemoryInputSynapse;
import org.joone.net.NeuralNet;

public class XORMemory
implements NeuralNetListener {
    private double[][] inputArray = new double[][]{{0.0, 0.0, 0.0}, {0.0, 1.0, 1.0}, {1.0, 0.0, 1.0}, {1.0, 1.0, 0.0}};
    private long mills;

    public static void main(String[] stringArray) {
        XORMemory xORMemory = new XORMemory();
        if (stringArray.length == 0) {
            xORMemory.Go(10000);
        } else {
            xORMemory.Go(new Integer(stringArray[0]));
        }
    }

    public void Go(int n) {
        LinearLayer linearLayer = new LinearLayer();
        SigmoidLayer sigmoidLayer = new SigmoidLayer();
        SigmoidLayer sigmoidLayer2 = new SigmoidLayer();
        linearLayer.setLayerName("input");
        sigmoidLayer.setLayerName("hidden");
        sigmoidLayer2.setLayerName("output");
        linearLayer.setRows(2);
        sigmoidLayer.setRows(3);
        sigmoidLayer2.setRows(1);
        FullSynapse fullSynapse = new FullSynapse();
        FullSynapse fullSynapse2 = new FullSynapse();
        fullSynapse.setName("IH");
        fullSynapse2.setName("HO");
        linearLayer.addOutputSynapse(fullSynapse);
        sigmoidLayer.addInputSynapse(fullSynapse);
        sigmoidLayer.addOutputSynapse(fullSynapse2);
        sigmoidLayer2.addInputSynapse(fullSynapse2);
        MemoryInputSynapse memoryInputSynapse = new MemoryInputSynapse();
        memoryInputSynapse.setInputArray(this.inputArray);
        memoryInputSynapse.setAdvancedColumnSelector("1,2");
        linearLayer.addInputSynapse(memoryInputSynapse);
        TeachingSynapse teachingSynapse = new TeachingSynapse();
        MemoryInputSynapse memoryInputSynapse2 = new MemoryInputSynapse();
        memoryInputSynapse2.setInputArray(this.inputArray);
        memoryInputSynapse2.setAdvancedColumnSelector("3");
        teachingSynapse.setDesired(memoryInputSynapse2);
        sigmoidLayer2.addOutputSynapse(teachingSynapse);
        NeuralNet neuralNet = new NeuralNet();
        neuralNet.addLayer(linearLayer, 0);
        neuralNet.addLayer(sigmoidLayer, 1);
        neuralNet.addLayer(sigmoidLayer2, 2);
        Monitor monitor = neuralNet.getMonitor();
        monitor.setTrainingPatterns(4);
        monitor.setTotCicles(n);
        monitor.setLearningRate(0.8);
        monitor.setMomentum(0.5);
        monitor.setLearning(true);
        monitor.setSingleThreadMode(true);
        monitor.addNeuralNetListener(this);
        this.mills = System.currentTimeMillis();
        neuralNet.go();
    }

    public void netStopped(NeuralNetEvent neuralNetEvent) {
        long l = System.currentTimeMillis() - this.mills;
        System.out.println("Training finished after " + l + " ms");
        System.exit(0);
    }

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
        System.out.println("Training...");
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
        Monitor monitor = (Monitor)neuralNetEvent.getSource();
        long l = monitor.getCurrentCicle();
        long l2 = l / 1000L;
        if (l2 * 1000L == l) {
            System.out.println(l + " cycles remaining - Error = " + monitor.getGlobalError());
        }
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
    }
}

