/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.xor.InputConnector;

import org.joone.engine.FullSynapse;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.io.InputConnector;
import org.joone.io.MemoryInputSynapse;
import org.joone.net.NeuralNet;

public class XORMemory_using_InputConnector
implements NeuralNetListener {
    private double[][] inputArray = new double[][]{{0.0, 0.0, 0.0}, {0.0, 1.0, 1.0}, {1.0, 0.0, 1.0}, {1.0, 1.0, 0.0}};
    private long mills;

    public static void main(String[] stringArray) {
        XORMemory_using_InputConnector xORMemory_using_InputConnector = new XORMemory_using_InputConnector();
        xORMemory_using_InputConnector.Go();
    }

    public void Go() {
        LinearLayer linearLayer = new LinearLayer();
        SigmoidLayer sigmoidLayer = new SigmoidLayer();
        SigmoidLayer sigmoidLayer2 = new SigmoidLayer();
        linearLayer.setLayerName("input");
        sigmoidLayer.setLayerName("hidden");
        sigmoidLayer2.setLayerName("output");
        linearLayer.setRows(2);
        sigmoidLayer.setRows(3);
        sigmoidLayer2.setRows(1);
        FullSynapse fullSynapse = new FullSynapse();
        FullSynapse fullSynapse2 = new FullSynapse();
        fullSynapse.setName("IH");
        fullSynapse2.setName("HO");
        linearLayer.addOutputSynapse(fullSynapse);
        sigmoidLayer.addInputSynapse(fullSynapse);
        sigmoidLayer.addOutputSynapse(fullSynapse2);
        sigmoidLayer2.addInputSynapse(fullSynapse2);
        MemoryInputSynapse memoryInputSynapse = new MemoryInputSynapse();
        memoryInputSynapse.setInputArray(this.inputArray);
        memoryInputSynapse.setAdvancedColumnSelector("1-3");
        InputConnector inputConnector = new InputConnector();
        inputConnector.setInputSynapse(memoryInputSynapse);
        inputConnector.setAdvancedColumnSelector("1,2");
        linearLayer.addInputSynapse(inputConnector);
        InputConnector inputConnector2 = new InputConnector();
        inputConnector2.setInputSynapse(memoryInputSynapse);
        inputConnector2.setAdvancedColumnSelector("3");
        TeachingSynapse teachingSynapse = new TeachingSynapse();
        teachingSynapse.setDesired(inputConnector2);
        sigmoidLayer2.addOutputSynapse(teachingSynapse);
        NeuralNet neuralNet = new NeuralNet();
        neuralNet.addLayer(linearLayer, 0);
        neuralNet.addLayer(sigmoidLayer, 1);
        neuralNet.addLayer(sigmoidLayer2, 2);
        neuralNet.setTeacher(teachingSynapse);
        Monitor monitor = neuralNet.getMonitor();
        monitor.setLearningRate(0.8);
        monitor.setMomentum(0.3);
        monitor.setTrainingPatterns(4);
        monitor.setTotCicles(2000);
        monitor.setLearning(true);
        monitor.addNeuralNetListener(this);
        this.mills = System.currentTimeMillis();
        neuralNet.go();
    }

    public void netStopped(NeuralNetEvent neuralNetEvent) {
        long l = System.currentTimeMillis() - this.mills;
        System.out.println("Training finished after " + l + " ms");
        System.exit(0);
    }

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
        System.out.println("Training...");
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
        Monitor monitor = (Monitor)neuralNetEvent.getSource();
        long l = monitor.getCurrentCicle();
        if (l % 200L == 0L) {
            System.out.println(l + " epochs remaining - RMSE = " + monitor.getGlobalError());
        }
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
    }
}

