/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.xor;

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import org.joone.engine.Layer;
import org.joone.io.MemoryInputSynapse;
import org.joone.io.MemoryOutputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NeuralNet;
import org.joone.util.UnNormalizerOutputPlugIn;

public class EmbeddedXOR {
    private static final ILogger log = LoggerFactory.getLogger(EmbeddedXOR.class);
    private double[][] inputArray = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 0.0}, {1.0, 1.0}};
    private MemoryOutputSynapse memOut;
    private static String xorNet = "org/joone/samples/engine/xor/xor.snet";

    public static void main(String[] stringArray) {
        EmbeddedXOR embeddedXOR = new EmbeddedXOR();
        embeddedXOR.Go(xorNet);
    }

    private void Go(String string) {
        NeuralNet neuralNet = this.restoreNeuralNet(string);
        if (neuralNet != null) {
            Layer layer = neuralNet.getInputLayer();
            layer.removeAllInputs();
            MemoryInputSynapse memoryInputSynapse = new MemoryInputSynapse();
            memoryInputSynapse.setFirstRow(1);
            memoryInputSynapse.setAdvancedColumnSelector("1,2");
            layer.addInputSynapse(memoryInputSynapse);
            memoryInputSynapse.setInputArray(this.inputArray);
            Layer layer2 = neuralNet.getOutputLayer();
            layer2.removeAllOutputs();
            this.memOut = new MemoryOutputSynapse();
            UnNormalizerOutputPlugIn unNormalizerOutputPlugIn = new UnNormalizerOutputPlugIn();
            unNormalizerOutputPlugIn.setAdvancedSerieSelector("1");
            unNormalizerOutputPlugIn.setOutDataMin(1.0);
            unNormalizerOutputPlugIn.setOutDataMax(2.0);
            this.memOut.addPlugIn(unNormalizerOutputPlugIn);
            layer2.addOutputSynapse(this.memOut);
            neuralNet.getMonitor().setTotCicles(1);
            neuralNet.getMonitor().setTrainingPatterns(4);
            neuralNet.getMonitor().setLearning(false);
            this.interrogate(neuralNet, 10);
            log.info("Finished");
        }
    }

    private void interrogate(NeuralNet neuralNet, int n) {
        int n2 = neuralNet.getMonitor().getTrainingPatterns();
        for (int i = 0; i < n; ++i) {
            log.info("Launch #" + (i + 1));
            neuralNet.go();
            for (int j = 0; j < n2; ++j) {
                double[] dArray = this.memOut.getNextPattern();
                log.info("    Output Pattern #" + (j + 1) + " = " + dArray[0]);
            }
            neuralNet.stop();
        }
    }

    private NeuralNet restoreNeuralNet(String string) {
        NeuralNet neuralNet = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            neuralNet = (NeuralNet)objectInputStream.readObject();
        }
        catch (Exception exception) {
            log.warn("Exception was thrown. Message is : " + exception.getMessage(), exception);
        }
        return neuralNet;
    }
}

