/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.validation;

import java.util.Vector;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.net.NeuralNet;
import org.joone.net.NeuralNetValidator;
import org.joone.net.NeuralValidationEvent;
import org.joone.net.NeuralValidationListener;

public class NeuralNetTrainer
implements Runnable,
NeuralNetListener,
NeuralValidationListener {
    private Vector listeners = new Vector();
    private NeuralNet nnet;
    private Thread myThread = null;

    public NeuralNetTrainer(NeuralNet neuralNet) {
        this.nnet = this.cloneNet(neuralNet);
    }

    public void addValidationListener(NeuralValidationListener neuralValidationListener) {
        if (!this.listeners.contains(neuralValidationListener)) {
            this.listeners.addElement(neuralValidationListener);
        }
    }

    protected void train() {
        this.nnet.getMonitor().addNeuralNetListener(this);
        this.nnet.getMonitor().setLearning(true);
        this.nnet.getMonitor().setValidation(false);
        this.nnet.go(true);
        this.validate();
    }

    protected void validate() {
        NeuralNet neuralNet = this.cloneNet(this.nnet);
        NeuralNetValidator neuralNetValidator = new NeuralNetValidator(neuralNet);
        neuralNetValidator.addValidationListener(this);
        neuralNetValidator.start();
    }

    private NeuralNet cloneNet(NeuralNet neuralNet) {
        neuralNet.getMonitor().setExporting(true);
        NeuralNet neuralNet2 = neuralNet.cloneNet();
        neuralNet.getMonitor().setExporting(false);
        neuralNet2.removeAllListeners();
        return neuralNet2;
    }

    private void fireNetValidated(NeuralValidationEvent neuralValidationEvent) {
        NeuralNet neuralNet = (NeuralNet)neuralValidationEvent.getSource();
        neuralNet.terminate(false);
        for (int i = 0; i < this.listeners.size(); ++i) {
            NeuralValidationListener neuralValidationListener = (NeuralValidationListener)this.listeners.elementAt(i);
            neuralValidationListener.netValidated(new NeuralValidationEvent(neuralNet));
        }
    }

    public void start() {
        if (this.myThread == null) {
            this.myThread = new Thread((Runnable)this, "Trainer");
            this.myThread.start();
        }
    }

    public void run() {
        this.train();
        this.myThread = null;
    }

    public void netStopped(NeuralNetEvent neuralNetEvent) {
    }

    public void netValidated(NeuralValidationEvent neuralValidationEvent) {
        this.fireNetValidated(neuralValidationEvent);
    }

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
        System.exit(1);
    }
}

