/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.validation;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.joone.engine.DirectSynapse;
import org.joone.engine.FullSynapse;
import org.joone.engine.LinearLayer;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.io.MemoryInputSynapse;
import org.joone.io.MemoryOutputSynapse;
import org.joone.io.XLSInputSynapse;
import org.joone.net.NestedNeuralLayer;
import org.joone.net.NeuralNet;
import org.joone.net.NeuralValidationEvent;
import org.joone.net.NeuralValidationListener;
import org.joone.samples.engine.validation.NeuralNetFactory;
import org.joone.samples.engine.validation.NeuralNetTrainer;
import org.joone.util.LearningSwitch;

public class MultipleValidationSample
implements NeuralValidationListener {
    NeuralNet nnet;
    boolean ready;
    int totNets = 10;
    int returnedNets = 0;
    double totRMSE = 0.0;
    double minRMSE = 99.0;
    long mStart;
    int trainingLCP = 1;
    int validationLCP = 16;
    int totCycles = 1000;
    FileWriter wr = null;
    private static String filePath = "org/joone/samples/engine/validation";
    String xorNet = filePath + "/trainedXOR.snet";
    private static long fSLEEP_INTERVAL = 20L;

    public static void main(String[] stringArray) {
        MultipleValidationSample multipleValidationSample = new MultipleValidationSample();
        multipleValidationSample.start();
    }

    private void start() {
        try {
            this.wr = new FileWriter(new File("/tmp/memory.txt"));
            while (this.trainingLCP <= this.validationLCP) {
                this.startValidation(this.trainingLCP, this.validationLCP);
                ++this.trainingLCP;
                this.wr.flush();
            }
            this.wr.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println("Done.");
        System.exit(0);
    }

    private synchronized void startValidation(int n, int n2) {
        this.nnet = this.initializeModularParity(n, n2);
        this.nnet.getMonitor().setTrainingPatterns(n);
        this.nnet.getMonitor().setValidationPatterns(n2);
        try {
            this.mStart = System.currentTimeMillis();
            this.returnedNets = 0;
            this.totRMSE = 0.0;
            this.minRMSE = 99.0;
            int n3 = this.totNets;
            for (int i = 0; i < 1; ++i) {
                this.test(n3--);
            }
            while (n3 > 0) {
                while (!this.ready) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.ready = false;
                this.test(n3--);
                long l = MultipleValidationSample.getMemoryUse();
                this.wr.write(l + "\r\n");
            }
            while (this.returnedNets < this.totNets) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.displayResults();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void test(int n) {
        this.nnet.randomize(0.5);
        this.nnet.setParam("ID", new Integer(n));
        NeuralNetTrainer neuralNetTrainer = new NeuralNetTrainer(this.nnet);
        neuralNetTrainer.addValidationListener(this);
        neuralNetTrainer.start();
    }

    public synchronized void netValidated(NeuralValidationEvent neuralValidationEvent) {
        NeuralNet neuralNet = (NeuralNet)neuralValidationEvent.getSource();
        int n = (Integer)neuralNet.getParam("ID");
        double d = neuralNet.getMonitor().getGlobalError();
        this.totRMSE += d;
        if (this.minRMSE > d) {
            this.minRMSE = d;
        }
        ++this.returnedNets;
        this.ready = true;
        this.notifyAll();
    }

    private void displayResults() {
        double d = this.totRMSE / (double)this.totNets;
        long l = System.currentTimeMillis() - this.mStart;
        System.out.println("---------------------------------------------------------");
        System.out.println("Training Patterns: " + this.trainingLCP);
        System.out.println("Average Generalization Error: " + d);
        System.out.println("Minimum Generalization Error: " + this.minRMSE);
        System.out.println("Elapsed Time: " + l + " Miliseconds");
        System.out.println("---------------------------------------------------------");
    }

    private static long getMemoryUse() {
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().freeMemory();
        return l - l2;
    }

    private static void collectGarbage() {
        try {
            System.gc();
            Thread.currentThread();
            Thread.sleep(fSLEEP_INTERVAL);
            System.runFinalization();
            Thread.currentThread();
            Thread.sleep(fSLEEP_INTERVAL);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private NeuralNet initializeSimpleParity(int n, int n2) {
        NeuralNet neuralNet = new NeuralNet();
        double[][] dArray = this.constructLearningData(n);
        double[][] dArray2 = this.constructTestData(n2);
        LinearLayer linearLayer = new LinearLayer();
        SigmoidLayer sigmoidLayer = new SigmoidLayer();
        SigmoidLayer sigmoidLayer2 = new SigmoidLayer();
        linearLayer.setLayerName("Input Layer");
        sigmoidLayer.setLayerName("Hidden Layer");
        sigmoidLayer2.setLayerName("Output Layer");
        linearLayer.setRows(4);
        sigmoidLayer.setRows(4);
        sigmoidLayer2.setRows(1);
        FullSynapse fullSynapse = new FullSynapse();
        fullSynapse.setName("IH Synapse");
        FullSynapse fullSynapse2 = new FullSynapse();
        fullSynapse2.setName("HO Synapse");
        NeuralNetFactory.connect(linearLayer, fullSynapse, sigmoidLayer);
        NeuralNetFactory.connect(sigmoidLayer, fullSynapse2, sigmoidLayer2);
        MemoryInputSynapse memoryInputSynapse = NeuralNetFactory.createInput("Learning Input Synapse", dArray, 1, 1, 4);
        MemoryInputSynapse memoryInputSynapse2 = NeuralNetFactory.createInput("Test Input Synapse", dArray2, 1, 1, 4);
        LearningSwitch learningSwitch = NeuralNetFactory.createSwitch("Input Switch Synapse", memoryInputSynapse, memoryInputSynapse2);
        linearLayer.addInputSynapse(learningSwitch);
        MemoryInputSynapse memoryInputSynapse3 = NeuralNetFactory.createInput("Learning Desired Synapse", dArray, 1, 5, 5);
        MemoryInputSynapse memoryInputSynapse4 = NeuralNetFactory.createInput("Test Desired Synapse", dArray2, 1, 5, 5);
        LearningSwitch learningSwitch2 = NeuralNetFactory.createSwitch("Learning Switch Synapse", memoryInputSynapse3, memoryInputSynapse4);
        TeachingSynapse teachingSynapse = new TeachingSynapse();
        teachingSynapse.setName("Simple Parity Trainer Synapse");
        sigmoidLayer2.addOutputSynapse(teachingSynapse);
        teachingSynapse.setDesired(learningSwitch2);
        MemoryOutputSynapse memoryOutputSynapse = new MemoryOutputSynapse();
        memoryOutputSynapse.setName("Output Data");
        sigmoidLayer2.addOutputSynapse(memoryOutputSynapse);
        neuralNet.addLayer(linearLayer);
        neuralNet.addLayer(sigmoidLayer);
        neuralNet.addLayer(sigmoidLayer2);
        neuralNet.setTeacher(teachingSynapse);
        neuralNet.getMonitor().setLearningRate(0.7);
        neuralNet.getMonitor().setMomentum(0.5);
        neuralNet.getMonitor().setTotCicles(this.totCycles);
        return neuralNet;
    }

    private double[][] constructLearningData(int n) {
        int n2 = 5;
        double[][] dArray = new double[n][n2];
        double[][] dArrayArray = new double[][]{{0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 1.0, 1.0}, {0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 1.0, 1.0}, {0.0, 1.0, 1.0, 0.0, 1.0}, {0.0, 1.0, 1.0, 1.0, 0.0}, {1.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 1.0, 1.0}, {1.0, 0.0, 1.0, 0.0, 1.0}, {1.0, 0.0, 1.0, 1.0, 0.0}, {1.0, 1.0, 0.0, 0.0, 1.0}, {1.0, 1.0, 0.0, 1.0, 0.0}, {1.0, 1.0, 1.0, 0.0, 0.0}, {1.0, 1.0, 1.0, 1.0, 1.0}};
        for (int i = 0; i < n; ++i) {
            dArray[i][0] = dArrayArray[i][0];
            dArray[i][1] = dArrayArray[i][1];
            dArray[i][2] = dArrayArray[i][2];
            dArray[i][3] = dArrayArray[i][3];
            dArray[i][4] = dArrayArray[i][4];
        }
        return dArray;
    }

    private double[][] constructTestData(int n) {
        int n2 = 5;
        double[][] dArray = new double[n][n2];
        double[][] dArrayArray = new double[][]{{0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 1.0, 1.0}, {0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 1.0, 1.0}, {0.0, 1.0, 1.0, 0.0, 1.0}, {0.0, 1.0, 1.0, 1.0, 0.0}, {1.0, 0.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 1.0, 1.0}, {1.0, 0.0, 1.0, 0.0, 1.0}, {1.0, 0.0, 1.0, 1.0, 0.0}, {1.0, 1.0, 0.0, 0.0, 1.0}, {1.0, 1.0, 0.0, 1.0, 0.0}, {1.0, 1.0, 1.0, 0.0, 0.0}, {1.0, 1.0, 1.0, 1.0, 1.0}};
        for (int i = 0; i < n; ++i) {
            dArray[i][0] = dArrayArray[i][0];
            dArray[i][1] = dArrayArray[i][1];
            dArray[i][2] = dArrayArray[i][2];
            dArray[i][3] = dArrayArray[i][3];
            dArray[i][4] = dArrayArray[i][4];
        }
        return dArray;
    }

    private NeuralNet initializeModularParity(int n, int n2) {
        NeuralNet neuralNet = new NeuralNet();
        NestedNeuralLayer nestedNeuralLayer = new NestedNeuralLayer();
        NestedNeuralLayer nestedNeuralLayer2 = new NestedNeuralLayer();
        nestedNeuralLayer.setNeuralNet(this.xorNet);
        nestedNeuralLayer2.setNeuralNet(this.xorNet);
        nestedNeuralLayer.setLayerName("First Network");
        nestedNeuralLayer2.setLayerName("Second Network");
        double[][] dArray = this.constructLearningData(n);
        double[][] dArray2 = this.constructTestData(n2);
        LinearLayer linearLayer = new LinearLayer();
        LinearLayer linearLayer2 = new LinearLayer();
        SigmoidLayer sigmoidLayer = new SigmoidLayer();
        SigmoidLayer sigmoidLayer2 = new SigmoidLayer();
        linearLayer.setLayerName("First Input Third Network Layer");
        linearLayer2.setLayerName("Second Input Third Network Layer");
        sigmoidLayer.setLayerName("Hidden Third Network Layer");
        sigmoidLayer2.setLayerName("Output Third Network Layer");
        linearLayer.setRows(1);
        linearLayer2.setRows(1);
        sigmoidLayer.setRows(2);
        sigmoidLayer2.setRows(1);
        DirectSynapse directSynapse = new DirectSynapse();
        directSynapse.setName("First OI Synapse");
        DirectSynapse directSynapse2 = new DirectSynapse();
        directSynapse2.setName("First OI Synapse");
        FullSynapse fullSynapse = new FullSynapse();
        fullSynapse.setName("First IH Synapse");
        FullSynapse fullSynapse2 = new FullSynapse();
        fullSynapse2.setName("Second IH Synapse");
        FullSynapse fullSynapse3 = new FullSynapse();
        fullSynapse3.setName("HO Synapse");
        NeuralNetFactory.connect(nestedNeuralLayer, directSynapse, linearLayer);
        NeuralNetFactory.connect(nestedNeuralLayer2, directSynapse2, linearLayer2);
        NeuralNetFactory.connect(linearLayer, fullSynapse, sigmoidLayer);
        NeuralNetFactory.connect(linearLayer2, fullSynapse2, sigmoidLayer);
        NeuralNetFactory.connect(sigmoidLayer, fullSynapse3, sigmoidLayer2);
        MemoryInputSynapse memoryInputSynapse = NeuralNetFactory.createInput("First Learning Input Synapse", dArray, 1, 1, 2);
        MemoryInputSynapse memoryInputSynapse2 = NeuralNetFactory.createInput("First Test Input Synapse", dArray2, 1, 1, 2);
        LearningSwitch learningSwitch = NeuralNetFactory.createSwitch("First Input Switch Synapse", memoryInputSynapse, memoryInputSynapse2);
        nestedNeuralLayer.addInputSynapse(learningSwitch);
        MemoryInputSynapse memoryInputSynapse3 = NeuralNetFactory.createInput("Second Learning Input Synapse", dArray, 1, 3, 4);
        MemoryInputSynapse memoryInputSynapse4 = NeuralNetFactory.createInput("Second Test Input Synapse", dArray2, 1, 3, 4);
        LearningSwitch learningSwitch2 = NeuralNetFactory.createSwitch("Second Input Switch Synapse", memoryInputSynapse3, memoryInputSynapse4);
        learningSwitch2.setStepCounter(false);
        nestedNeuralLayer2.addInputSynapse(learningSwitch2);
        MemoryInputSynapse memoryInputSynapse5 = NeuralNetFactory.createInput("Learning Desired Synapse", dArray, 1, 5, 5);
        MemoryInputSynapse memoryInputSynapse6 = NeuralNetFactory.createInput("Test Desired Synapse", dArray2, 1, 5, 5);
        LearningSwitch learningSwitch3 = NeuralNetFactory.createSwitch("Learning Switch Synapse", memoryInputSynapse5, memoryInputSynapse6);
        TeachingSynapse teachingSynapse = new TeachingSynapse();
        teachingSynapse.setName("Modular Parity Trainer Synapse");
        sigmoidLayer2.addOutputSynapse(teachingSynapse);
        teachingSynapse.setDesired(learningSwitch3);
        MemoryOutputSynapse memoryOutputSynapse = new MemoryOutputSynapse();
        memoryOutputSynapse.setName("Output Data");
        sigmoidLayer2.addOutputSynapse(memoryOutputSynapse);
        neuralNet.addLayer(nestedNeuralLayer);
        neuralNet.addLayer(nestedNeuralLayer2);
        neuralNet.addLayer(linearLayer);
        neuralNet.addLayer(linearLayer2);
        neuralNet.addLayer(sigmoidLayer);
        neuralNet.addLayer(sigmoidLayer2);
        neuralNet.setTeacher(teachingSynapse);
        neuralNet.getMonitor().setLearningRate(0.5);
        neuralNet.getMonitor().setMomentum(0.5);
        neuralNet.getMonitor().setTotCicles(this.totCycles);
        return neuralNet;
    }

    private NeuralNet initializeNetworkI(int n, int n2) {
        NeuralNet neuralNet = new NeuralNet();
        LinearLayer linearLayer = new LinearLayer();
        SigmoidLayer sigmoidLayer = new SigmoidLayer();
        SigmoidLayer sigmoidLayer2 = new SigmoidLayer();
        linearLayer.setLayerName("Input Layer");
        sigmoidLayer.setLayerName("Hidden Layer");
        sigmoidLayer2.setLayerName("Output Layer");
        linearLayer.setRows(2);
        sigmoidLayer.setRows(2);
        sigmoidLayer2.setRows(1);
        FullSynapse fullSynapse = new FullSynapse();
        fullSynapse.setName("IH Synapse");
        FullSynapse fullSynapse2 = new FullSynapse();
        fullSynapse2.setName("HO Synapse");
        NeuralNetFactory.connect(linearLayer, fullSynapse, sigmoidLayer);
        NeuralNetFactory.connect(sigmoidLayer, fullSynapse2, sigmoidLayer2);
        XLSInputSynapse xLSInputSynapse = new XLSInputSynapse();
        xLSInputSynapse.setName("Learning Input Synapse");
        xLSInputSynapse.setInputFile(new File("/tmp/wine.xls"));
        xLSInputSynapse.setAdvancedColumnSelector("6,7");
        xLSInputSynapse.setSheetName("wine.data");
        xLSInputSynapse.setFirstRow(2);
        xLSInputSynapse.setLastRow(100);
        XLSInputSynapse xLSInputSynapse2 = new XLSInputSynapse();
        xLSInputSynapse2.setName("Test Input Synapse");
        xLSInputSynapse2.setInputFile(new File("/tmp/wine.xls"));
        xLSInputSynapse2.setAdvancedColumnSelector("6,7");
        xLSInputSynapse2.setSheetName("wine.data");
        xLSInputSynapse2.setFirstRow(2);
        xLSInputSynapse2.setLastRow(100);
        LearningSwitch learningSwitch = NeuralNetFactory.createSwitch("Input Switch Synapse", xLSInputSynapse, xLSInputSynapse2);
        linearLayer.addInputSynapse(learningSwitch);
        XLSInputSynapse xLSInputSynapse3 = new XLSInputSynapse();
        xLSInputSynapse3.setName("Learning Desired Synapse");
        xLSInputSynapse3.setInputFile(new File("/tmp/wine.xls"));
        xLSInputSynapse3.setAdvancedColumnSelector("8");
        xLSInputSynapse3.setSheetName("wine.data");
        xLSInputSynapse3.setFirstRow(2);
        xLSInputSynapse3.setLastRow(100);
        XLSInputSynapse xLSInputSynapse4 = new XLSInputSynapse();
        xLSInputSynapse4.setName("Test Desired Synapse");
        xLSInputSynapse4.setInputFile(new File("/tmp/wine.xls"));
        xLSInputSynapse4.setAdvancedColumnSelector("8");
        xLSInputSynapse4.setSheetName("wine.data");
        xLSInputSynapse4.setFirstRow(2);
        xLSInputSynapse4.setLastRow(100);
        LearningSwitch learningSwitch2 = NeuralNetFactory.createSwitch("Learning Switch Synapse", xLSInputSynapse3, xLSInputSynapse4);
        TeachingSynapse teachingSynapse = new TeachingSynapse();
        teachingSynapse.setName("EETNN Trainer Synapse");
        sigmoidLayer2.addOutputSynapse(teachingSynapse);
        teachingSynapse.setDesired(learningSwitch2);
        neuralNet.addLayer(linearLayer);
        neuralNet.addLayer(sigmoidLayer);
        neuralNet.addLayer(sigmoidLayer2);
        neuralNet.setTeacher(teachingSynapse);
        return neuralNet;
    }
}

