/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.scripting;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.joone.engine.FullSynapse;
import org.joone.engine.Layer;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.Synapse;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.io.FileInputSynapse;
import org.joone.io.StreamInputSynapse;
import org.joone.net.NeuralNet;
import org.joone.util.LearningSwitch;
import org.joone.util.MacroPlugin;
import org.joone.util.NormalizerPlugIn;

public class ScriptValidationSample {
    NeuralNet net;
    private static String filePath = "org/joone/samples/engine/scripting";

    public static void main(String[] stringArray) {
        ScriptValidationSample scriptValidationSample = new ScriptValidationSample();
        scriptValidationSample.initialize(filePath);
        scriptValidationSample.start();
    }

    private void initialize(String string) {
        LinearLayer linearLayer = new LinearLayer();
        SigmoidLayer sigmoidLayer = new SigmoidLayer();
        SigmoidLayer sigmoidLayer2 = new SigmoidLayer();
        linearLayer.setRows(13);
        sigmoidLayer.setRows(4);
        sigmoidLayer2.setRows(1);
        FullSynapse fullSynapse = new FullSynapse();
        FullSynapse fullSynapse2 = new FullSynapse();
        this.connect(linearLayer, fullSynapse, sigmoidLayer);
        this.connect(sigmoidLayer, fullSynapse2, sigmoidLayer2);
        FileInputSynapse fileInputSynapse = this.createInput(string + "/wine.txt", 1, 2, 14);
        FileInputSynapse fileInputSynapse2 = this.createInput(string + "/wine.txt", 131, 2, 14);
        FileInputSynapse fileInputSynapse3 = this.createInput(string + "/wine.txt", 1, 1, 1);
        FileInputSynapse fileInputSynapse4 = this.createInput(string + "/wine.txt", 131, 1, 1);
        LearningSwitch learningSwitch = this.createSwitch(fileInputSynapse, fileInputSynapse2);
        linearLayer.addInputSynapse(learningSwitch);
        LearningSwitch learningSwitch2 = this.createSwitch(fileInputSynapse3, fileInputSynapse4);
        TeachingSynapse teachingSynapse = new TeachingSynapse();
        teachingSynapse.setDesired(learningSwitch2);
        sigmoidLayer2.addOutputSynapse(teachingSynapse);
        this.net = new NeuralNet();
        this.net.addLayer(linearLayer, 0);
        this.net.addLayer(sigmoidLayer, 1);
        this.net.addLayer(sigmoidLayer2, 2);
        this.net.setTeacher(teachingSynapse);
        MacroPlugin macroPlugin = new MacroPlugin();
        String string2 = this.readFile(new File(string + "/validation.bsh"));
        macroPlugin.getMacroManager().addMacro("cycleTerminated", string2);
        macroPlugin.setRate(100);
        this.net.setMacroPlugin(macroPlugin);
        this.net.setScriptingEnabled(true);
        Monitor monitor = this.net.getMonitor();
        monitor.setLearningRate(0.2);
        monitor.setMomentum(0.3);
        monitor.setTrainingPatterns(130);
        monitor.setValidationPatterns(48);
        monitor.setTotCicles(1000);
        monitor.setLearning(true);
    }

    private FileInputSynapse createInput(String string, int n, int n2, int n3) {
        FileInputSynapse fileInputSynapse = new FileInputSynapse();
        fileInputSynapse.setInputFile(new File(string));
        fileInputSynapse.setFirstRow(n);
        if (n2 != n3) {
            fileInputSynapse.setAdvancedColumnSelector(n2 + "-" + n3);
        } else {
            fileInputSynapse.setAdvancedColumnSelector(Integer.toString(n2));
        }
        NormalizerPlugIn normalizerPlugIn = new NormalizerPlugIn();
        if (n2 != n3) {
            normalizerPlugIn.setAdvancedSerieSelector("1-" + Integer.toString(n3 - n2 + 1));
        } else {
            normalizerPlugIn.setAdvancedSerieSelector("1");
        }
        fileInputSynapse.addPlugIn(normalizerPlugIn);
        return fileInputSynapse;
    }

    private void connect(Layer layer, Synapse synapse, Layer layer2) {
        layer.addOutputSynapse(synapse);
        layer2.addInputSynapse(synapse);
    }

    private LearningSwitch createSwitch(StreamInputSynapse streamInputSynapse, StreamInputSynapse streamInputSynapse2) {
        LearningSwitch learningSwitch = new LearningSwitch();
        learningSwitch.addTrainingSet(streamInputSynapse);
        learningSwitch.addValidationSet(streamInputSynapse2);
        return learningSwitch;
    }

    private String readFile(File file) {
        String string = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            int n = new Long(file.length()).intValue();
            char[] cArray = new char[n];
            int n2 = fileReader.read(cArray);
            if (n2 != -1) {
                string = new String(cArray, 0, n2);
            }
            fileReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException.getMessage());
            return string;
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        return string;
    }

    private void start() {
        this.net.go();
    }
}

