/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.parity;

import java.io.Serializable;
import java.util.Vector;
import org.joone.engine.FullSynapse;
import org.joone.engine.GaussLayer;
import org.joone.engine.LinearLayer;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.Pattern;
import org.joone.engine.SigmoidLayer;
import org.joone.engine.SineLayer;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.engine.listeners.DeltaBasedConvergenceObserver;
import org.joone.io.MemoryInputSynapse;
import org.joone.io.MemoryOutputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NeuralNet;
import org.joone.structure.Nakayama;

public class Parity_Structure_Nakayama
implements NeuralNetListener,
Serializable {
    private static final ILogger log = LoggerFactory.getLogger(Nakayama.class);
    private NeuralNet nnet = null;
    private MemoryInputSynapse inputSynapse;
    private MemoryInputSynapse desiredOutputSynapse;
    private MemoryOutputSynapse outputSynapse;
    private Nakayama nakayama;
    private double[][] inputArray = new double[][]{{0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 1.0, 1.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 1.0}, {0.0, 1.0, 1.0, 0.0}, {0.0, 1.0, 1.0, 1.0}, {1.0, 0.0, 0.0, 0.0}, {1.0, 0.0, 0.0, 1.0}, {1.0, 0.0, 1.0, 0.0}, {1.0, 0.0, 1.0, 1.0}, {1.0, 1.0, 0.0, 0.0}, {1.0, 1.0, 0.0, 1.0}, {1.0, 1.0, 1.0, 0.0}, {1.0, 1.0, 1.0, 1.0}};
    private double[][] desiredOutputArray = new double[][]{{0.0}, {1.0}, {1.0}, {0.0}, {1.0}, {0.0}, {0.0}, {1.0}, {1.0}, {0.0}, {0.0}, {1.0}, {0.0}, {1.0}, {1.0}, {0.0}};

    public static void main(String[] stringArray) {
        Parity_Structure_Nakayama parity_Structure_Nakayama = new Parity_Structure_Nakayama();
        parity_Structure_Nakayama.initNeuralNet();
        parity_Structure_Nakayama.train();
    }

    public void train() {
        this.inputSynapse.setInputArray(this.inputArray);
        this.inputSynapse.setAdvancedColumnSelector("1-4");
        this.desiredOutputSynapse.setInputArray(this.desiredOutputArray);
        this.desiredOutputSynapse.setAdvancedColumnSelector("1");
        Monitor monitor = this.nnet.getMonitor();
        monitor.setUseRMSE(false);
        monitor.setLearningRate(0.5);
        monitor.setMomentum(0.3);
        monitor.setTrainingPatterns(this.inputArray.length);
        monitor.setTotCicles(5000);
        monitor.setLearning(true);
        monitor.addLearner(0, "org.joone.engine.RpropLearner");
        monitor.addLearner(1, "org.joone.engine.BatchLearner");
        monitor.addLearner(2, "org.joone.engine.BasicLearner");
        monitor.setBatchSize(this.inputArray.length);
        monitor.setLearningMode(2);
        monitor.setSingleThreadMode(false);
        this.nnet.addNeuralNetListener(this);
        this.nnet.go();
    }

    private void test() {
        this.nnet.getMonitor().setTotCicles(1);
        this.nnet.getMonitor().setLearning(false);
        this.nnet.getMonitor().setSingleThreadMode(false);
        this.outputSynapse.setEnabled(true);
        this.nnet.removeAllListeners();
        this.nnet.go(true);
        Vector vector = this.outputSynapse.getAllPatterns();
        System.out.println("\nResults:");
        for (int i = vector.size(); i > 0; --i) {
            Pattern pattern = (Pattern)vector.elementAt(vector.size() - i);
            System.out.println("Output Pattern #" + (vector.size() - i) + " = " + pattern.getArray()[0]);
        }
        System.out.println("Final RMSE: " + this.nnet.getMonitor().getGlobalError());
    }

    protected void initNeuralNet() {
        LinearLayer linearLayer = new LinearLayer();
        SigmoidLayer sigmoidLayer = new SigmoidLayer();
        SineLayer sineLayer = new SineLayer();
        GaussLayer gaussLayer = new GaussLayer();
        SigmoidLayer sigmoidLayer2 = new SigmoidLayer();
        linearLayer.setRows(4);
        sigmoidLayer.setRows(8);
        sineLayer.setRows(8);
        gaussLayer.setRows(8);
        sigmoidLayer2.setRows(1);
        FullSynapse fullSynapse = new FullSynapse();
        FullSynapse fullSynapse2 = new FullSynapse();
        FullSynapse fullSynapse3 = new FullSynapse();
        FullSynapse fullSynapse4 = new FullSynapse();
        FullSynapse fullSynapse5 = new FullSynapse();
        FullSynapse fullSynapse6 = new FullSynapse();
        linearLayer.addOutputSynapse(fullSynapse);
        linearLayer.addOutputSynapse(fullSynapse2);
        linearLayer.addOutputSynapse(fullSynapse3);
        sigmoidLayer.addInputSynapse(fullSynapse);
        sineLayer.addInputSynapse(fullSynapse2);
        gaussLayer.addInputSynapse(fullSynapse3);
        sigmoidLayer.addOutputSynapse(fullSynapse4);
        sineLayer.addOutputSynapse(fullSynapse5);
        gaussLayer.addOutputSynapse(fullSynapse6);
        sigmoidLayer2.addInputSynapse(fullSynapse4);
        sigmoidLayer2.addInputSynapse(fullSynapse5);
        sigmoidLayer2.addInputSynapse(fullSynapse6);
        this.inputSynapse = new MemoryInputSynapse();
        linearLayer.addInputSynapse(this.inputSynapse);
        this.outputSynapse = new MemoryOutputSynapse();
        sigmoidLayer2.addOutputSynapse(this.outputSynapse);
        this.outputSynapse.setEnabled(false);
        this.desiredOutputSynapse = new MemoryInputSynapse();
        TeachingSynapse teachingSynapse = new TeachingSynapse();
        teachingSynapse.setDesired(this.desiredOutputSynapse);
        this.nnet = new NeuralNet();
        this.nnet.addLayer(linearLayer, 0);
        this.nnet.addLayer(sigmoidLayer, 1);
        this.nnet.addLayer(sineLayer, 1);
        this.nnet.addLayer(gaussLayer, 1);
        this.nnet.addLayer(sigmoidLayer2, 2);
        this.nnet.setTeacher(teachingSynapse);
        sigmoidLayer2.addOutputSynapse(teachingSynapse);
        this.nakayama = new Nakayama(this.nnet);
        this.nakayama.addLayer(sigmoidLayer);
        this.nakayama.addLayer(sineLayer);
        this.nakayama.addLayer(gaussLayer);
        DeltaBasedConvergenceObserver deltaBasedConvergenceObserver = new DeltaBasedConvergenceObserver();
        deltaBasedConvergenceObserver.setSize(5.0E-4);
        deltaBasedConvergenceObserver.setNeuralNet(this.nnet);
        deltaBasedConvergenceObserver.addConvergenceListener(this.nakayama);
        this.nnet.addNeuralNetListener(deltaBasedConvergenceObserver);
    }

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
        Monitor monitor = (Monitor)neuralNetEvent.getSource();
        int n = monitor.getTotCicles() - monitor.getCurrentCicle();
        if (n % 100 == 0) {
            System.out.println("Cycle: " + n + " (R)MSE:" + monitor.getGlobalError());
        }
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
    }

    public void netStopped(NeuralNetEvent neuralNetEvent) {
        this.test();
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
    }
}

