/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.engine.helpers;

import java.io.File;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.helpers.factory.JooneTools;
import org.joone.io.FileInputSynapse;
import org.joone.net.NeuralNet;
import org.joone.net.NeuralNetAttributes;
import org.joone.util.NormalizerPlugIn;

public class Validation_using_stream
implements NeuralNetListener {
    private static final String fileName = "org/joone/samples/engine/helpers/wine.txt";
    private static final int trainingRows = 150;
    private double[][] inputTrain;
    private double[][] desiredTrain;
    private double[][] inputTest;
    private double[][] desiredTest;

    public static void main(String[] stringArray) {
        Validation_using_stream validation_using_stream = new Validation_using_stream();
        validation_using_stream.go();
    }

    private void go() {
        FileInputSynapse fileInputSynapse = new FileInputSynapse();
        fileInputSynapse.setInputFile(new File(fileName));
        fileInputSynapse.setAdvancedColumnSelector("1-14");
        NormalizerPlugIn normalizerPlugIn = new NormalizerPlugIn();
        normalizerPlugIn.setAdvancedSerieSelector("2-14");
        normalizerPlugIn.setMin(-1.0);
        normalizerPlugIn.setMax(1.0);
        fileInputSynapse.addPlugIn(normalizerPlugIn);
        NormalizerPlugIn normalizerPlugIn2 = new NormalizerPlugIn();
        normalizerPlugIn2.setAdvancedSerieSelector("1");
        fileInputSynapse.addPlugIn(normalizerPlugIn2);
        this.inputTrain = JooneTools.getDataFromStream(fileInputSynapse, 1, 150, 2, 14);
        this.desiredTrain = JooneTools.getDataFromStream(fileInputSynapse, 1, 150, 1, 1);
        this.inputTest = JooneTools.getDataFromStream(fileInputSynapse, 151, 178, 2, 14);
        this.desiredTest = JooneTools.getDataFromStream(fileInputSynapse, 151, 178, 1, 1);
        int[] nArray = new int[]{13, 4, 1};
        NeuralNet neuralNet = JooneTools.create_standard(nArray, 2);
        neuralNet.getMonitor().setLearningRate(0.3);
        neuralNet.getMonitor().setMomentum(0.5);
        JooneTools.train(neuralNet, this.inputTrain, this.desiredTrain, 5000, 0.01, 100, this, false);
        NeuralNetAttributes neuralNetAttributes = neuralNet.getDescriptor();
        System.out.println("Last training rmse=" + neuralNetAttributes.getTrainingError() + " at epoch " + neuralNetAttributes.getLastEpoch());
        double[][] dArray = JooneTools.compare(neuralNet, this.inputTest, this.desiredTest);
        System.out.println("Comparion of the last " + dArray.length + " rows:");
        int n = dArray[0].length / 2;
        for (int i = 0; i < dArray.length; ++i) {
            int n2;
            System.out.print("\nOutput: ");
            for (n2 = 0; n2 < n; ++n2) {
                System.out.print(dArray[i][n2] + " ");
            }
            System.out.print("\tTarget: ");
            for (n2 = n; n2 < n * 2; ++n2) {
                System.out.print(dArray[i][n2] + " ");
            }
        }
    }

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
        Monitor monitor = (Monitor)neuralNetEvent.getSource();
        int n = monitor.getTotCicles() - monitor.getCurrentCicle() + 1;
        double d = monitor.getGlobalError();
        NeuralNet neuralNet = neuralNetEvent.getNeuralNet().cloneNet();
        double d2 = JooneTools.test(neuralNet, this.inputTest, this.desiredTest);
        System.out.println("Epoch " + n + ":\n\tTraining error=" + d + "\n\tValidation error=" + d2);
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
        System.out.println("Training...");
    }

    public void netStopped(NeuralNetEvent neuralNetEvent) {
        System.out.println("Training stopped.");
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
        System.out.println("Training stopped with error " + string);
    }
}

