/*
 * Decompiled with CFR 0.152.
 */
package org.joone.samples.editor.som;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.joone.samples.editor.som.ImageDrawer;
import org.joone.samples.editor.som.ImagePainter;

public class SOMImageTester
extends JFrame {
    private int DrawSizeX = 81;
    private int DrawSizeY = 81;
    private int ScaleSizeX = 9;
    private int ScaleSizeY = 9;
    private Vector imageHolder = new Vector();
    private Image downsamplePreviewImage = null;
    private BufferedImage downSample = new BufferedImage(this.getScaleSizeX(), this.getScaleSizeY(), 1);
    private BufferedImage drawImage = new BufferedImage(this.getDrawSizeX(), this.getDrawSizeY(), 1);
    private Vector idHolder = new Vector();
    private int currentImage = 0;
    private boolean alone;
    protected int downSampleLeft;
    protected int downSampleRight;
    protected int downSampleTop;
    protected int downSampleBottom;
    protected double ratioX;
    protected double ratioY;
    protected int[] pixelMap;
    private JButton ClearImageButton;
    private JPanel ControlPanel;
    private JButton DownSampleButton;
    private JPanel DownsamplePanel;
    private JButton HelpButton;
    private JTextField IDInputTextField;
    private JPanel ImageHolderPanel;
    private JLabel ImageIDLabel;
    private JLabel ImageNoLabel;
    private JScrollBar ImageScrollBar;
    private JPanel InfoPanel;
    private JButton NewImageButton;
    private JPanel PainterPanel;
    private JButton QuitButton;
    private JButton SaveImagesButton;

    public SOMImageTester() {
        this(false);
    }

    public SOMImageTester(boolean bl) {
        this.alone = bl;
        this.initComponents();
        this.setup();
        this.setSize(300, 350);
        this.setResizable(false);
    }

    private void initComponents() {
        this.ImageHolderPanel = new JPanel();
        this.PainterPanel = new ImagePainter();
        this.DownsamplePanel = new ImageDrawer();
        this.InfoPanel = new JPanel();
        this.ImageIDLabel = new JLabel();
        this.IDInputTextField = new JTextField();
        this.ImageNoLabel = new JLabel();
        this.DownSampleButton = new JButton();
        this.ImageScrollBar = new JScrollBar();
        this.ControlPanel = new JPanel();
        this.HelpButton = new JButton();
        this.NewImageButton = new JButton();
        this.ClearImageButton = new JButton();
        this.SaveImagesButton = new JButton();
        this.QuitButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SOMImageTester.this.exitForm(windowEvent);
            }
        });
        this.ImageHolderPanel.setLayout(new GridLayout(1, 2));
        this.PainterPanel.setToolTipText("You can draw on this image.");
        this.ImageHolderPanel.add(this.PainterPanel);
        this.DownsamplePanel.setToolTipText("This contains the down sampled image.");
        this.ImageHolderPanel.add(this.DownsamplePanel);
        this.getContentPane().add((Component)this.ImageHolderPanel, "Center");
        this.InfoPanel.setLayout(new GridLayout(2, 2));
        this.ImageIDLabel.setText("Image ID");
        this.InfoPanel.add(this.ImageIDLabel);
        this.IDInputTextField.setText("1");
        this.InfoPanel.add(this.IDInputTextField);
        this.ImageNoLabel.setFont(new Font("Dialog", 1, 14));
        this.ImageNoLabel.setText("Image 1 of 1");
        this.ImageNoLabel.setToolTipText("The current image number.");
        this.InfoPanel.add(this.ImageNoLabel);
        this.DownSampleButton.setText("Down Sample");
        this.DownSampleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SOMImageTester.this.DownSampleButtonActionPerformed(actionEvent);
            }
        });
        this.InfoPanel.add(this.DownSampleButton);
        this.getContentPane().add((Component)this.InfoPanel, "North");
        this.ImageScrollBar.setMaximum(1);
        this.ImageScrollBar.setMinimum(1);
        this.ImageScrollBar.setToolTipText("Use scroll bar to scroll through images.");
        this.ImageScrollBar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                SOMImageTester.this.OnScrolled(adjustmentEvent);
            }
        });
        this.getContentPane().add((Component)this.ImageScrollBar, "East");
        this.ControlPanel.setLayout(new GridLayout(5, 2));
        this.ControlPanel.setBorder(new TitledBorder("Controls"));
        this.HelpButton.setText("Help");
        this.HelpButton.setToolTipText("Help on this application.");
        this.HelpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SOMImageTester.this.HelpButtonActionPerformed(actionEvent);
            }
        });
        this.ControlPanel.add(this.HelpButton);
        this.NewImageButton.setText("New Image");
        this.NewImageButton.setToolTipText("Create a new image.");
        this.NewImageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SOMImageTester.this.NewImageButtonActionPerformed(actionEvent);
            }
        });
        this.ControlPanel.add(this.NewImageButton);
        this.ClearImageButton.setText("Clear Image");
        this.ClearImageButton.setToolTipText("Clear the drawing from this image.");
        this.ClearImageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SOMImageTester.this.ClearImageButtonActionPerformed(actionEvent);
            }
        });
        this.ControlPanel.add(this.ClearImageButton);
        this.SaveImagesButton.setText("Save Images");
        this.SaveImagesButton.setToolTipText("Save the images out to Joone format.");
        this.SaveImagesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SOMImageTester.this.SaveImagesButtonActionPerformed(actionEvent);
            }
        });
        this.ControlPanel.add(this.SaveImagesButton);
        this.QuitButton.setText("Quit");
        this.QuitButton.setToolTipText("Quit this application.");
        this.QuitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SOMImageTester.this.QuitButtonActionPerformed(actionEvent);
            }
        });
        this.ControlPanel.add(this.QuitButton);
        this.getContentPane().add((Component)this.ControlPanel, "South");
        this.pack();
    }

    private void HelpButtonActionPerformed(ActionEvent actionEvent) {
        String string = new String("This application allows the user to draw characters or images for recognition by a Joone neural network.");
        String string2 = new String("It is intended to test a SOM or Kohonen Network by providing an image recognition example.");
        String string3 = new String("The drawing image grid is 81 X 81 but the images saved in the file are 9x9 down sampled images.");
        String string4 = new String("The saved file has 81 inputs and an id.  The id can be used to identify the character.");
        String string5 = new String("Read the Editor's help pages to learn how to use this example.");
        JOptionPane.showMessageDialog(this, string + "\n" + string2 + "\n" + string3 + "\n" + string4 + "\n" + string5);
    }

    private void QuitButtonActionPerformed(ActionEvent actionEvent) {
        this.exitTester();
    }

    private void SaveImagesButtonActionPerformed(ActionEvent actionEvent) {
        this.SaveImagesOut();
    }

    private void NewImageButtonActionPerformed(ActionEvent actionEvent) {
        this.NewImage();
    }

    private void ClearImageButtonActionPerformed(ActionEvent actionEvent) {
        this.clearCurrentImage();
    }

    private void DownSampleButtonActionPerformed(ActionEvent actionEvent) {
        this.downSample();
        this.repaint();
    }

    private void OnScrolled(AdjustmentEvent adjustmentEvent) {
        Integer n = null;
        if (adjustmentEvent.getAdjustmentType() == 5 && adjustmentEvent.getValue() <= this.imageHolder.size()) {
            try {
                n = new Integer(this.IDInputTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                this.ImageScrollBar.setValue(this.ImageScrollBar.getValue() - this.ImageScrollBar.getUnitIncrement());
                JOptionPane.showMessageDialog(this, "ID must be an integer value.");
                return;
            }
            this.idHolder.set(this.currentImage - 1, n);
            this.currentImage = adjustmentEvent.getValue();
            this.IDInputTextField.setText("" + (Integer)this.idHolder.get(this.currentImage - 1));
            this.drawImage = (BufferedImage)this.imageHolder.get(this.currentImage - 1);
            ((ImagePainter)this.PainterPanel).setImageToEdit(this.drawImage);
            this.downSample();
            this.ImageNoLabel.setText("Image 1 of " + this.currentImage);
            this.repaint();
        }
    }

    private void exitForm(WindowEvent windowEvent) {
        this.exitTester();
    }

    private void exitTester() {
        if (this.alone) {
            System.exit(0);
        } else {
            this.dispose();
        }
    }

    public void setup() {
        if (this.imageHolder != null) {
            this.drawImage.getGraphics().setColor(new Color(255, 255, 255));
            this.drawImage.getGraphics().fillRect(0, 0, this.drawImage.getWidth(), this.drawImage.getHeight());
            this.imageHolder.add(this.drawImage);
            ((ImagePainter)this.PainterPanel).setImageToEdit(this.drawImage);
            if (this.downsamplePreviewImage != null) {
                this.downsamplePreviewImage.getGraphics().setColor(Color.WHITE);
                this.downsamplePreviewImage.getGraphics().fillRect(0, 0, this.downsamplePreviewImage.getWidth(this), this.downsamplePreviewImage.getHeight(this));
                ((ImageDrawer)this.DownsamplePanel).setImageToDraw(this.downsamplePreviewImage);
            }
            this.idHolder.add(new Integer(1));
            this.currentImage = 1;
        }
        this.repaint();
    }

    public static void main(String[] stringArray) {
        new SOMImageTester().show();
    }

    public int getDrawSizeX() {
        return this.DrawSizeX;
    }

    public void setDrawSizeX(int n) {
        this.DrawSizeX = n;
    }

    public int getDrawSizeY() {
        return this.DrawSizeY;
    }

    public void setDrawSizeY(int n) {
        this.DrawSizeY = n;
    }

    public int getScaleSizeX() {
        return this.ScaleSizeX;
    }

    public void setScaleSizeX(int n) {
        this.ScaleSizeX = n;
    }

    public int getScaleSizeY() {
        return this.ScaleSizeY;
    }

    public void setScaleSizeY(int n) {
        this.ScaleSizeY = n;
    }

    public void clearCurrentImage() {
        this.drawImage.getGraphics().setColor(Color.WHITE);
        this.drawImage.getGraphics().fillRect(0, 0, this.drawImage.getWidth(), this.drawImage.getHeight());
        this.downSample();
        this.repaint();
    }

    public void NewImage() {
        if (this.imageHolder != null && this.idHolder != null) {
            this.downSample = new BufferedImage(this.getScaleSizeX(), this.getScaleSizeY(), 1);
            this.drawImage = new BufferedImage(this.getDrawSizeX(), this.getDrawSizeY(), 1);
            this.clearCurrentImage();
            Integer n = (Integer)this.idHolder.get(this.currentImage - 1);
            ++this.currentImage;
            this.imageHolder.add(this.drawImage);
            this.idHolder.add(n);
            this.IDInputTextField.setText("" + n);
            this.ImageScrollBar.setMaximum(this.currentImage);
            this.ImageScrollBar.setValue(this.currentImage);
            ((ImagePainter)this.PainterPanel).setImageToEdit(this.drawImage);
            ((ImageDrawer)this.DownsamplePanel).setImageToDraw(this.downsamplePreviewImage);
            this.ImageNoLabel.setText("Image 1 of " + this.currentImage);
            this.repaint();
        }
    }

    protected boolean hLineClear(int n) {
        int n2 = this.drawImage.getWidth(this);
        for (int i = 0; i < n2; ++i) {
            if (this.pixelMap[n * n2 + i] == -1) continue;
            return false;
        }
        return true;
    }

    protected boolean vLineClear(int n) {
        int n2 = this.drawImage.getWidth(this);
        int n3 = this.drawImage.getHeight(this);
        for (int i = 0; i < n3; ++i) {
            if (this.pixelMap[i * n2 + n] == -1) continue;
            return false;
        }
        return true;
    }

    protected void findBounds(int n, int n2) {
        int n3;
        for (n3 = 0; n3 < n2; ++n3) {
            if (this.hLineClear(n3)) continue;
            this.downSampleTop = n3;
            break;
        }
        for (n3 = n2 - 1; n3 >= 0; --n3) {
            if (this.hLineClear(n3)) continue;
            this.downSampleBottom = n3;
            break;
        }
        for (n3 = 0; n3 < n; ++n3) {
            if (this.vLineClear(n3)) continue;
            this.downSampleLeft = n3;
            break;
        }
        for (n3 = n - 1; n3 >= 0; --n3) {
            if (this.vLineClear(n3)) continue;
            this.downSampleRight = n3;
            break;
        }
    }

    protected boolean downSampleQuadrant(int n, int n2) {
        int n3 = this.drawImage.getWidth(this);
        int n4 = (int)((double)this.downSampleLeft + (double)n * this.ratioX);
        int n5 = (int)((double)this.downSampleTop + (double)n2 * this.ratioY);
        int n6 = (int)((double)n4 + this.ratioX);
        int n7 = (int)((double)n5 + this.ratioY);
        for (int i = n5; i <= n7; ++i) {
            for (int j = n4; j <= n6; ++j) {
                int n8 = j + i * n3;
                if (this.pixelMap[n8] == -1) continue;
                return true;
            }
        }
        return false;
    }

    public void downSample() {
        int n = this.drawImage.getWidth(this);
        int n2 = this.drawImage.getHeight(this);
        PixelGrabber pixelGrabber = new PixelGrabber(this.drawImage, 0, 0, n, n2, true);
        try {
            pixelGrabber.grabPixels();
            this.pixelMap = (int[])pixelGrabber.getPixels();
            this.findBounds(n, n2);
            this.ratioX = (double)(this.downSampleRight - this.downSampleLeft) / (double)this.downSample.getWidth();
            this.ratioY = (double)(this.downSampleBottom - this.downSampleTop) / (double)this.downSample.getHeight();
            for (int i = 0; i < this.downSample.getHeight(); ++i) {
                for (int j = 0; j < this.downSample.getWidth(); ++j) {
                    if (this.downSampleQuadrant(j, i)) {
                        this.downSample.setRGB(j, i, Color.BLACK.getRGB());
                        continue;
                    }
                    this.downSample.setRGB(j, i, Color.WHITE.getRGB());
                }
            }
            this.downsamplePreviewImage = this.downSample.getScaledInstance(this.getDrawSizeX(), this.getDrawSizeY(), 1);
            if (this.downsamplePreviewImage != null) {
                ((ImageDrawer)this.DownsamplePanel).setImageToDraw(this.downsamplePreviewImage);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void SaveImagesOut() {
        FileOutputStream fileOutputStream = null;
        DataOutputStream dataOutputStream = null;
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showSaveDialog(this);
        try {
            if (n == 0) {
                fileOutputStream = new FileOutputStream(jFileChooser.getSelectedFile());
                dataOutputStream = new DataOutputStream(fileOutputStream);
                for (int i = 0; i < this.imageHolder.size(); ++i) {
                    this.drawImage = (BufferedImage)this.imageHolder.get(i);
                    this.downSample();
                    for (int j = 0; j < this.downSample.getHeight(); ++j) {
                        for (int k = 0; k < this.downSample.getWidth(); ++k) {
                            if (this.downSample.getRGB(k, j) == Color.BLACK.getRGB()) {
                                dataOutputStream.writeBytes("1.0;");
                                continue;
                            }
                            dataOutputStream.writeBytes("0.0;");
                        }
                    }
                    dataOutputStream.writeBytes((Integer)this.idHolder.get(i) + "\n");
                }
            }
        }
        catch (IOException iOException) {
            JOptionPane.showInternalMessageDialog(this, "An error occurred while trying to write to the file. Error is " + iOException.toString());
        }
    }
}

