/*
 * Decompiled with CFR 0.152.
 */
package org.joone.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NeuralNet;

public class NeuralNetLoader {
    private static final ILogger log = LoggerFactory.getLogger(NeuralNetLoader.class);
    NeuralNet nnet;

    public NeuralNetLoader(String string) {
        try {
            this.nnet = this.readNeuralNet(string);
        }
        catch (Exception exception) {
            log.error("Cannot create the NeuralNet with the following name : \"" + string + "\"", exception);
        }
    }

    public NeuralNet getNeuralNet() {
        return this.nnet;
    }

    private NeuralNet readNeuralNet(String string) throws IOException, ClassNotFoundException {
        if (string == null) {
            return null;
        }
        if (string.equals("")) {
            return null;
        }
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        NeuralNet neuralNet = (NeuralNet)objectInputStream.readObject();
        objectInputStream.close();
        fileInputStream.close();
        return neuralNet;
    }
}

