/*
 * Decompiled with CFR 0.152.
 */
package org.joone.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.InputPatternListener;
import org.joone.engine.Layer;
import org.joone.engine.Matrix;
import org.joone.engine.Monitor;
import org.joone.engine.NetStoppedEventNotifier;
import org.joone.engine.NeuralLayer;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.Pattern;
import org.joone.engine.Synapse;
import org.joone.engine.learning.AbstractTeacherSynapse;
import org.joone.engine.learning.ComparingElement;
import org.joone.exception.JooneRuntimeException;
import org.joone.helpers.structure.ConnectionHelper;
import org.joone.helpers.structure.NeuralNetMatrix;
import org.joone.io.StreamInputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;
import org.joone.net.NeuralNetAttributes;
import org.joone.script.MacroInterface;

public class NeuralNet
implements NeuralLayer,
NeuralNetListener,
Serializable {
    private static final int MAJOR_RELEASE = 2;
    private static final int MINOR_RELEASE = 0;
    private static final int BUILD = 0;
    private static final String SUFFIX = "RC2";
    private static final ILogger log = LoggerFactory.getLogger(NeuralNet.class);
    private Vector layers = new Vector();
    private String NetName;
    private Monitor mon = new Monitor();
    private Layer inputLayer;
    private Layer outputLayer;
    private ComparingElement teacher;
    private static final long serialVersionUID = 8351124226081783962L;
    public static final int INPUT_LAYER = 0;
    public static final int HIDDEN_LAYER = 1;
    public static final int OUTPUT_LAYER = 2;
    protected Vector listeners;
    private MacroInterface macroPlugin;
    private boolean scriptingEnabled = false;
    private NeuralNetAttributes descriptor = null;
    private Hashtable params;
    private Layer[] orderedLayers = null;
    private transient Layer[] intOrderedLayers = null;
    private static final String OUTPUT_LAYER_FOR_NEURAL_NETWORK_NOT_FOUND = "Output layer for neural network not found.";
    private static final String INPUT_LAYER_FOR_NEURAL_NETWORK_NOT_FOUND = "Input layer for neural network not found.";
    private transient Thread singleThread = null;
    private boolean stopFastRun;

    public void start() {
        this.terminate(false);
        boolean bl = this.readyToStart();
        if (!bl) {
            String string = "NeuralNet: The neural net is already running or start was interrupted.";
            log.warn(string);
            throw new JooneRuntimeException(string);
        }
        this.getMonitor().addNeuralNetListener(this, false);
        try {
            for (int i = 0; i < this.layers.size(); ++i) {
                Layer layer = (Layer)this.layers.elementAt(i);
                layer.start();
            }
        }
        catch (RuntimeException runtimeException) {
            this.stop();
            String string = "RuntimeException was thrown while starting the neural network. Message is:" + runtimeException.getMessage();
            log.error(string, runtimeException);
            throw new JooneRuntimeException(string, runtimeException);
        }
    }

    private boolean readyToStart() {
        for (int i = 0; i < 100; ++i) {
            if (!this.isRunning()) {
                return true;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                log.warn("Interruption during starting of neural net. Aborting.");
                return false;
            }
        }
        return false;
    }

    public void join() {
        if (this.getMonitor().isSingleThreadMode()) {
            if (this.getSingleThread() != null) {
                try {
                    this.getSingleThread().join();
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            for (int i = 0; i < this.layers.size(); ++i) {
                Layer layer = (Layer)this.layers.elementAt(i);
                layer.join();
            }
            if (this.teacher != null) {
                this.teacher.getTheLinearLayer().join();
            }
        }
    }

    public void stop() {
        if (this.getMonitor().isSingleThreadMode()) {
            this.stopFastRun();
        } else {
            this.getMonitor().Stop();
        }
    }

    public void terminate(boolean bl) {
        Monitor monitor;
        if (!this.isRunning()) {
            log.warn("Termination requested but net appears not to be running.");
            return;
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer layer = (Layer)this.layers.elementAt(i);
            layer.stop();
        }
        if (this.teacher != null) {
            this.teacher.getTheLinearLayer().stop();
            if (this.teacher instanceof AbstractTeacherSynapse) {
                ((AbstractTeacherSynapse)((Object)this.teacher)).netStoppedError();
            }
        }
        if ((monitor = this.getMonitor()) != null && bl) {
            new NetStoppedEventNotifier(monitor).start();
        }
    }

    public void terminate() {
        this.terminate(true);
    }

    protected int getNumOfstepCounters() {
        StreamInputSynapse streamInputSynapse;
        int n = 0;
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer layer = (Layer)this.layers.elementAt(i);
            if (!layer.hasStepCounter()) continue;
            ++n;
        }
        if (this.teacher != null && (streamInputSynapse = this.teacher.getDesired()) != null && streamInputSynapse.isStepCounter()) {
            ++n;
        }
        return n;
    }

    public Layer getInputLayer() {
        if (this.inputLayer != null) {
            return this.inputLayer;
        }
        this.setInputLayer(this.findInputLayer());
        return this.inputLayer;
    }

    public Layer findInputLayer() {
        Vector vector = this.getLayersWarningly();
        if (vector == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Layer layer = (Layer)vector.elementAt(i);
            if (!layer.isInputLayer()) continue;
            return layer;
        }
        return null;
    }

    private Vector getLayersWarningly() {
        if (this.layers == null) {
            log.warn("Network has no layers");
            return null;
        }
        return this.layers;
    }

    public Layer getOutputLayer() {
        if (this.outputLayer != null) {
            return this.outputLayer;
        }
        this.setOutputLayer(this.findOutputLayer());
        return this.outputLayer;
    }

    public Layer findOutputLayer() {
        Vector vector = this.getLayersWarningly();
        if (vector == null) {
            return null;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Layer layer = (Layer)vector.elementAt(i);
            if (!layer.isOutputLayer()) continue;
            return layer;
        }
        return null;
    }

    public int getRows() {
        Layer layer = this.getInputLayer();
        if (layer != null) {
            return layer.getRows();
        }
        return 0;
    }

    public void setRows(int n) {
        Layer layer = this.getInputLayer();
        if (layer == null) {
            log.warn("Input layer for neural network not found. setRows ignored.");
            return;
        }
        layer.setRows(n);
    }

    public void addNoise(double d) {
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer layer = (Layer)this.layers.elementAt(i);
            layer.addNoise(d);
        }
    }

    public void randomize(double d) {
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer layer = (Layer)this.layers.elementAt(i);
            layer.randomize(d);
        }
    }

    public Matrix getBias() {
        Layer layer = this.getInputLayer();
        if (layer == null) {
            log.warn(INPUT_LAYER_FOR_NEURAL_NETWORK_NOT_FOUND);
            return null;
        }
        return layer.getBias();
    }

    public Vector getAllOutputs() {
        Layer layer = this.getOutputLayer();
        if (layer == null) {
            return null;
        }
        return layer.getAllOutputs();
    }

    public String getLayerName() {
        return this.NetName;
    }

    public void removeOutputSynapse(OutputPatternListener outputPatternListener) {
        Layer layer = this.getOutputLayer();
        if (layer == null) {
            log.warn(OUTPUT_LAYER_FOR_NEURAL_NETWORK_NOT_FOUND);
            return;
        }
        layer.removeOutputSynapse(outputPatternListener);
    }

    public void setAllInputs(Vector vector) {
        Layer layer = this.getInputLayer();
        if (layer == null) {
            log.warn(INPUT_LAYER_FOR_NEURAL_NETWORK_NOT_FOUND);
            return;
        }
        layer.setAllInputs(vector);
    }

    public void removeAllOutputs() {
        Layer layer = this.getOutputLayer();
        if (layer != null) {
            layer.removeAllOutputs();
        }
        this.setTeacher(null);
    }

    public Vector getAllInputs() {
        Layer layer = this.getInputLayer();
        if (layer == null) {
            return null;
        }
        return layer.getAllInputs();
    }

    public boolean addOutputSynapse(OutputPatternListener outputPatternListener) {
        Layer layer = this.getOutputLayer();
        if (layer == null) {
            return false;
        }
        return layer.addOutputSynapse(outputPatternListener);
    }

    public void setBias(Matrix matrix) {
        Layer layer = this.getInputLayer();
        if (layer == null) {
            log.warn(INPUT_LAYER_FOR_NEURAL_NETWORK_NOT_FOUND);
            return;
        }
        layer.setBias(matrix);
    }

    public void removeInputSynapse(InputPatternListener inputPatternListener) {
        Layer layer = this.getInputLayer();
        if (layer == null) {
            log.warn(INPUT_LAYER_FOR_NEURAL_NETWORK_NOT_FOUND);
            return;
        }
        layer.removeInputSynapse(inputPatternListener);
    }

    public void setLayerName(String string) {
        this.NetName = string;
    }

    public boolean addInputSynapse(InputPatternListener inputPatternListener) {
        Layer layer = this.getInputLayer();
        if (layer == null) {
            log.warn(INPUT_LAYER_FOR_NEURAL_NETWORK_NOT_FOUND);
            return false;
        }
        return layer.addInputSynapse(inputPatternListener);
    }

    public void setAllOutputs(Vector vector) {
        Layer layer = this.getOutputLayer();
        if (layer == null) {
            log.warn(OUTPUT_LAYER_FOR_NEURAL_NETWORK_NOT_FOUND);
            return;
        }
        layer.setAllOutputs(vector);
    }

    public void setMonitor(Monitor monitor) {
        boolean bl = this.isScriptingEnabled();
        this.mon = monitor;
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer layer = (Layer)this.layers.elementAt(i);
            layer.setMonitor(this.mon);
        }
        this.setScriptingEnabled(bl);
        if (this.getTeacher() != null) {
            this.getTeacher().setMonitor(monitor);
        }
    }

    public Monitor getMonitor() {
        return this.mon;
    }

    public void removeAllInputs() {
        Layer layer = this.getInputLayer();
        if (layer == null) {
            log.warn(INPUT_LAYER_FOR_NEURAL_NETWORK_NOT_FOUND);
            return;
        }
        layer.removeAllInputs();
    }

    public NeuralLayer copyInto(NeuralLayer neuralLayer) {
        throw new UnsupportedOperationException();
    }

    public void addLayer(Layer layer) {
        this.addLayer(layer, 1);
    }

    public void addLayer(Layer layer, int n) {
        if (!this.layers.contains(layer)) {
            layer.setMonitor(this.mon);
            this.layers.addElement(layer);
        }
        if (n == 0) {
            this.setInputLayer(layer);
        }
        if (n == 2) {
            this.setOutputLayer(layer);
        }
    }

    public void removeLayer(Layer layer) {
        if (!this.layers.contains(layer)) {
            log.warn("Neural net does not contain layer requested to be removed.");
            return;
        }
        this.layers.removeElement(layer);
        NeuralNetMatrix neuralNetMatrix = new NeuralNetMatrix(this);
        Synapse[][] synapseArray = neuralNetMatrix.getConnectionMatrix();
        this.removeSynapses(neuralNetMatrix.getLayerInd(layer), synapseArray);
        if (layer == this.inputLayer) {
            this.setInputLayer(null);
        }
        if (layer == this.outputLayer) {
            this.setOutputLayer(null);
        }
    }

    private void removeSynapses(int n, Synapse[][] synapseArray) {
        int n2;
        if (n < 0) {
            log.warn("Index out of range in removeSynapses");
            return;
        }
        Object e = this.layers.get(n);
        for (n2 = 0; n2 < synapseArray.length; ++n2) {
            if (synapseArray[n2][n] == null) continue;
            ConnectionHelper.disconnect(this.layers.get(n2), e);
        }
        for (n2 = 0; n2 < synapseArray[0].length; ++n2) {
            if (synapseArray[n][n2] == null) continue;
            ConnectionHelper.disconnect(e, this.layers.get(n2));
        }
    }

    public void resetInput() {
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer layer = (Layer)this.layers.elementAt(i);
            Vector vector = layer.getAllInputs();
            if (vector == null) continue;
            for (int j = 0; j < vector.size(); ++j) {
                InputPatternListener inputPatternListener = (InputPatternListener)vector.elementAt(j);
                if (!(inputPatternListener instanceof StreamInputSynapse)) continue;
                ((StreamInputSynapse)inputPatternListener).resetInput();
            }
        }
        if (this.getTeacher() != null) {
            this.getTeacher().resetInput();
        }
    }

    public void addNeuralNetListener(NeuralNetListener neuralNetListener) {
        if (this.getListeners().contains(neuralNetListener)) {
            log.warn("Provided listener already registered in network. Ignoring.");
            return;
        }
        this.listeners.addElement(neuralNetListener);
        if (this.getMonitor() != null) {
            this.getMonitor().addNeuralNetListener(neuralNetListener);
        }
    }

    public Vector getListeners() {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        return this.listeners;
    }

    public void removeNeuralNetListener(NeuralNetListener neuralNetListener) {
        Vector vector = this.getListeners();
        if (!vector.contains(neuralNetListener)) {
            log.warn("Provided listener not registered in network. Ignoring.");
            return;
        }
        vector.removeElement(neuralNetListener);
        Monitor monitor = this.getMonitor();
        if (monitor != null) {
            monitor.removeNeuralNetListener(neuralNetListener);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Vector vector = this.getListeners();
        Monitor monitor = this.getMonitor();
        if (monitor != null) {
            for (int i = 0; i < vector.size(); ++i) {
                monitor.addNeuralNetListener((NeuralNetListener)vector.elementAt(i));
            }
        }
        this.setMacroPlugin(this.macroPlugin);
    }

    public static String getVersion() {
        return "2.0.0RC2";
    }

    public static Integer getNumericVersion() {
        return new Integer(2000000);
    }

    public Layer getLayer(String string) {
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer layer = (Layer)this.layers.elementAt(i);
            if (layer.getLayerName().compareToIgnoreCase(string) != 0) continue;
            return layer;
        }
        return null;
    }

    public Vector getLayers() {
        return this.layers;
    }

    public void setLayers(Vector vector) {
        this.layers = vector;
    }

    public void setLayersList(List list) {
        this.setLayers(new Vector(list));
    }

    public void setTeacher(ComparingElement comparingElement) {
        Monitor monitor = this.getMonitor();
        if (monitor != null) {
            if (comparingElement != null) {
                monitor.setSupervised(true);
            } else {
                monitor.setSupervised(false);
            }
        }
        this.teacher = comparingElement;
    }

    public ComparingElement getTeacher() {
        return this.teacher;
    }

    public void setListeners(Vector vector) {
        throw new UnsupportedOperationException();
    }

    public void setInputLayer(Layer layer) {
        this.inputLayer = layer;
    }

    public void setOutputLayer(Layer layer) {
        this.outputLayer = layer;
    }

    public NeuralNetAttributes getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new NeuralNetAttributes();
            this.descriptor.setNeuralNetName(this.getLayerName());
        }
        return this.descriptor;
    }

    public void setDescriptor(NeuralNetAttributes neuralNetAttributes) {
        this.descriptor = neuralNetAttributes;
    }

    public boolean isRunning() {
        if (this.getMonitor().isSingleThreadMode()) {
            if (this.getSingleThread() != null && this.getSingleThread().isAlive()) {
                return true;
            }
        } else {
            for (int i = 0; i < this.layers.size(); ++i) {
                Layer layer = (Layer)this.layers.elementAt(i);
                if (!layer.isRunning()) continue;
                return true;
            }
            if (this.teacher != null && this.teacher.getTheLinearLayer().isRunning()) {
                return true;
            }
        }
        return false;
    }

    public NeuralNet cloneNet() {
        NeuralNet neuralNet = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            neuralNet = (NeuralNet)objectInputStream.readObject();
        }
        catch (Exception exception) {
            log.warn("IOException while cloning the Net. Message is : " + exception.getMessage(), exception);
        }
        return neuralNet;
    }

    public void removeAllListeners() {
        this.listeners = null;
        Monitor monitor = this.getMonitor();
        if (monitor != null) {
            monitor.removeAllListeners();
        }
    }

    public void setScriptingEnabled(boolean bl) {
        this.scriptingEnabled = bl;
        if (bl) {
            MacroInterface macroInterface = this.getMacroPlugin();
            if (macroInterface == null) {
                log.info("MacroPlugin not set: Impossible to enable the scripting");
            } else {
                this.addNeuralNetListener(this.getMacroPlugin());
            }
        } else if (this.macroPlugin != null) {
            this.removeNeuralNetListener(this.macroPlugin);
        }
    }

    public boolean isScriptingEnabled() {
        return this.scriptingEnabled;
    }

    public MacroInterface getMacroPlugin() {
        return this.macroPlugin;
    }

    public void setMacroPlugin(MacroInterface macroInterface) {
        if (macroInterface != null) {
            this.removeNeuralNetListener(this.macroPlugin);
            if (this.scriptingEnabled) {
                this.addNeuralNetListener(macroInterface);
            }
        }
        this.macroPlugin = macroInterface;
        if (macroInterface != null) {
            macroInterface.set("jNet", this);
            macroInterface.set("jMon", this.getMonitor());
        }
    }

    public Object getParam(String string) {
        if (this.params == null) {
            return null;
        }
        return this.params.get(string);
    }

    public void setParam(String string, Object object) {
        if (this.params == null) {
            this.params = new Hashtable();
        }
        if (this.params.containsKey(string)) {
            this.params.remove(string);
        }
        this.params.put(string, object);
    }

    public String[] getKeys() {
        if (this.params == null) {
            return null;
        }
        String[] stringArray = new String[this.params.keySet().size()];
        Enumeration enumeration = this.params.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public TreeSet check() {
        TreeSet<NetCheck> treeSet = new TreeSet<NetCheck>();
        if (this.layers == null || this.layers.isEmpty()) {
            treeSet.add(new NetCheck(0, "The Neural Network doesn't contain any layer", this.mon));
            return treeSet;
        }
        if (this.getNumOfstepCounters() > 1) {
            treeSet.add(new NetCheck(0, "More than one InputSynapse having stepCounter set to true is present", this.mon));
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            Layer layer = (Layer)this.layers.elementAt(i);
            treeSet.addAll(layer.check());
        }
        if (this.mon.getParent() == null) {
            if (this.teacher != null) {
                treeSet.addAll(this.teacher.check());
                if (this.mon != null && this.mon.isLearning() && !this.mon.isSupervised()) {
                    treeSet.add(new NetCheck(1, "Teacher is present: the supervised property should be set to true", this.mon));
                }
            } else if (this.mon != null && this.mon.isLearning() && this.mon.isSupervised()) {
                treeSet.add(new NetCheck(0, "Teacher not present: set to false the supervised property", this.mon));
            }
        }
        if (this.mon != null) {
            treeSet.addAll(this.mon.check());
        }
        return treeSet;
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
    }

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
    }

    public void netStopped(NeuralNetEvent neuralNetEvent) {
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
        this.terminate(false);
    }

    public void setOrderedLayers(Layer[] layerArray) {
        this.orderedLayers = layerArray;
    }

    public Layer[] getOrderedLayers() {
        return this.orderedLayers;
    }

    public Layer[] calculateOrderedLayers() {
        Layer[] layerArray = this.getOrderedLayers();
        if (layerArray == null) {
            if (this.intOrderedLayers == null) {
                NeuralNetMatrix neuralNetMatrix = new NeuralNetMatrix(this);
                this.intOrderedLayers = neuralNetMatrix.getOrderedLayers();
            }
        } else {
            this.intOrderedLayers = layerArray;
        }
        return this.intOrderedLayers;
    }

    public void go(boolean bl, boolean bl2) {
        this.getMonitor().setSingleThreadMode(bl);
        this.go(bl2);
    }

    public void go(boolean bl) {
        if (this.getMonitor().isSingleThreadMode()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    NeuralNet.this.fastRun();
                }
            };
            this.setSingleThread(new Thread(runnable));
            this.getSingleThread().start();
        } else {
            this.start();
            this.getMonitor().Go();
        }
        if (bl) {
            this.join();
        }
    }

    public void go() {
        this.go(false);
    }

    public void restore(boolean bl) {
        if (this.getMonitor().isSingleThreadMode()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    NeuralNet.this.fastContinue();
                }
            };
            this.setSingleThread(new Thread(runnable));
            this.getSingleThread().start();
        } else {
            this.start();
            this.getMonitor().runAgain();
        }
        if (bl) {
            this.join();
        }
    }

    public void restore() {
        this.restore(false);
    }

    protected void fastRun() {
        this.fastRun(this.getMonitor().getTotCicles(), false);
    }

    protected void fastContinue() {
        this.fastRun(this.getMonitor().getCurrentCicle(), true);
    }

    protected void fastRun(int n, boolean bl) {
        int n2;
        int n3;
        Monitor monitor = this.getMonitor();
        monitor.setSingleThreadMode(true);
        int n4 = n;
        int n5 = monitor.getNumOfPatterns();
        Layer[] layerArray = this.calculateOrderedLayers();
        if (!bl) {
            n3 = layerArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                layerArray[n2].init();
            }
        }
        this.stopFastRun = false;
        monitor.fireNetStarted();
        for (n3 = n4; n3 > 0; --n3) {
            monitor.setCurrentCicle(n3);
            for (n2 = 0; n2 < n5; ++n2) {
                this.stepForward(null);
                if (!monitor.isLearningCicle(n2 + 1)) continue;
                this.stepBackward(null);
            }
            monitor.fireCicleTerminated();
            if (this.stopFastRun) break;
        }
        Pattern pattern = Pattern.makeStopPattern(layerArray[0].getRows());
        this.stepForward(pattern);
        monitor.fireNetStopped();
    }

    public void singleStepForward(Pattern pattern) {
        this.getMonitor().setSingleThreadMode(true);
        Layer[] layerArray = this.calculateOrderedLayers();
        int n = layerArray.length;
        for (int i = 0; i < n; ++i) {
            layerArray[i].init();
        }
        this.stepForward(pattern);
    }

    public void singleStepBackward(Pattern pattern) {
        this.getMonitor().setSingleThreadMode(true);
        this.stepBackward(pattern);
    }

    protected void stepForward(Pattern pattern) {
        Layer[] layerArray = this.calculateOrderedLayers();
        int n = layerArray.length;
        layerArray[0].fwdRun(pattern);
        for (int i = 1; i < n; ++i) {
            layerArray[i].fwdRun(null);
        }
    }

    protected void stepBackward(Pattern pattern) {
        int n;
        Layer[] layerArray = this.calculateOrderedLayers();
        for (int i = n = layerArray.length; i > 0; --i) {
            layerArray[i - 1].revRun(pattern);
        }
    }

    protected void stopFastRun() {
        this.stopFastRun = true;
    }

    protected Thread getSingleThread() {
        return this.singleThread;
    }

    protected void setSingleThread(Thread thread) {
        this.singleThread = thread;
    }
}

