/*
 * Decompiled with CFR 0.152.
 */
package org.joone.net;

import org.joone.engine.InputPatternListener;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralLayer;
import org.joone.engine.OutputPatternListener;

public class NetCheck
implements Comparable {
    public static final int FATAL = 0;
    public static final int WARNING = 1;
    private int severity;
    private String message;
    private Object source;

    public NetCheck(int n, String string, Object object) {
        this.setSeverity(n);
        this.setMessage(string);
        this.setSource(object);
    }

    public String toString() {
        String string = this.getSource().getClass().getName();
        string = string.substring(1 + string.lastIndexOf("."));
        String string2 = this.getSource() instanceof NeuralLayer ? ((NeuralLayer)this.getSource()).getLayerName() : (this.getSource() instanceof InputPatternListener ? ((InputPatternListener)this.getSource()).getName() : (this.getSource() instanceof OutputPatternListener ? ((OutputPatternListener)this.getSource()).getName() : (this.getSource() instanceof Monitor ? "Monitor" : this.getSource().toString())));
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isFatal()) {
            stringBuffer.append("FATAL - ");
        } else if (this.isWarning()) {
            stringBuffer.append("WARNING - ");
        }
        stringBuffer.append(string);
        stringBuffer.append(" - ");
        if (string2 != null && !string2.trim().equals("")) {
            stringBuffer.append(string2);
            stringBuffer.append(" - ");
        }
        stringBuffer.append(this.getMessage());
        return stringBuffer.toString();
    }

    public boolean isWarning() {
        return this.getSeverity() == 1;
    }

    public boolean isFatal() {
        return this.getSeverity() == 0;
    }

    public int compareTo(Object object) {
        if (object instanceof NetCheck) {
            NetCheck netCheck = (NetCheck)object;
            return this.toString().compareTo(netCheck.toString());
        }
        return 0;
    }

    public Object getSource() {
        return this.source;
    }

    public void setSource(Object object) {
        this.source = object;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public int getSeverity() {
        return this.severity;
    }

    public void setSeverity(int n) {
        this.severity = n;
    }
}

