/*
 * Decompiled with CFR 0.152.
 */
package org.joone.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.InputPatternListener;
import org.joone.engine.Layer;
import org.joone.engine.LinearLayer;
import org.joone.engine.Matrix;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralLayer;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.Pattern;
import org.joone.io.StreamInputSynapse;
import org.joone.io.StreamOutputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;
import org.joone.net.NeuralNet;

public class NestedNeuralLayer
extends Layer {
    private static final ILogger log = LoggerFactory.getLogger(NestedNeuralLayer.class);
    static final long serialVersionUID = -3697306754884303651L;
    private String sNeuralNet;
    private NeuralNet NestedNeuralNet = new NeuralNet();
    private LinearLayer lin = new LinearLayer();
    private transient File embeddedNet = null;

    public NestedNeuralLayer() {
        this("");
    }

    public NestedNeuralLayer(String string) {
        this.lin.setLayerName("Nested LinearLayer");
        this.NestedNeuralNet.addLayer(this.lin, 0);
        this.sNeuralNet = "";
        this.setLayerNameInternal(string);
    }

    protected void setDimensions() {
    }

    protected void forward(double[] dArray) {
    }

    protected void backward(double[] dArray) {
    }

    public String getNeuralNet() {
        return this.sNeuralNet;
    }

    public void setNeuralNet(String string) {
        this.sNeuralNet = string;
        try {
            NeuralNet neuralNet = this.readNeuralNet();
            if (neuralNet != null) {
                this.setNestedNeuralNet(neuralNet);
            }
        }
        catch (Exception exception) {
            log.warn("Exception thrown. Message is : " + exception.getMessage(), exception);
        }
    }

    public void start() {
        this.NestedNeuralNet.start();
    }

    public void stop() {
        this.NestedNeuralNet.stop();
    }

    public int getRows() {
        return this.NestedNeuralNet.getRows();
    }

    public void setRows(int n) {
        this.NestedNeuralNet.setRows(n);
    }

    public void addNoise(double d) {
        if (this.isLearning()) {
            this.NestedNeuralNet.addNoise(d);
        }
    }

    public void randomize(double d) {
        if (this.isLearning()) {
            this.NestedNeuralNet.randomize(d);
        }
    }

    public Matrix getBias() {
        return this.NestedNeuralNet.getBias();
    }

    public Vector getAllOutputs() {
        return this.NestedNeuralNet.getAllOutputs();
    }

    public String getLayerName() {
        return this.NestedNeuralNet.getLayerName();
    }

    public void removeOutputSynapse(OutputPatternListener outputPatternListener) {
        this.NestedNeuralNet.removeOutputSynapse(outputPatternListener);
    }

    public void setAllInputs(Vector vector) {
        this.NestedNeuralNet.setAllInputs(vector);
    }

    public void removeAllOutputs() {
        this.NestedNeuralNet.removeAllOutputs();
    }

    public Vector getAllInputs() {
        return this.NestedNeuralNet.getAllInputs();
    }

    public boolean addOutputSynapse(OutputPatternListener outputPatternListener) {
        return this.NestedNeuralNet.addOutputSynapse(outputPatternListener);
    }

    public void setBias(Matrix matrix) {
        this.NestedNeuralNet.setBias(matrix);
    }

    public void removeInputSynapse(InputPatternListener inputPatternListener) {
        this.NestedNeuralNet.removeInputSynapse(inputPatternListener);
    }

    public void setLayerName(String string) {
        this.setLayerNameInternal(string);
    }

    private void setLayerNameInternal(String string) {
        this.NestedNeuralNet.setLayerName(string);
    }

    public boolean addInputSynapse(InputPatternListener inputPatternListener) {
        return this.NestedNeuralNet.addInputSynapse(inputPatternListener);
    }

    public void setAllOutputs(Vector vector) {
        this.NestedNeuralNet.setAllOutputs(vector);
    }

    public void setMonitor(Monitor monitor) {
        this.getMonitor().setParent(monitor);
    }

    public Monitor getMonitor() {
        return this.NestedNeuralNet.getMonitor();
    }

    public void removeAllInputs() {
        this.NestedNeuralNet.removeAllInputs();
    }

    public NeuralLayer copyInto(NeuralLayer neuralLayer) {
        return this.NestedNeuralNet.copyInto(neuralLayer);
    }

    private NeuralNet readNeuralNet() throws IOException, ClassNotFoundException {
        if (this.sNeuralNet == null) {
            return null;
        }
        if (this.sNeuralNet.equals("")) {
            return null;
        }
        File file = new File(this.sNeuralNet);
        FileInputStream fileInputStream = new FileInputStream(file);
        ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
        NeuralNet neuralNet = (NeuralNet)objectInputStream.readObject();
        objectInputStream.close();
        fileInputStream.close();
        return neuralNet;
    }

    public boolean isRunning() {
        if (this.NestedNeuralNet == null) {
            return false;
        }
        return this.NestedNeuralNet.isRunning();
    }

    public NeuralNet getNestedNeuralNet() {
        return this.NestedNeuralNet;
    }

    public void setNestedNeuralNet(NeuralNet neuralNet) {
        neuralNet.removeAllListeners();
        neuralNet.setLayerName(this.NestedNeuralNet.getLayerName());
        neuralNet.setTeacher(null);
        neuralNet.setAllInputs(this.NestedNeuralNet.getAllInputs());
        neuralNet.setAllOutputs(this.NestedNeuralNet.getAllOutputs());
        Monitor monitor = this.getMonitor();
        this.lin = null;
        this.NestedNeuralNet = neuralNet;
        this.NestedNeuralNet.setMonitor(new Monitor());
        this.setMonitor(monitor);
    }

    public boolean isLearning() {
        return this.NestedNeuralNet.getMonitor().isLearning();
    }

    public void setLearning(boolean bl) {
        this.NestedNeuralNet.getMonitor().setLearning(bl);
    }

    public TreeSet check() {
        return this.setErrorSource(this.NestedNeuralNet.check());
    }

    public File getEmbeddedNet() {
        return this.embeddedNet;
    }

    public void setEmbeddedNet(File file) {
        if (file != null) {
            if (!this.sNeuralNet.equals(file.getAbsolutePath())) {
                this.embeddedNet = file;
                this.setNeuralNet(file.getAbsolutePath());
            }
        } else {
            this.embeddedNet = null;
            this.sNeuralNet = "";
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.embeddedNet = new File(this.sNeuralNet);
    }

    private TreeSet setErrorSource(TreeSet treeSet) {
        if (!treeSet.isEmpty()) {
            for (NetCheck netCheck : treeSet) {
                if (netCheck.getSource() instanceof Monitor || netCheck.getSource() instanceof StreamInputSynapse || netCheck.getSource() instanceof StreamOutputSynapse) continue;
                netCheck.setSource(this);
            }
        }
        return treeSet;
    }

    public void fwdRun(Pattern pattern) {
        this.NestedNeuralNet.singleStepForward(pattern);
    }

    public void revRun(Pattern pattern) {
        this.NestedNeuralNet.singleStepBackward(pattern);
    }
}

