/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.net.URL;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.NetErrorManager;
import org.joone.exception.JooneRuntimeException;
import org.joone.io.StreamInputSynapse;
import org.joone.io.StreamInputTokenizer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class YahooFinanceInputSynapse
extends StreamInputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(YahooFinanceInputSynapse.class);
    String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    String[] frequency = new String[]{"Daily", "Weekly", "Monthly"};
    String[] freq_conv = new String[]{"d", "w", "m"};
    String Symbol = "";
    DateFormat date_formater = DateFormat.getDateInstance(2);
    Calendar CalendarStart = Calendar.getInstance();
    Calendar CalendarEnd = Calendar.getInstance();
    String DateStart = new String(this.date_formater.format(this.CalendarStart.getTime()));
    String DateEnd = new String(this.date_formater.format(this.CalendarEnd.getTime()));
    String Period = new String("Daily");
    private transient Date startDate = this.CalendarStart.getTime();
    private transient Date endDate = this.CalendarEnd.getTime();
    private Vector[] StockData = new Vector[6];
    private Vector StockDates = new Vector();
    String[] ColumnNames = new String[]{"Date", "Open", "High", "Low", "Close", "Volume", "Adj. Close"};
    static final long serialVersionUID = 1301769209320717393L;

    public String getSymbol() {
        return this.Symbol;
    }

    public String getDateStart() {
        return this.DateStart;
    }

    public String getDateEnd() {
        return this.DateEnd;
    }

    public String getPeriod() {
        return this.Period;
    }

    public Vector getStockDates() {
        return this.StockDates;
    }

    public Vector[] getStockData() {
        return this.StockData;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        super.readObjectBase(objectInputStream);
        if (objectInputStream.getClass().getName().indexOf("xstream") == -1) {
            this.Symbol = (String)objectInputStream.readObject();
            this.DateStart = (String)objectInputStream.readObject();
            this.DateEnd = (String)objectInputStream.readObject();
            this.Period = (String)objectInputStream.readObject();
        }
        if (!this.isBuffered() || this.getInputVector().size() == 0) {
            this.initInputStream();
        }
        try {
            this.startDate = this.date_formater.parse(this.DateStart);
            this.endDate = this.date_formater.parse(this.DateEnd);
        }
        catch (ParseException parseException) {
            log.error("Invalid Date: start:" + this.DateStart + " end:" + this.DateEnd);
        }
    }

    public void setSymbol(String string) {
        if (!this.Symbol.equals(string)) {
            this.Symbol = string;
            this.resetInput();
            this.setTokens(null);
        }
    }

    public void setDateStart(String string) {
        if (!this.DateStart.equals(string)) {
            this.DateStart = string;
            this.resetInput();
            this.setTokens(null);
        }
    }

    public void setDateEnd(String string) {
        if (!this.DateEnd.equals(string)) {
            this.DateEnd = string;
            this.resetInput();
            this.setTokens(null);
        }
    }

    public void setPeriod(String string) {
        if (!this.Period.equals(string)) {
            this.Period = string;
            this.resetInput();
            this.setTokens(null);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        super.writeObjectBase(objectOutputStream);
        if (objectOutputStream.getClass().getName().indexOf("xstream") == -1) {
            objectOutputStream.writeObject(this.Symbol);
            objectOutputStream.writeObject(this.DateStart);
            objectOutputStream.writeObject(this.DateEnd);
            objectOutputStream.writeObject(this.Period);
        }
    }

    protected void initInputStream() throws JooneRuntimeException {
        block13: {
            int n;
            String string = "";
            int n2 = 0;
            String string2 = "";
            String string3 = "d";
            for (n = 0; n < this.frequency.length; ++n) {
                if (!this.Period.equals(this.frequency[n])) continue;
                string3 = this.freq_conv[n];
            }
            this.StockData = null;
            this.StockDates = null;
            if (this.Symbol != null && !this.Symbol.equals("")) {
                try {
                    this.CalendarStart = Calendar.getInstance();
                    this.CalendarEnd = Calendar.getInstance();
                    this.CalendarStart.setTime(this.date_formater.parse(this.DateStart));
                    this.CalendarEnd.setTime(this.date_formater.parse(this.DateEnd));
                }
                catch (ParseException parseException) {
                    log.error("YahooFinanceInputSynapse could not parse date string. Message is : = " + parseException.getMessage());
                    this.CalendarStart = null;
                    this.CalendarEnd = null;
                    if (this.getMonitor() != null) {
                        new NetErrorManager(this.getMonitor(), "YahooFinanceInputSynapse could not parse date string. " + parseException.getMessage());
                    }
                    return;
                }
                n = 1;
                if (this.CalendarStart != null && this.CalendarEnd != null && this.Period != null) {
                    log.info("Contacting Yahoo Finance Network.");
                    try {
                        while (n > 0 && n <= 200) {
                            string2 = new String("http://table.finance.yahoo.com/table.csv?a=" + this.CalendarStart.get(2) + "&b=" + this.CalendarStart.get(5) + "&c=" + this.CalendarStart.get(1) + "&d=" + this.CalendarEnd.get(2) + "&e=" + this.CalendarEnd.get(5) + "&f=" + this.CalendarEnd.get(1) + "&s=" + this.Symbol + "&g=" + string3 + "&z=200&y=" + n2 + "&ignore=.csv");
                            n = this.addURLToMemory(new URL(string2));
                            n2 += 200;
                        }
                    }
                    catch (IOException iOException) {
                        log.error("Error obtaining data from YahooFInance. Error message is " + iOException.getMessage());
                        if (this.getMonitor() != null) {
                            new NetErrorManager(this.getMonitor(), "Error obtaining data from YahooFInance." + iOException.getMessage());
                        }
                        return;
                    }
                    log.info("Loaded Yahoo Fianance data ok.");
                    for (int i = this.StockData[0].size() - 1; i >= 0; --i) {
                        string = string + ((Double)this.StockData[0].elementAt(i)).toString();
                        string = string + ";" + ((Double)this.StockData[1].elementAt(i)).toString();
                        string = string + ";" + ((Double)this.StockData[2].elementAt(i)).toString();
                        string = string + ";" + ((Double)this.StockData[3].elementAt(i)).toString();
                        string = string + ";" + ((Double)this.StockData[4].elementAt(i)).toString();
                        string = string + ";" + ((Double)this.StockData[5].elementAt(i)).toString();
                        string = string + '\n';
                    }
                    try {
                        StreamInputTokenizer streamInputTokenizer = this.getMaxBufSize() > 0 ? new StreamInputTokenizer(new StringReader(string), this.getMaxBufSize()) : new StreamInputTokenizer(new StringReader(string));
                        super.setTokens(streamInputTokenizer);
                    }
                    catch (IOException iOException) {
                        log.error("IOException thrown while initializing the YahooFinanceInputStream. Message is : " + iOException.getMessage());
                        if (this.getMonitor() == null) break block13;
                        new NetErrorManager(this.getMonitor(), "Error while trying to parse Yahoo Finance data. Message is : " + iOException.getMessage());
                    }
                }
            }
        }
    }

    private int addURLToMemory(URL uRL) throws IOException {
        String string = "";
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        int n = 0;
        if (uRL != null) {
            log.debug(uRL.getProtocol() + "://" + uRL.getHost() + uRL.getFile());
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(new BufferedInputStream(uRL.openStream())));
            string = lineNumberReader.readLine();
            if (this.StockDates == null) {
                this.StockDates = new Vector();
            }
            if (this.StockData == null || this.StockData.length < 6) {
                this.StockData = new Vector[6];
            }
            if (this.StockData[0] == null) {
                this.StockData[0] = new Vector();
            }
            if (this.StockData[1] == null) {
                this.StockData[1] = new Vector();
            }
            if (this.StockData[2] == null) {
                this.StockData[2] = new Vector();
            }
            if (this.StockData[3] == null) {
                this.StockData[3] = new Vector();
            }
            if (this.StockData[4] == null) {
                this.StockData[4] = new Vector();
            }
            if (this.StockData[5] == null) {
                this.StockData[5] = new Vector();
            }
            n = this.StockData[0].size();
            while (string != null && !string.equals("") && bl3) {
                if (bl && string.indexOf(this.ColumnNames[0]) < 0) {
                    if (string.indexOf(",") != -1) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ",\n");
                        if (stringTokenizer.countTokens() >= 7) {
                            bl2 = true;
                            String string2 = stringTokenizer.nextToken();
                            this.StockDates.addElement(string2);
                            this.StockData[0].add(Double.valueOf(stringTokenizer.nextToken()));
                            this.StockData[1].add(Double.valueOf(stringTokenizer.nextToken()));
                            this.StockData[2].add(Double.valueOf(stringTokenizer.nextToken()));
                            this.StockData[3].add(Double.valueOf(stringTokenizer.nextToken()));
                            this.StockData[4].add(Double.valueOf(stringTokenizer.nextToken()));
                            this.StockData[5].add(Double.valueOf(stringTokenizer.nextToken()));
                        }
                    } else {
                        bl3 = false;
                    }
                }
                string = lineNumberReader.readLine();
            }
            lineNumberReader.close();
        }
        int n2 = this.StockData[0].size() - n;
        return n2;
    }

    public TreeSet check() {
        TreeSet treeSet = super.check();
        if (this.getDateStart() != null && !this.getDateStart().equals("")) {
            try {
                this.date_formater.parse(this.DateStart);
            }
            catch (ParseException parseException) {
                treeSet.add(new NetCheck(0, "Format for Start Date is invalid.", this));
            }
        } else {
            treeSet.add(new NetCheck(0, "Start Date should be populated.", this));
        }
        if (this.getDateEnd() != null && !this.getDateEnd().equals("")) {
            try {
                this.date_formater.parse(this.DateEnd);
            }
            catch (ParseException parseException) {
                treeSet.add(new NetCheck(0, "Format for End Date is invalid.", this));
            }
        } else {
            treeSet.add(new NetCheck(0, "End Date should be populated.", this));
        }
        if (this.getPeriod() != null) {
            if (!(this.getPeriod().equals("Daily") || this.getPeriod().equals("Weekly") || this.getPeriod().equals("Monthly"))) {
                treeSet.add(new NetCheck(0, "Period should be one of 'Daily' , 'Weekly' , 'Monthly'.", this));
            }
        } else {
            treeSet.add(new NetCheck(0, "Period should be one of 'Daily' , 'Weekly' , 'Monthly'.", this));
        }
        if (this.getSymbol() == null || this.getSymbol().equals("")) {
            treeSet.add(new NetCheck(0, "Symbol should be populated.", this));
        }
        return treeSet;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date date) {
        this.startDate = date;
        this.DateStart = this.date_formater.format(date);
        this.resetInput();
        this.setTokens(null);
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date date) {
        this.endDate = date;
        this.DateEnd = this.date_formater.format(date);
        this.resetInput();
        this.setTokens(null);
    }
}

