/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.TreeSet;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.joone.engine.NetErrorManager;
import org.joone.exception.JooneRuntimeException;
import org.joone.io.StreamInputSynapse;
import org.joone.io.XLSInputTokenizer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class XLSInputSynapse
extends StreamInputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(XLSInputSynapse.class);
    private String i_sheet_name = "";
    private transient HSSFSheet i_sheet;
    private int i_sheet_index = 0;
    private transient FileInputStream i_stream;
    private transient POIFSFileSystem i_fs;
    private transient HSSFWorkbook i_workbook;
    private boolean file_chk = false;
    private String fileName = "";
    private transient File inputFile;
    private static final long serialVersionUID = 8625369117101456178L;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        if (!this.fileName.equals(string)) {
            this.fileName = string;
            this.file_chk = true;
            this.resetInput();
            this.setTokens(null);
        }
    }

    protected void initInputStream() throws JooneRuntimeException {
        if (new File(this.fileName).exists()) {
            this.i_sheet = this.getSheet(this.i_sheet_name);
            if (this.i_sheet != null) {
                try {
                    super.setTokens(new XLSInputTokenizer(this.i_sheet));
                }
                catch (IOException iOException) {
                    log.error("Error creating XLSInputTokenizer. Message is : " + iOException.getMessage());
                    if (this.getMonitor() != null) {
                        new NetErrorManager(this.getMonitor(), "Error creating XLSInputTokenizer. Message is : " + iOException.getMessage());
                    }
                }
            }
        } else {
            String string = "Excel XLS File '" + this.fileName + "' does not exist.";
            log.error(string);
            if (this.getMonitor() != null) {
                new NetErrorManager(this.getMonitor(), "Excel XLS File '" + this.fileName + "' does not exist.");
            }
        }
    }

    protected HSSFSheet getSheet(String string) {
        HSSFSheet hSSFSheet = null;
        try {
            this.i_stream = new FileInputStream(this.fileName);
            this.i_fs = new POIFSFileSystem((InputStream)this.i_stream);
            this.i_workbook = new HSSFWorkbook(this.i_fs);
            this.i_stream.close();
            this.i_sheet_index = this.i_workbook.getSheetIndex(string);
            hSSFSheet = this.i_sheet_index > -1 ? this.i_workbook.getSheetAt(this.i_sheet_index) : this.i_workbook.getSheetAt(0);
            return hSSFSheet;
        }
        catch (IOException iOException) {
            log.error("Could not open worksheet '" + string + "' from XLS file. Message is : " + iOException.getMessage());
            if (this.getMonitor() != null) {
                new NetErrorManager(this.getMonitor(), "Could not open worksheet '" + string + "' from XLS file. Message is : " + iOException.getMessage());
            }
            return null;
        }
    }

    public void setSheetName(String string) {
        if (!this.i_sheet_name.equals(string)) {
            this.i_sheet_name = string;
            this.resetInput();
            this.setTokens(null);
        }
    }

    public String[] getAvailableSheetList() {
        int n = this.i_workbook.getNumberOfSheets();
        String[] stringArray = new String[n];
        for (int i = 0; i > n; ++i) {
            stringArray[i] = this.i_workbook.getSheetName(i);
        }
        return stringArray;
    }

    public String getSheetName() {
        return this.i_sheet_name;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        super.readObjectBase(objectInputStream);
        if (objectInputStream.getClass().getName().indexOf("xstream") == -1) {
            this.fileName = (String)objectInputStream.readObject();
        }
        if (!this.isBuffered() || this.getInputVector().size() == 0) {
            this.setFileName(this.fileName);
        }
        if (this.fileName != null && this.fileName.length() > 0) {
            this.inputFile = new File(this.fileName);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        super.writeObjectBase(objectOutputStream);
        if (objectOutputStream.getClass().getName().indexOf("xstream") == -1) {
            objectOutputStream.writeObject(this.fileName);
        }
    }

    public TreeSet check() {
        TreeSet treeSet = super.check();
        if (this.fileName == null || this.fileName.trim().equals("")) {
            treeSet.add(new NetCheck(0, "File Name not set.", this));
        } else if (!this.getInputFile().exists()) {
            NetCheck netCheck = new NetCheck(1, "Input File doesn't exist.", this);
            if (this.getInputPatterns().isEmpty()) {
                netCheck.setSeverity(0);
            }
            treeSet.add(netCheck);
        }
        return treeSet;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File file) {
        if (file != null) {
            if (!this.fileName.equals(file.getAbsolutePath())) {
                this.inputFile = file;
                this.fileName = file.getAbsolutePath();
                this.file_chk = true;
                this.resetInput();
                super.setTokens(null);
            }
        } else {
            this.inputFile = null;
            this.fileName = "";
            this.file_chk = true;
            this.resetInput();
            super.setTokens(null);
        }
    }
}

