/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.Fifo;
import org.joone.engine.NetErrorManager;
import org.joone.engine.Pattern;
import org.joone.engine.Synapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.util.OutputConverterPlugIn;
import org.joone.util.PlugInEvent;
import org.joone.util.PlugInListener;

public abstract class StreamOutputSynapse
extends Synapse
implements PlugInListener {
    private static final ILogger log = LoggerFactory.getLogger(StreamOutputSynapse.class);
    private char separator = (char)59;
    private static final long serialVersionUID = 7344684413113722785L;
    protected transient Fifo fifo;
    private boolean buffered = true;
    private transient Vector buffered_patterns;
    protected OutputConverterPlugIn nextPlugIn = null;

    protected void backward(double[] dArray) {
    }

    protected void forward(double[] dArray) {
        this.outs = dArray;
    }

    public synchronized void fwdPut(Pattern pattern) {
        block11: {
            if (this.isEnabled()) {
                try {
                    if (this.isBuffered()) {
                        if (!pattern.isMarkedAsStoppingPattern()) {
                            this.m_pattern = pattern;
                            this.inps = pattern.getArray();
                            this.forward(this.inps);
                            this.m_pattern.setArray(this.outs);
                            this.getFifo().push(this.m_pattern.clone());
                            this.items = this.fifo.size();
                        } else {
                            this.getFifo().push(pattern.clone());
                            this.items = this.fifo.size();
                            int n = this.fifo.size();
                            this.buffered_patterns = new Vector();
                            for (int i = 0; i < n; ++i) {
                                this.buffered_patterns.addElement(((Pattern)this.fifo.pop()).clone());
                            }
                            if (this.nextPlugIn != null) {
                                this.nextPlugIn.setInputVector(this.buffered_patterns);
                                this.nextPlugIn.convertPatterns();
                            }
                            this.write(this.buffered_patterns);
                        }
                    } else {
                        if (pattern.getCount() > -1) {
                            this.inps = pattern.getArray();
                            this.forward(this.inps);
                            this.items = 1;
                            if (this.nextPlugIn != null) {
                                this.nextPlugIn.setPattern(pattern);
                                this.nextPlugIn.convertPattern();
                            }
                        }
                        this.write(pattern);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    String string = "NumberFormatException in " + this.getName() + ". Message is : ";
                    log.warn(string + numberFormatException.getMessage());
                    if (this.getMonitor() == null) break block11;
                    new NetErrorManager(this.getMonitor(), string + numberFormatException.getMessage());
                }
            }
        }
        this.notifyAll();
    }

    private void write(Vector vector) {
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                this.write((Pattern)vector.elementAt(i));
            }
        }
    }

    public abstract void write(Pattern var1);

    public char getSeparator() {
        return this.separator;
    }

    public synchronized Pattern revGet() {
        return null;
    }

    protected void setArrays(int n, int n2) {
    }

    protected void setDimensions(int n, int n2) {
    }

    public void setSeparator(char c) {
        this.separator = c;
    }

    public void setBuffered(boolean bl) {
        this.buffered = bl;
    }

    public boolean isBuffered() {
        return this.buffered;
    }

    public TreeSet check() {
        TreeSet treeSet = super.check();
        if (this.nextPlugIn != null) {
            this.nextPlugIn.check(treeSet);
        }
        return treeSet;
    }

    protected Fifo getFifo() {
        if (this.fifo == null) {
            this.fifo = new Fifo();
        }
        return this.fifo;
    }

    public OutputConverterPlugIn getPlugIn() {
        return this.nextPlugIn;
    }

    public boolean setPlugIn(OutputConverterPlugIn outputConverterPlugIn) {
        if (outputConverterPlugIn == this.nextPlugIn) {
            return false;
        }
        if (outputConverterPlugIn == null) {
            this.nextPlugIn.setConnected(false);
        } else {
            if (outputConverterPlugIn.isConnected()) {
                return false;
            }
            outputConverterPlugIn.setConnected(true);
            outputConverterPlugIn.addPlugInListener(this);
            this.buffered = true;
        }
        this.nextPlugIn = outputConverterPlugIn;
        this.getFifo().removeAllElements();
        return true;
    }

    public boolean addPlugIn(OutputConverterPlugIn outputConverterPlugIn) {
        if (this.nextPlugIn == outputConverterPlugIn) {
            return false;
        }
        if (outputConverterPlugIn == null) {
            if (this.nextPlugIn != null) {
                this.nextPlugIn.setConnected(false);
            }
            this.nextPlugIn = null;
            this.getFifo().removeAllElements();
            return true;
        }
        if (outputConverterPlugIn.isConnected()) {
            return false;
        }
        if (this.nextPlugIn == null) {
            outputConverterPlugIn.setConnected(true);
            outputConverterPlugIn.addPlugInListener(this);
            this.setBuffered(true);
            this.nextPlugIn = outputConverterPlugIn;
            this.getFifo().removeAllElements();
            return true;
        }
        return this.nextPlugIn.addPlugIn(outputConverterPlugIn);
    }

    public void removeAllPlugIns() {
        if (this.nextPlugIn != null) {
            this.nextPlugIn.setConnected(false);
            this.nextPlugIn.removeAllPlugIns();
            this.nextPlugIn = null;
        }
    }

    public void dataChanged(PlugInEvent plugInEvent) {
        this.getFifo().removeAllElements();
    }
}

