/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.IOException;
import org.joone.io.PatternTokenizer;

public class MemoryInputTokenizer
implements PatternTokenizer {
    private double[][] inputArray;
    private int lineNo = 0;
    private int mark = 0;
    private char decimalPoint;

    public MemoryInputTokenizer() {
    }

    public MemoryInputTokenizer(double[][] dArray) {
        this.inputArray = dArray;
    }

    public void resetInput() throws IOException {
        this.lineNo = this.mark;
    }

    public int getLineno() {
        return this.lineNo;
    }

    public char getDecimalPoint() {
        return this.decimalPoint;
    }

    public boolean nextLine() throws IOException {
        ++this.lineNo;
        return this.lineNo <= this.inputArray.length;
    }

    public int getNumTokens() throws IOException {
        double[] dArray = this.getTokensArray();
        return dArray.length;
    }

    public void mark() throws IOException {
        this.mark = this.lineNo;
    }

    public double getTokenAt(int n) throws IOException {
        double[] dArray = this.getTokensArray();
        return dArray[n];
    }

    public double[] getTokensArray() {
        return this.inputArray[this.lineNo - 1];
    }

    public void setDecimalPoint(char c) {
        this.decimalPoint = c;
    }
}

