/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.TreeSet;
import org.joone.engine.NetErrorManager;
import org.joone.engine.Pattern;
import org.joone.exception.JooneRuntimeException;
import org.joone.io.StreamOutputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class JDBCOutputSynapse
extends StreamOutputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(JDBCOutputSynapse.class);
    private String driverName = "";
    private String dbURL = "";
    private String SQLAmendment = "";
    private transient Connection con = null;
    private transient Statement stmt = null;
    private static final long serialVersionUID = 2176832390164459511L;

    public JDBCOutputSynapse() {
    }

    public JDBCOutputSynapse(String string, String string2, String string3, boolean bl) {
        this.setBuffered(bl);
        this.driverName = string;
        this.dbURL = string2;
        this.SQLAmendment = string3;
    }

    public String getdriverName() {
        return this.driverName;
    }

    public String getdbURL() {
        return this.dbURL;
    }

    public String getSQLAmendment() {
        return this.SQLAmendment;
    }

    public void setdriverName(String string) {
        this.driverName = string;
    }

    public void setdbURL(String string) {
        this.dbURL = string;
    }

    public void setSQLAmendment(String string) {
        this.SQLAmendment = string;
    }

    protected void initStream() throws JooneRuntimeException {
        block13: {
            if (this.driverName != null && !this.driverName.trim().equals("")) {
                if (this.dbURL != null && !this.dbURL.trim().equals("")) {
                    if (this.SQLAmendment != null && !this.SQLAmendment.trim().equals("")) {
                        try {
                            Class.forName(this.driverName);
                            this.con = DriverManager.getConnection(this.dbURL);
                            this.stmt = this.con.createStatement();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            log.error("Could not find Database Driver Class while initializing the JDBCInputStream. Message is : " + classNotFoundException.getMessage(), classNotFoundException);
                            if (this.getMonitor() != null) {
                                new NetErrorManager(this.getMonitor(), "Could not find Database Driver Class while initializing the JDBCInputStream. Message is : " + classNotFoundException.getMessage());
                            }
                            break block13;
                        }
                        catch (SQLException sQLException) {
                            log.error("SQLException thrown while initializing the JDBCInputStream. Message is : " + sQLException.getMessage(), sQLException);
                            if (this.getMonitor() != null) {
                                new NetErrorManager(this.getMonitor(), "SQLException thrown while initializing the JDBCInputStream. Message is : " + sQLException.getMessage());
                            }
                            break block13;
                        }
                    }
                    String string = "The SQL Amendment has not been entered!";
                    log.warn(string);
                    if (this.getMonitor() != null) {
                        new NetErrorManager(this.getMonitor(), "The SQL Amendment has not been entered!");
                    }
                } else {
                    String string = "The Database URL has not been entered!";
                    log.warn(string);
                    if (this.getMonitor() != null) {
                        new NetErrorManager(this.getMonitor(), "The Database URL has not been entered!");
                    }
                }
            } else {
                String string = "The Driver Name has not been entered!";
                log.warn(string);
                if (this.getMonitor() != null) {
                    new NetErrorManager(this.getMonitor(), "The Driver Name has not been entered!");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreeSet check() {
        TreeSet treeSet;
        block14: {
            treeSet = super.check();
            if (this.driverName == null || this.driverName.compareTo("") == 0) {
                treeSet.add(new NetCheck(0, "Database Driver Name needs to be entered.", this));
            } else {
                try {
                    Class.forName(this.driverName);
                    if (this.isUrlEmpty()) break block14;
                    Connection connection = DriverManager.getConnection(this.dbURL);
                    try {
                        try {
                            this.stmt = connection.createStatement();
                        }
                        finally {
                            if (this.stmt != null) {
                                this.stmt.close();
                                this.stmt = null;
                            }
                        }
                    }
                    finally {
                        connection.close();
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    treeSet.add(new NetCheck(0, "Could not find Database Driver Class. Check Database Driver is in the classpath and is readable.", this));
                }
                catch (SQLException sQLException) {
                    treeSet.add(new NetCheck(0, "The Database URL is incorrect. Connection error is : " + sQLException.toString(), this));
                }
            }
        }
        if (this.dbURL == null || this.dbURL.compareTo("") == 0) {
            treeSet.add(new NetCheck(0, "Database URL needs to be entered.", this));
        }
        if (this.SQLAmendment == null || this.SQLAmendment.compareTo("") == 0) {
            treeSet.add(new NetCheck(0, "Database SQL Amendment needs to be entered.", this));
        }
        return treeSet;
    }

    private boolean isUrlEmpty() {
        return this.dbURL == null || this.dbURL.equals("");
    }

    public void write(Pattern pattern) throws JooneRuntimeException {
        block11: {
            String string = this.SQLAmendment;
            if (this.con == null || this.stmt == null || pattern.getCount() == 1) {
                this.initStream();
            }
            if (pattern.isMarkedAsStoppingPattern()) {
                try {
                    if (this.stmt != null) {
                        this.stmt.close();
                    }
                    if (this.con != null) {
                        this.con.close();
                    }
                }
                catch (SQLException sQLException) {
                    this.stmt = null;
                    this.con = null;
                }
                return;
            }
            try {
                if (string != null && !string.equals("")) {
                    for (int i = 0; i < pattern.getArray().length; ++i) {
                        String string2 = "JOONE[" + (i + 1) + "]";
                        String string3 = Double.toString(pattern.getArray()[i]);
                        while (string.indexOf(string2) >= 0) {
                            StringBuffer stringBuffer = new StringBuffer(string);
                            int n = string.indexOf(string2);
                            string = stringBuffer.replace(n, n + string2.length(), string3).toString();
                        }
                    }
                    this.stmt.executeUpdate(string);
                }
            }
            catch (SQLException sQLException) {
                String string4 = "An SQL error occurred while trying to execute [" + string + "], error is " + sQLException.toString();
                log.error(string4);
                if (this.getMonitor() == null) break block11;
                new NetErrorManager(this.getMonitor(), string4);
            }
        }
    }
}

