/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;
import javax.imageio.ImageIO;
import org.joone.io.PatternTokenizer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class ImageInputTokenizer
implements PatternTokenizer {
    private int RequiredWidth = 0;
    private int RequiredHeight = 0;
    private int TotalTokens = 0;
    private double[] ImageTokens = null;
    private Vector ImageFileList = new Vector();
    private Image[] ArrayOfInputImages = null;
    private int TotalInputImages = 0;
    private boolean FileMode = true;
    private boolean ColourMode = true;
    private int CurrentImageNo = 0;
    private int CurrentToken = 0;
    private int MarkedImage = 0;
    private int MarkedToken = 0;
    private static final ILogger log = LoggerFactory.getLogger(ImageInputTokenizer.class);

    public ImageInputTokenizer(int n, int n2, Vector vector, boolean bl) throws IOException {
        this.init(n, n2, bl, true);
        this.ImageFileList = vector;
        this.TotalInputImages = this.ImageFileList != null ? this.ImageFileList.size() : -1;
    }

    public ImageInputTokenizer(int n, int n2, Image[] imageArray, boolean bl) throws IOException {
        this.init(n, n2, bl, false);
        this.ArrayOfInputImages = imageArray;
        this.TotalInputImages = imageArray != null ? imageArray.length : -1;
    }

    private void init(int n, int n2, boolean bl, boolean bl2) {
        this.FileMode = bl2;
        this.RequiredWidth = n;
        this.RequiredHeight = n2;
        this.ColourMode = bl;
        this.TotalTokens = this.ColourMode ? this.RequiredWidth * this.RequiredHeight * 3 : this.RequiredWidth * this.RequiredHeight;
        this.ImageTokens = new double[this.TotalTokens];
    }

    public int getLineno() {
        return this.CurrentImageNo;
    }

    public int getNumTokens() throws IOException {
        return this.TotalTokens;
    }

    public double getTokenAt(int n) throws IOException {
        if (this.ImageTokens == null || n >= this.TotalTokens) {
            return 0.0;
        }
        return this.ImageTokens[n];
    }

    public double[] getTokensArray() {
        return (double[])this.ImageTokens.clone();
    }

    public void mark() throws IOException {
        this.MarkedImage = this.CurrentImageNo;
        this.MarkedToken = this.CurrentToken;
    }

    public boolean nextLine() throws IOException {
        boolean bl = false;
        if (this.CurrentImageNo >= this.TotalInputImages || this.TotalInputImages <= 0) {
            return false;
        }
        bl = this.processImage();
        ++this.CurrentImageNo;
        return bl;
    }

    private boolean processImage() {
        boolean bl = false;
        if (this.FileMode) {
            try {
                URL uRL = (URL)this.ImageFileList.get(this.CurrentImageNo);
                BufferedImage bufferedImage = ImageIO.read(uRL);
                bl = this.processImage(bufferedImage);
            }
            catch (Exception exception) {
                log.error("Error processing/loading image : " + exception.toString());
            }
        } else if (this.ArrayOfInputImages != null && this.ArrayOfInputImages.length >= 1) {
            bl = this.processImage(this.ArrayOfInputImages[this.CurrentImageNo]);
        }
        return bl;
    }

    private double nextToken() throws IOException {
        return this.nextToken(null);
    }

    private double nextToken(String string) throws IOException {
        if (this.CurrentToken >= this.TotalTokens) {
            return 0.0;
        }
        double d = this.ImageTokens[this.CurrentToken];
        ++this.CurrentToken;
        return d;
    }

    public void resetInput() throws IOException {
        if (this.MarkedImage > 0 || this.MarkedToken > 0) {
            this.CurrentImageNo = this.MarkedImage;
            this.CurrentToken = this.MarkedToken;
        } else {
            this.CurrentImageNo = 0;
        }
        this.processImage();
    }

    public void setDecimalPoint(char c) {
        log.error("setDecimalPoint not supported in " + this.getClass());
    }

    public char getDecimalPoint() {
        return '.';
    }

    private boolean processImage(Image image) {
        block7: {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            try {
                int[] nArray = this.ColourMode ? new int[this.TotalTokens / 3] : new int[this.TotalTokens];
                Image image2 = image.getScaledInstance(this.RequiredWidth, this.RequiredHeight, 16);
                PixelGrabber pixelGrabber = new PixelGrabber(image2, 0, 0, image2.getWidth(null), image2.getHeight(null), nArray, 0, image2.getWidth(null));
                if (pixelGrabber.grabPixels()) {
                    if (this.ColourMode) {
                        for (int i = 0; i < nArray.length; ++i) {
                            d = (double)((nArray[i] & 0xFF0000) >> 16) / 255.0;
                            d2 = (double)((nArray[i] & 0xFF00) >> 8) / 255.0;
                            d3 = (double)(nArray[i] & 0xFF) / 255.0;
                            this.ImageTokens[i * 3] = d;
                            this.ImageTokens[i * 3 + 1] = d2;
                            this.ImageTokens[i * 3 + 2] = d3;
                        }
                    } else {
                        for (int i = 0; i < nArray.length; ++i) {
                            d = (double)((nArray[i] & 0xFF0000) >> 16) / 255.0;
                            d2 = (double)((nArray[i] & 0xFF00) >> 8) / 255.0;
                            d3 = (double)(nArray[i] & 0xFF) / 255.0;
                            this.ImageTokens[i] = d4 = (d + d3 + d2) / 3.0;
                        }
                    }
                    break block7;
                }
                log.error("Failed to grab image pixels due to error.");
                return false;
            }
            catch (Exception exception) {
                log.error("Error processing image : " + exception.toString());
                return false;
            }
        }
        return true;
    }
}

