/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.awt.Image;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.exception.JooneRuntimeException;
import org.joone.io.ImageInputTokenizer;
import org.joone.io.StreamInputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class ImageInputSynapse
extends StreamInputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(ImageInputSynapse.class);
    static final long serialVersionUID = -1396287146739057882L;
    private File imageDirectory = new File(System.getProperty("user.dir"));
    private String theFileFilter = new String(".*[jJ][pP][gG]");
    private Vector FileNameList = new Vector();
    private Image[] MultiImages = null;
    private int DesiredWidth = 0;
    private int DesiredHeight = 0;
    private boolean ColourMode = true;

    public ImageInputSynapse() {
        this.calculateNewACS();
    }

    public void setFileFilter(String string) {
        this.theFileFilter = string;
    }

    public String getFileFilter() {
        return this.theFileFilter;
    }

    public void setImageInput(Image[] imageArray) {
        this.MultiImages = imageArray;
    }

    protected void initInputStream() throws JooneRuntimeException {
        ImageInputTokenizer imageInputTokenizer = null;
        try {
            if (this.MultiImages != null && this.MultiImages.length > 0) {
                imageInputTokenizer = new ImageInputTokenizer(this.getDesiredWidth(), this.getDesiredHeight(), this.MultiImages, this.ColourMode);
                super.setTokens(imageInputTokenizer);
            } else {
                this.FileNameList = new Vector();
                String[] stringArray = this.imageDirectory.list(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.matches(ImageInputSynapse.this.theFileFilter);
                    }
                });
                for (int i = 0; i < stringArray.length; ++i) {
                    URL uRL = new File(this.imageDirectory.getPath() + System.getProperty("file.separator") + stringArray[i]).toURL();
                    this.FileNameList.add(uRL);
                }
                imageInputTokenizer = new ImageInputTokenizer(this.getDesiredWidth(), this.getDesiredHeight(), this.FileNameList, this.ColourMode);
                super.setTokens(imageInputTokenizer);
            }
        }
        catch (Exception exception) {
            log.error("Error initialising the input stream : " + exception.toString());
        }
    }

    public int getDesiredWidth() {
        return this.DesiredWidth;
    }

    public void setDesiredWidth(int n) {
        this.DesiredWidth = n;
        this.calculateNewACS();
    }

    public int getDesiredHeight() {
        return this.DesiredHeight;
    }

    public void setDesiredHeight(int n) {
        this.DesiredHeight = n;
        this.calculateNewACS();
    }

    public File getImageDirectory() {
        return this.imageDirectory;
    }

    public void setImageDirectory(File file) {
        File file2 = file;
        if (file2 != null && !file2.isDirectory()) {
            String string = file2.getName();
            int n = file2.getPath().indexOf(string);
            if (n > -1) {
                String string2 = file2.getPath().substring(0, n);
                file2 = new File(string2);
            }
        }
        this.imageDirectory = file2;
    }

    public boolean getColourMode() {
        return this.ColourMode;
    }

    public void setColourMode(boolean bl) {
        this.ColourMode = bl;
        this.calculateNewACS();
    }

    public TreeSet check() {
        TreeSet treeSet = super.check();
        if (this.theFileFilter.equals("")) {
            treeSet.add(new NetCheck(0, "No File Filter set e.g. '.*[jJ][pP][gG]'.", this));
        }
        if (this.imageDirectory == null) {
            treeSet.add(new NetCheck(0, "No image input directory set.", this));
        }
        if (this.DesiredHeight == 0) {
            treeSet.add(new NetCheck(0, "Height of image not set.", this));
        }
        if (this.DesiredWidth == 0) {
            treeSet.add(new NetCheck(0, "Width of image not set.", this));
        }
        return treeSet;
    }

    private void calculateNewACS() {
        int n = this.DesiredWidth * this.DesiredHeight;
        if (this.ColourMode) {
            n *= 3;
        }
        this.setAdvancedColumnSelector("1-" + n);
    }
}

