/*
 * Decompiled with CFR 0.152.
 */
package org.joone.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.TreeSet;
import org.joone.exception.JooneRuntimeException;
import org.joone.io.StreamInputSynapse;
import org.joone.io.StreamInputTokenizer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class FileInputSynapse
extends StreamInputSynapse {
    private static final ILogger log = LoggerFactory.getLogger(FileInputSynapse.class);
    private static final long serialVersionUID = 7456627292136514416L;
    private String fileName = "";
    private transient File inputFile;

    public String getFileName() {
        return this.fileName;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        super.readObjectBase(objectInputStream);
        if (objectInputStream.getClass().getName().indexOf("xstream") == -1) {
            this.fileName = (String)objectInputStream.readObject();
        }
        if (this.fileName != null && this.fileName.trim().length() > 0) {
            this.inputFile = new File(this.fileName);
        }
    }

    public void setFileName(String string) {
        if (!this.fileName.equals(string)) {
            this.fileName = string;
            this.makeInit();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        super.writeObjectBase(objectOutputStream);
        if (objectOutputStream.getClass().getName().indexOf("xstream") == -1) {
            objectOutputStream.writeObject(this.fileName);
        }
    }

    protected void initInputStream() throws JooneRuntimeException {
        if (this.fileName != null && !this.fileName.trim().equals("")) {
            try {
                this.inputFile = new File(this.fileName);
                FileInputStream fileInputStream = new FileInputStream(this.inputFile);
                int n = this.getMaxBufSize();
                StreamInputTokenizer streamInputTokenizer = n > 0 ? new StreamInputTokenizer(new InputStreamReader(fileInputStream), n) : new StreamInputTokenizer(new InputStreamReader(fileInputStream));
                this.setTokens(streamInputTokenizer);
            }
            catch (IOException iOException) {
                this.handleExceptionWithWarn(iOException, "IOException", log);
            }
        }
    }

    public TreeSet check() {
        TreeSet treeSet = super.check();
        if (this.fileName == null || this.fileName.trim().equals("")) {
            treeSet.add(new NetCheck(0, "File Name not set.", this));
        } else {
            if (this.getInputFile() == null) {
                this.makeInit();
            }
            if (this.getInputFile() != null && !this.getInputFile().exists()) {
                NetCheck netCheck = new NetCheck(1, "Input File doesn't exist.", this);
                if (this.getInputPatterns().isEmpty()) {
                    netCheck.setSeverity(0);
                }
                treeSet.add(netCheck);
            }
        }
        return treeSet;
    }

    public File getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(File file) {
        if (file != null) {
            if (!this.fileName.equals(file.getAbsolutePath())) {
                this.inputFile = file;
                this.fileName = file.getAbsolutePath();
                this.makeInit();
            }
        } else {
            this.inputFile = null;
            this.fileName = "";
            this.makeInit();
        }
    }

    private void makeInit() {
        this.resetInput();
        this.setTokens(null);
    }
}

