/*
 * Decompiled with CFR 0.152.
 */
package org.joone.helpers.templating;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.joone.helpers.structure.NeuralNetMatrix;
import org.joone.net.NeuralNet;
import org.joone.net.NeuralNetLoader;

public class CodeGenerator {
    private VelocityContext context = null;
    private Hashtable objMap;

    public CodeGenerator() throws Exception {
        this.context = this.init();
    }

    public CodeGenerator(Properties properties) throws Exception {
        this.context = this.init(properties);
    }

    public static void main(String[] stringArray) throws Exception {
        CodeGenerator codeGenerator = new CodeGenerator();
        NeuralNetLoader neuralNetLoader = new NeuralNetLoader("xor.snet");
        NeuralNet neuralNet = neuralNetLoader.getNeuralNet();
        String string = codeGenerator.getCode(neuralNet, "codeTemplate.vm", "org.joone.test.templating", "TestClass");
        System.out.println(string);
    }

    protected VelocityContext init() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("resource.loader", "file, class");
        properties.setProperty("file.resource.loader.description", "Velocity File Resource Loader");
        properties.setProperty("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.FileResourceLoader");
        properties.setProperty("file.resource.loader.path", ".");
        properties.setProperty("file.resource.loader.cache", "false");
        properties.setProperty("file.resource.loader.modificationCheckInterval", "0");
        properties.setProperty("class.resource.loader.description", "Velocity Classpath Resource Loader");
        properties.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        return this.init(properties);
    }

    protected VelocityContext init(Properties properties) throws Exception {
        Velocity.init((Properties)properties);
        this.objMap = new Hashtable();
        return new VelocityContext();
    }

    public String getCode(NeuralNet neuralNet, String string, String string2, String string3) {
        StringWriter stringWriter = new StringWriter();
        try {
            NeuralNetMatrix neuralNetMatrix = new NeuralNetMatrix(neuralNet.cloneNet());
            this.context.put("netDescriptor", (Object)neuralNetMatrix);
            this.context.put("package", (Object)string2);
            this.context.put("class", (Object)string3);
            this.context.put("helper", (Object)this);
            Template template = null;
            try {
                template = Velocity.getTemplate((String)string);
                template.merge((Context)this.context, (Writer)stringWriter);
            }
            catch (ResourceNotFoundException resourceNotFoundException) {
                String string4 = "couldn't find the template";
                throw new Exception(string4, resourceNotFoundException);
            }
            catch (ParseErrorException parseErrorException) {
                String string5 = "syntax error : problem parsing the template";
                throw new Exception(string5, parseErrorException);
            }
            catch (MethodInvocationException methodInvocationException) {
                String string6 = "Exception threw in the template code";
                throw new Exception(string6, methodInvocationException);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringWriter.toString().trim();
    }

    public ArrayList getFilteredProperties(Object object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
                Method method = propertyDescriptor.getReadMethod();
                Method method2 = propertyDescriptor.getWriteMethod();
                if (propertyDescriptor.isHidden() || propertyDescriptor.isExpert() || method2 == null || method == null) continue;
                String string = propertyDescriptor.getPropertyType().getName();
                Object object2 = method.invoke(object, null);
                String string2 = null;
                if (object2 != null) {
                    if (string.equals("java.lang.String")) {
                        string2 = "\"" + (String)object2 + "\"";
                    }
                    if (string.equals("java.io.File")) {
                        string2 = "new java.io.File(\"" + ((File)object2).getAbsolutePath() + "\")";
                    }
                    if (string.equals("java.util.Date")) {
                        string2 = "new java.util.Date(\"" + DateFormat.getDateInstance().format((Date)object2) + "\")";
                    }
                    if (string.equals("int")) {
                        string2 = ((Integer)object2).toString();
                    }
                    if (string.equals("double")) {
                        string2 = ((Double)object2).toString();
                    }
                    if (string.equals("boolean")) {
                        string2 = ((Boolean)object2).toString();
                    }
                } else {
                    string2 = "null";
                }
                string2 = method2.getName() + "(" + string2 + ")";
                arrayList.add(string2);
            }
        }
        catch (IntrospectionException introspectionException) {
            arrayList.add("IntrospectionException_for_the_object");
            introspectionException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            arrayList.add("IllegalArgumentException_for_the_object");
            illegalArgumentException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            arrayList.add("InvocationTargetException_for_the_object");
            invocationTargetException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            arrayList.add("IllegalAccessException_for_the_object");
            illegalAccessException.printStackTrace();
        }
        return arrayList;
    }

    public void setObj(Object object, Object object2) {
        if (!this.objMap.containsKey(object)) {
            this.objMap.put(object, object2);
        }
    }

    public Object getObj(Object object) {
        return this.objMap.get(object);
    }

    public boolean inherits(Object object, String string) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string);
            return clazz.isAssignableFrom(object.getClass());
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
            return false;
        }
    }
}

