/*
 * Decompiled with CFR 0.152.
 */
package org.joone.helpers.structure;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.joone.engine.Monitor;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.helpers.factory.JooneTools;
import org.joone.io.FileInputSynapse;
import org.joone.io.StreamInputSynapse;
import org.joone.net.NeuralNet;
import org.joone.util.NormalizerPlugIn;

public class NeuralNetFactory {
    public static final int CLASSIFICATION = 1;
    public static final int ONEOFC_CLASSIF = 2;
    public static final int APPROXIMIMATION = 3;
    public static final int PREDICTION = 4;
    public static final int CLUSTERING = 5;
    private int type;
    private String inputFileName;
    private String inputCols;
    private boolean skipFirstInputRow;
    private String desiredFileName;
    private String desiredCols;
    private boolean skipFirstDesiredRow;
    private int taps;
    private int predictLength;
    private int mapWidth;
    private int mapHeight;
    private int numPlugin = 0;

    public NeuralNet getNeuralNetwork() {
        NeuralNet neuralNet = null;
        switch (this.getType()) {
            case 1: 
            case 2: 
            case 3: {
                neuralNet = this.createFFNN();
                break;
            }
            case 4: {
                neuralNet = this.createTimeSeries();
                break;
            }
            case 5: {
                neuralNet = this.createKohonen();
            }
        }
        this.create_IO(neuralNet);
        return neuralNet;
    }

    protected NeuralNet createFFNN() {
        int n = this.getNumOfColumns(this.inputCols);
        int n2 = this.getNumOfColumns(this.desiredCols);
        int[] nArray = new int[]{n, n, n2};
        int n3 = 1;
        switch (this.getType()) {
            case 1: {
                n3 = 2;
                break;
            }
            case 2: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 1;
            }
        }
        NeuralNet neuralNet = JooneTools.create_standard(nArray, n3);
        Monitor monitor = neuralNet.getMonitor();
        monitor.setTotCicles(5000);
        monitor.setTrainingPatterns(this.getNumOfRows(this.inputFileName, this.skipFirstInputRow));
        monitor.setLearning(true);
        return neuralNet;
    }

    protected NeuralNet createKohonen() {
        int n = this.getNumOfColumns(this.inputCols);
        int n2 = 10;
        int[] nArray = new int[]{n, this.getMapWidth(), this.getMapHeight()};
        int n3 = 4;
        NeuralNet neuralNet = JooneTools.create_unsupervised(nArray, n3);
        Monitor monitor = neuralNet.getMonitor();
        monitor.setTotCicles(5000);
        monitor.setTrainingPatterns(this.getNumOfRows(this.inputFileName, this.skipFirstInputRow));
        monitor.setLearning(true);
        return neuralNet;
    }

    protected NeuralNet createTimeSeries() {
        int n = this.getNumOfColumns(this.inputCols);
        int n2 = this.getNumOfColumns(this.desiredCols);
        int[] nArray = new int[]{n, this.getTaps(), n2};
        int n3 = 1;
        NeuralNet neuralNet = JooneTools.create_timeDelay(nArray, this.getTaps() - 1, n3);
        Monitor monitor = neuralNet.getMonitor();
        monitor.setTotCicles(5000);
        monitor.setTrainingPatterns(this.getNumOfRows(this.inputFileName, this.skipFirstInputRow) - this.getPredictionLength());
        monitor.setLearning(true);
        monitor.setPreLearning(this.getTaps());
        return neuralNet;
    }

    protected void create_IO(NeuralNet neuralNet) {
        StreamInputSynapse streamInputSynapse = this.createInput(this.inputFileName, this.inputCols, this.skipFirstInputRow ? 2 : 1);
        neuralNet.getInputLayer().addInputSynapse(streamInputSynapse);
        if (this.getType() != 5) {
            StreamInputSynapse streamInputSynapse2 = this.createInput(this.desiredFileName, this.desiredCols, this.skipFirstDesiredRow ? 2 : 1);
            if (this.getPredictionLength() > 0) {
                streamInputSynapse2.setFirstRow(streamInputSynapse.getFirstRow() + this.getPredictionLength());
            }
            TeachingSynapse teachingSynapse = new TeachingSynapse();
            teachingSynapse.setName("Teacher");
            teachingSynapse.setDesired(streamInputSynapse2);
            neuralNet.getOutputLayer().addOutputSynapse(teachingSynapse);
            neuralNet.setTeacher(teachingSynapse);
        }
    }

    protected StreamInputSynapse createInput(String string, String string2, int n) {
        ++this.numPlugin;
        FileInputSynapse fileInputSynapse = new FileInputSynapse();
        fileInputSynapse.setInputFile(new File(string));
        fileInputSynapse.setAdvancedColumnSelector(string2);
        fileInputSynapse.setFirstRow(n);
        fileInputSynapse.setName("Input Data " + this.numPlugin);
        NormalizerPlugIn normalizerPlugIn = new NormalizerPlugIn();
        normalizerPlugIn.setName("Input PlugIn " + this.numPlugin);
        int n2 = this.getNumOfColumns(string2);
        normalizerPlugIn.setAdvancedSerieSelector("1-" + n2);
        fileInputSynapse.addPlugIn(normalizerPlugIn);
        return fileInputSynapse;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public String getInputFileName() {
        return this.inputFileName;
    }

    public void setInputFileName(String string) {
        this.inputFileName = string;
    }

    public String getInputCols() {
        return this.inputCols;
    }

    public void setInputCols(String string) {
        this.inputCols = string;
    }

    public boolean isSkipFirstInputRow() {
        return this.skipFirstInputRow;
    }

    public void setSkipFirstInputRow(boolean bl) {
        this.skipFirstInputRow = bl;
    }

    public String getDesiredFileName() {
        return this.desiredFileName;
    }

    public void setDesiredFileName(String string) {
        this.desiredFileName = string;
    }

    public String getDesiredCols() {
        return this.desiredCols;
    }

    public void setDesiredCols(String string) {
        this.desiredCols = string;
    }

    public boolean isSkipFirstDesiredRow() {
        return this.skipFirstDesiredRow;
    }

    public void setSkipFirstDesiredRow(boolean bl) {
        this.skipFirstDesiredRow = bl;
    }

    protected int getNumOfColumns(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n2 = stringTokenizer.countTokens();
        for (int i = 0; i < n2; ++i) {
            String string2 = stringTokenizer.nextToken();
            if (string2.indexOf(45) == -1) {
                ++n;
                continue;
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "-");
            int n3 = Integer.valueOf(stringTokenizer2.nextToken());
            int n4 = Integer.valueOf(stringTokenizer2.nextToken());
            n += n4 - n3 + 1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNumOfRows(String string, boolean bl) {
        int n = 0;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            if (bl) {
                bufferedReader.readLine();
            }
            while (bufferedReader.readLine() != null) {
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return n;
    }

    public int getTaps() {
        return this.taps;
    }

    public void setTaps(int n) {
        this.taps = n;
    }

    public int getPredictionLength() {
        return this.predictLength;
    }

    public void setPredictionLength(int n) {
        this.predictLength = n;
    }

    public int getMapWidth() {
        return this.mapWidth;
    }

    public void setMapWidth(int n) {
        this.mapWidth = n;
    }

    public int getMapHeight() {
        return this.mapHeight;
    }

    public void setMapHeight(int n) {
        this.mapHeight = n;
    }
}

