/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.weights;

import org.joone.engine.Matrix;
import org.joone.engine.weights.WeightInitializer;

public class FanInBasedWeightInitializer
implements WeightInitializer {
    private double lowerBound = -2.4;
    private double upperBound = 2.4;
    private boolean sqrtFanIn = false;

    public FanInBasedWeightInitializer() {
    }

    public FanInBasedWeightInitializer(double d) {
        this.lowerBound = -d;
        this.upperBound = d;
    }

    public FanInBasedWeightInitializer(double d, double d2) {
        this.lowerBound = d;
        this.upperBound = d2;
    }

    public void initialize(Matrix matrix) {
        int n = matrix.getM_rows();
        double d = this.isSqrtFanIn() ? Math.sqrt(n) : (double)n;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < matrix.getM_cols(); ++j) {
                if (!matrix.enabled[i][j] || matrix.fixed[i][j]) continue;
                matrix.value[i][j] = this.lowerBound / d + Math.random() * ((this.upperBound - this.lowerBound) / d);
            }
        }
    }

    public void setSqrtFanIn(boolean bl) {
        this.sqrtFanIn = bl;
    }

    public boolean isSqrtFanIn() {
        return this.sqrtFanIn;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double d) {
        this.lowerBound = d;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double d) {
        this.upperBound = d;
    }
}

