/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.listeners;

import org.joone.engine.Monitor;
import org.joone.engine.listeners.ConvergenceObserver;

public class ErrorBasedConvergenceObserver
extends ConvergenceObserver {
    private double percentage = -1.0;
    private int cycles = 5;
    private int cycleCounter = 0;
    private double lastError = -1.0;

    public void setPercentage(double d) {
        this.percentage = d;
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void setCycles(int n) {
        this.cycles = n;
    }

    public int getCycles() {
        return this.cycles;
    }

    protected void manageStop(Monitor monitor) {
    }

    protected void manageCycle(Monitor monitor) {
    }

    protected void manageStart(Monitor monitor) {
    }

    protected void manageError(Monitor monitor) {
        if (this.percentage < 0.0 || this.cycles <= 0) {
            return;
        }
        double d = monitor.getGlobalError();
        if (this.lastError >= 0.0) {
            double d2 = (this.lastError - d) * 100.0 / this.lastError;
            if (d2 <= this.percentage && d2 >= 0.0) {
                ++this.cycleCounter;
            } else {
                this.disableCurrentConvergence = false;
                this.cycleCounter = 0;
            }
            if (this.cycleCounter == this.cycles) {
                if (!this.disableCurrentConvergence) {
                    this.fireNetConverged(monitor);
                }
                this.cycleCounter = 0;
            }
        }
        this.lastError = d;
    }

    protected void manageStopError(Monitor monitor, String string) {
    }
}

