/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.learning;

import java.io.IOException;
import java.util.TreeSet;
import org.joone.engine.Fifo;
import org.joone.engine.Monitor;
import org.joone.engine.NetErrorManager;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.Pattern;
import org.joone.engine.Synapse;
import org.joone.engine.learning.TeacherSynapse;
import org.joone.io.StreamInputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class ComparisonSynapse
extends Synapse {
    private static final ILogger log = LoggerFactory.getLogger(TeacherSynapse.class);
    private StreamInputSynapse desired;
    protected transient Fifo fifo;
    protected transient boolean firstTime = true;
    private static final long serialVersionUID = -1301682557631180066L;

    protected void backward(double[] dArray) {
    }

    protected void forward(double[] dArray) {
        if (this.m_pattern.getCount() == 1 || this.m_pattern.isMarkedAsStoppingPattern()) {
            try {
                this.desired.gotoFirstLine();
            }
            catch (IOException iOException) {
                this.warnLogger("IOException while forwarding the influx. Message is : " + iOException.getMessage(), iOException, log);
            }
        }
        if (this.m_pattern.isMarkedAsStoppingPattern()) {
            this.stopTheNet();
            return;
        }
        this.firstTime = false;
        this.outs = new double[dArray.length];
        Pattern pattern = this.desired.fwdGet();
        if (this.m_pattern.getCount() != pattern.getCount()) {
            new NetErrorManager(this.getMonitor(), "ComparisonSynapse: No matching patterns - input#" + this.m_pattern.getCount() + " desired#" + pattern.getCount());
            return;
        }
        double[] dArray2 = pattern.getArray();
        if (dArray2 != null) {
            this.outs = new double[this.getOutputDimension()];
            int n = 0;
            int n2 = 0;
            while (n < dArray.length) {
                this.outs[n2] = dArray[n];
                ++n;
                ++n2;
            }
            n = 0;
            while (n < dArray2.length) {
                this.outs[n2] = dArray2[n];
                ++n;
                ++n2;
            }
            this.pushValue(this.outs, this.m_pattern.getCount());
        }
    }

    protected void stopTheNet() {
        this.pushStop();
        this.firstTime = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pattern fwdGet() {
        ComparisonSynapse comparisonSynapse = this;
        synchronized (comparisonSynapse) {
            while (this.getFifo().empty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.warnLogger("wait() was interrupted. Message is : " + interruptedException.getMessage(), log);
                    return null;
                }
            }
            Pattern pattern = (Pattern)this.fifo.pop();
            this.notifyAll();
            return pattern;
        }
    }

    public void fwdPut(Pattern pattern) {
        if (!this.isEnabled()) {
            if (pattern.isMarkedAsStoppingPattern()) {
                this.stopTheNet();
            }
            return;
        }
        super.fwdPut(pattern);
        this.items = 0;
    }

    public StreamInputSynapse getDesired() {
        return this.desired;
    }

    private Fifo getFifo() {
        if (this.fifo == null) {
            this.fifo = new Fifo();
        }
        return this.fifo;
    }

    public Pattern revGet() {
        return null;
    }

    public void revPut(Pattern pattern) {
    }

    protected void setArrays(int n, int n2) {
    }

    public boolean setDesired(StreamInputSynapse streamInputSynapse) {
        if (streamInputSynapse == null) {
            if (this.desired != null) {
                this.desired.setInputFull(false);
            }
            this.desired = null;
        } else {
            if (streamInputSynapse.isInputFull()) {
                return false;
            }
            this.desired = streamInputSynapse;
            this.desired.setStepCounter(false);
            this.desired.setOutputDimension(this.getInputDimension());
            this.desired.setInputFull(true);
        }
        return true;
    }

    public void resetInput() {
        if (this.getDesired() != null) {
            this.getDesired().resetInput();
        }
    }

    protected void setDimensions(int n, int n2) {
    }

    public void setInputDimension(int n) {
        super.setInputDimension(n);
        if (this.getDesired() != null) {
            this.getDesired().setOutputDimension(n);
        }
    }

    public TreeSet check() {
        TreeSet treeSet = super.check();
        if (this.desired == null) {
            treeSet.add(new NetCheck(0, "Desired Input has not been set.", this));
        } else {
            treeSet.addAll(this.desired.check());
        }
        return treeSet;
    }

    public void reset() {
        super.reset();
        if (this.getDesired() != null) {
            this.getDesired().reset();
        }
    }

    public void setMonitor(Monitor monitor) {
        super.setMonitor(monitor);
        if (this.getMonitor() != null) {
            this.getMonitor().setSupervised(true);
        }
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
        this.pushStop();
        this.firstTime = true;
        this.reset();
    }

    private void pushStop() {
        double[] dArray = new double[this.getOutputDimension()];
        this.pushValue(dArray, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushValue(double[] dArray, int n) {
        Pattern pattern = new Pattern(dArray);
        pattern.setCount(n);
        ComparisonSynapse comparisonSynapse = this;
        synchronized (comparisonSynapse) {
            this.getFifo().push(pattern);
            this.notify();
        }
    }

    public int getOutputDimension() {
        return this.getInputDimension() * 2;
    }

    public void init() {
        super.init();
        if (this.getDesired() != null) {
            this.getDesired().init();
        }
    }
}

