/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.extenders;

import org.joone.engine.ExtendableLearner;
import org.joone.engine.Monitor;
import org.joone.engine.extenders.DeltaRuleExtender;

public class SimulatedAnnealingExtender
extends DeltaRuleExtender {
    private double theN = 0.3;
    private double theK = 0.002;
    private double theBoundary = 0.5;

    public double getDelta(double[] dArray, int n, double d) {
        ExtendableLearner extendableLearner = this.getLearner();
        if (extendableLearner.getUpdateWeightExtender().storeWeightsBiases()) {
            Monitor monitor = extendableLearner.getMonitor();
            int n2 = monitor.getTotCicles() - monitor.getCurrentCicle();
            d += this.getN() * this.getRandom() * Math.pow(2.0, -1.0 * this.getK() * (double)n2);
        }
        return d;
    }

    public double getDelta(double[] dArray, int n, double[] dArray2, int n2, double d) {
        ExtendableLearner extendableLearner = this.getLearner();
        if (extendableLearner.getUpdateWeightExtender().storeWeightsBiases()) {
            Monitor monitor = extendableLearner.getMonitor();
            int n3 = monitor.getTotCicles() - monitor.getCurrentCicle();
            d += this.getN() * this.getRandom() * Math.pow(2.0, -1.0 * this.getK() * (double)n3);
        }
        return d;
    }

    public void postBiasUpdate(double[] dArray) {
    }

    public void postWeightUpdate(double[] dArray, double[] dArray2) {
    }

    public void preBiasUpdate(double[] dArray) {
    }

    public void preWeightUpdate(double[] dArray, double[] dArray2) {
    }

    public double getN() {
        return this.theN;
    }

    public void setN(double d) {
        this.theN = d;
    }

    public double getK() {
        return this.theK;
    }

    public void setK(double d) {
        this.theK = d;
    }

    public double getRandomBoundary() {
        return this.theBoundary;
    }

    public void setRandomBoundary(double d) {
        this.theBoundary = d;
    }

    protected double getRandom() {
        double d = this.getRandomBoundary();
        return Math.random() * 2.0 * d - d;
    }
}

