/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine.extenders;

import org.joone.engine.LearnableLayer;
import org.joone.engine.LearnableSynapse;
import org.joone.engine.Matrix;
import org.joone.engine.extenders.UpdateWeightExtender;

public class BatchModeExtender
extends UpdateWeightExtender {
    private int theBatchSize = -1;
    private int theRows = -1;
    private int theColumns = -1;
    private Matrix theMatrix;
    private int theCounter = 0;

    public void postBiasUpdate(double[] dArray) {
        if (this.storeWeightsBiases()) {
            for (int i = 0; i < this.theRows; ++i) {
                double[] dArray2 = this.theMatrix.value[i];
                dArray2[0] = dArray2[0] + this.theMatrix.delta[i][0];
            }
            this.getLearner().getLayer().setBias((Matrix)this.theMatrix.clone());
            this.resetDelta(this.theMatrix);
            this.theCounter = 0;
        }
    }

    public void postWeightUpdate(double[] dArray, double[] dArray2) {
        if (this.storeWeightsBiases()) {
            for (int i = 0; i < this.theRows; ++i) {
                for (int j = 0; j < this.theColumns; ++j) {
                    double[] dArray3 = this.theMatrix.value[i];
                    int n = j;
                    dArray3[n] = dArray3[n] + this.theMatrix.delta[i][j];
                }
            }
            this.getLearner().getSynapse().setWeights((Matrix)this.theMatrix.clone());
            this.resetDelta(this.theMatrix);
            this.theCounter = 0;
        }
    }

    public void preBiasUpdate(double[] dArray) {
        if (this.theRows != this.getLearner().getLayer().getRows()) {
            this.initiateNewBatch();
        }
        ++this.theCounter;
    }

    public void preWeightUpdate(double[] dArray, double[] dArray2) {
        LearnableSynapse learnableSynapse = this.getLearner().getSynapse();
        if (this.theRows != learnableSynapse.getInputDimension() || this.theColumns != learnableSynapse.getOutputDimension()) {
            this.initiateNewBatch();
        }
        ++this.theCounter;
    }

    public void updateBias(int n, double d) {
        double[] dArray = this.theMatrix.delta[n];
        dArray[0] = dArray[0] + d;
    }

    public void updateWeight(int n, int n2, double d) {
        double[] dArray = this.theMatrix.delta[n];
        int n3 = n2;
        dArray[n3] = dArray[n3] + d;
    }

    protected void resetDelta(Matrix matrix) {
        for (int i = 0; i < matrix.delta.length; ++i) {
            for (int j = 0; j < matrix.delta[0].length; ++j) {
                matrix.delta[i][j] = 0.0;
            }
        }
    }

    protected void initiateNewBatch() {
        LearnableLayer learnableLayer = this.getLearner().getLayer();
        if (learnableLayer != null) {
            this.theRows = learnableLayer.getRows();
            this.theMatrix = (Matrix)learnableLayer.getBias().clone();
        } else {
            LearnableSynapse learnableSynapse = this.getLearner().getSynapse();
            if (learnableSynapse != null) {
                this.theRows = learnableSynapse.getInputDimension();
                this.theColumns = learnableSynapse.getOutputDimension();
                this.theMatrix = (Matrix)learnableSynapse.getWeights().clone();
            }
        }
        this.resetDelta(this.theMatrix);
        this.theCounter = 0;
    }

    public void setBatchSize(int n) {
        this.theBatchSize = n;
    }

    public int getBatchSize() {
        if (this.theBatchSize < 0) {
            return this.getLearner().getMonitor().getBatchSize();
        }
        return this.theBatchSize;
    }

    public boolean storeWeightsBiases() {
        return this.theCounter >= this.getBatchSize();
    }
}

