/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import org.joone.engine.LearnableLayer;
import org.joone.engine.SimpleLayer;
import org.joone.exception.JooneRuntimeException;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class SineLayer
extends SimpleLayer
implements LearnableLayer {
    private static final long serialVersionUID = -2636086679111635756L;
    private static final ILogger log = LoggerFactory.getLogger(SineLayer.class);

    public SineLayer() {
        this.learnable = true;
    }

    public SineLayer(String string) {
        this();
        this.setLayerName(string);
    }

    protected void forward(double[] dArray) throws JooneRuntimeException {
        int n = this.getRows();
        int n2 = 0;
        try {
            for (n2 = 0; n2 < n; ++n2) {
                double d = dArray[n2] + this.getBias().value[n2][0];
                this.outs[n2] = Math.sin(d);
            }
        }
        catch (Exception exception) {
            String string = "Exception thrown while processing the element " + n2 + " of the array. Value is : " + dArray[n2] + " Exception thrown is " + exception.getClass().getName() + ". Message is " + exception.getMessage();
            log.error(string);
            throw new JooneRuntimeException(string, exception);
        }
    }

    public void backward(double[] dArray) throws JooneRuntimeException {
        super.backward(dArray);
        int n = this.getRows();
        int n2 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            this.gradientOuts[n2] = dArray[n2] * Math.cos(this.inps[n2]);
        }
        this.myLearner.requestBiasUpdate(this.gradientOuts);
    }
}

