/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import org.joone.engine.LearnableLayer;
import org.joone.engine.Learner;
import org.joone.engine.SimpleLayer;
import org.joone.exception.JooneRuntimeException;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class SigmoidLayer
extends SimpleLayer
implements LearnableLayer {
    private static final ILogger log = LoggerFactory.getLogger(SigmoidLayer.class);
    private static final long serialVersionUID = -8700747963164046048L;
    private double flatSpotConstant = 0.0;

    public SigmoidLayer() {
        this.learnable = true;
    }

    public SigmoidLayer(String string) {
        this();
        this.setLayerName(string);
    }

    public void backward(double[] dArray) throws JooneRuntimeException {
        super.backward(dArray);
        int n = this.getRows();
        double d = this.getFlatSpotConstant();
        for (int i = 0; i < n; ++i) {
            this.gradientOuts[i] = dArray[i] * (this.outs[i] * (1.0 - this.outs[i]) + d);
        }
        this.myLearner.requestBiasUpdate(this.gradientOuts);
    }

    public void forward(double[] dArray) throws JooneRuntimeException {
        int n = -1;
        int n2 = this.getRows();
        try {
            for (n = 0; n < n2; ++n) {
                double d = dArray[n] + this.bias.value[n][0];
                this.outs[n] = 1.0 / (1.0 + Math.exp(-d));
            }
        }
        catch (Exception exception) {
            String string = "Exception thrown while processing the element " + n + " of the array. Value is : " + dArray[n] + " Exception thrown is " + exception.getClass().getName() + ". Message is " + exception.getMessage();
            log.error(string);
            throw new JooneRuntimeException(string, exception);
        }
    }

    public Learner getLearner() {
        this.learnable = true;
        return super.getLearner();
    }

    public void setFlatSpotConstant(double d) {
        this.flatSpotConstant = d;
    }

    public double getFlatSpotConstant() {
        return this.flatSpotConstant;
    }
}

