/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.util.ArrayList;
import java.util.Collection;
import org.joone.engine.RbfGaussianParameters;
import org.joone.engine.RbfLayer;
import org.joone.exception.JooneRuntimeException;
import org.joone.inspection.implementations.BiasInspection;
import org.joone.io.StreamInputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.util.ConverterPlugIn;
import org.joone.util.RbfRandomCenterSelector;

public class RbfGaussianLayer
extends RbfLayer {
    private static final ILogger log = LoggerFactory.getLogger(RbfGaussianLayer.class);
    private RbfGaussianParameters[] theGaussianParameters;
    private boolean theUseRandomSelector = true;
    private RbfRandomCenterSelector theRandomSelector;

    protected void backward(double[] dArray) throws JooneRuntimeException {
        for (int i = 0; i < this.gradientInps.length; ++i) {
            this.gradientOuts[i] = this.gradientInps[i];
        }
    }

    protected void forward(double[] dArray) throws JooneRuntimeException {
        if (this.theUseRandomSelector && this.theGaussianParameters == null) {
            this.setGaussianParameters(this.theRandomSelector.getGaussianParameters());
        }
        int n = 0;
        try {
            for (n = 0; n < this.getRows(); ++n) {
                double d = 0.0;
                for (int i = 0; i < dArray.length; ++i) {
                    double d2 = dArray[i] - this.theGaussianParameters[n].getMean()[i];
                    d += d2 * d2;
                }
                this.outs[n] = Math.exp(d / (-2.0 * this.theGaussianParameters[n].getStdDeviation() * this.theGaussianParameters[n].getStdDeviation()));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string = "Exception thrown while processing the element " + n + " of the array. Value is : " + dArray[n] + " Exception thrown is " + exception.getClass().getName() + ". Message is " + exception.getMessage();
            log.error(string);
            throw new JooneRuntimeException(string, exception);
        }
    }

    protected void setDimensions() {
        super.setDimensions();
        this.gradientOuts = new double[this.gradientInps.length];
    }

    public RbfGaussianParameters[] getGaussianParameters() {
        return this.theGaussianParameters;
    }

    public void setGaussianParameters(RbfGaussianParameters[] rbfGaussianParametersArray) {
        if (rbfGaussianParametersArray.length != this.getRows()) {
            this.setRows(rbfGaussianParametersArray.length);
            log.warn("Setting new RBF Gaussian parameters -> # neurons changed.");
        }
        this.theGaussianParameters = rbfGaussianParametersArray;
    }

    public void useRandomCenter(StreamInputSynapse streamInputSynapse) {
        this.theUseRandomSelector = true;
        this.theRandomSelector = new RbfRandomCenterSelector(this);
        if (streamInputSynapse.getPlugIn() == null) {
            streamInputSynapse.setPlugIn(this.theRandomSelector);
        } else {
            ConverterPlugIn converterPlugIn = streamInputSynapse.getPlugIn();
            converterPlugIn.addPlugIn(this.theRandomSelector);
        }
    }

    public Collection Inspections() {
        ArrayList<BiasInspection> arrayList = new ArrayList<BiasInspection>();
        arrayList.add(new BiasInspection(null));
        return arrayList;
    }
}

