/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.BasicLearner;
import org.joone.engine.Learner;
import org.joone.engine.LearnerFactory;
import org.joone.engine.NetStoppedEventNotifier;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;

public class Monitor
implements Serializable {
    private static final long serialVersionUID = 2909501813894146845L;
    private int preLearning = 0;
    private boolean learning = false;
    private int currentCicle;
    private int run = 0;
    private int saveCurrentCicle;
    private int saveRun;
    private int patterns;
    private int validationPatterns;
    private int totCicles;
    private double learningRate;
    private double momentum;
    private double globalError;
    private int batchSize = 0;
    private boolean useRMSE = true;
    private LearnerFactory theLearnerFactory = null;
    private Monitor parent = null;
    private transient Vector internalListeners = new Vector();
    private transient Vector netListeners = new Vector();
    private transient boolean firstTime = true;
    private transient boolean exporting = false;
    private transient boolean validation = false;
    private transient boolean running = false;
    private transient boolean trainingDataForValidation = false;
    private static final ILogger log = LoggerFactory.getLogger(Monitor.class);
    private boolean supervisioned = false;
    private boolean singleThreadMode = true;
    public int learningMode = 0;
    private List learners;
    private Hashtable params;

    public Monitor() {
        this.internalListeners = new Vector();
    }

    public void addNeuralNetListener(NeuralNetListener neuralNetListener) {
        this.addNeuralNetListener(neuralNetListener, true);
    }

    public synchronized void addNeuralNetListener(NeuralNetListener neuralNetListener, boolean bl) {
        if (this.parent != null) {
            this.parent.addNeuralNetListener(neuralNetListener, bl);
        } else {
            if (this.getListeners().contains(neuralNetListener)) {
                log.warn("Neural net listener already registered");
                return;
            }
            this.netListeners.addElement(neuralNetListener);
            if (!bl && !this.getNoDetachListeners().contains(neuralNetListener)) {
                this.getNoDetachListeners().addElement(neuralNetListener);
            }
        }
    }

    private Vector getNoDetachListeners() {
        if (this.internalListeners == null) {
            this.internalListeners = new Vector();
        }
        return this.internalListeners;
    }

    private Vector getListeners() {
        if (this.netListeners == null) {
            this.netListeners = new Vector();
        }
        return this.netListeners;
    }

    public void fireCicleTerminated() {
        if (this.parent != null) {
            this.parent.fireCicleTerminated();
        } else {
            Object[] objectArray = this.getListenersArrayQuickly();
            if (objectArray == null) {
                return;
            }
            NeuralNetEvent neuralNetEvent = new NeuralNetEvent(this);
            for (int i = 0; i < objectArray.length; ++i) {
                NeuralNetListener neuralNetListener = (NeuralNetListener)objectArray[i];
                neuralNetListener.cicleTerminated(neuralNetEvent);
            }
        }
    }

    public void fireNetStarted() {
        if (this.parent != null) {
            this.parent.fireNetStarted();
        } else {
            Object[] objectArray = this.getListenersArraySafely();
            if (objectArray == null) {
                return;
            }
            NeuralNetEvent neuralNetEvent = new NeuralNetEvent(this);
            for (int i = 0; i < objectArray.length; ++i) {
                NeuralNetListener neuralNetListener = (NeuralNetListener)objectArray[i];
                neuralNetListener.netStarted(neuralNetEvent);
            }
        }
    }

    public void fireNetStopped() {
        if (this.parent != null) {
            this.parent.fireNetStopped();
        } else {
            Object[] objectArray = this.getListenersArraySafely();
            if (objectArray == null) {
                return;
            }
            NeuralNetEvent neuralNetEvent = new NeuralNetEvent(this);
            for (int i = 0; i < objectArray.length; ++i) {
                NeuralNetListener neuralNetListener = (NeuralNetListener)objectArray[i];
                neuralNetListener.netStopped(neuralNetEvent);
            }
        }
    }

    public void fireNetStoppedError(String string) {
        if (this.parent != null) {
            this.parent.fireNetStoppedError(string);
        } else {
            Object[] objectArray = this.getListenersArraySafely();
            if (objectArray == null) {
                return;
            }
            NeuralNetEvent neuralNetEvent = new NeuralNetEvent(this);
            for (int i = 0; i < objectArray.length; ++i) {
                NeuralNetListener neuralNetListener = (NeuralNetListener)objectArray[i];
                neuralNetListener.netStoppedError(neuralNetEvent, string);
            }
            if (this.running) {
                log.error("Neural net stopped due to the following error: " + string);
                log.debug("\tepoch:" + this.currentCicle);
                log.debug("\tcycle:" + this.run);
                log.debug("\tlearning:" + this.isLearning());
                log.debug("\tvalidation:" + this.isValidation());
                log.debug("\ttrainingPatterns:" + this.getTrainingPatterns());
                log.debug("\tvalidationPatterns:" + this.getValidationPatterns());
            }
        }
    }

    public void fireErrorChanged() {
        if (this.parent != null) {
            this.parent.fireErrorChanged();
        } else {
            Object[] objectArray = this.getListenersArrayQuickly();
            if (objectArray == null) {
                return;
            }
            NeuralNetEvent neuralNetEvent = new NeuralNetEvent(this);
            for (int i = 0; i < objectArray.length; ++i) {
                NeuralNetListener neuralNetListener = (NeuralNetListener)objectArray[i];
                neuralNetListener.errorChanged(neuralNetEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getListenersArrayQuickly() {
        int n = this.getListeners().size();
        if (n == 0) {
            return null;
        }
        Monitor monitor = this;
        synchronized (monitor) {
            Object[] objectArray = this.getListeners().toArray();
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] getListenersArraySafely() {
        Monitor monitor = this;
        synchronized (monitor) {
            int n = this.getListeners().size();
            if (n == 0) {
                return null;
            }
            return this.getListeners().toArray();
        }
    }

    public synchronized int getCurrentCicle() {
        if (this.parent != null) {
            return this.parent.getCurrentCicle();
        }
        return this.currentCicle;
    }

    public double getGlobalError() {
        if (this.parent != null) {
            return this.parent.getGlobalError();
        }
        return this.globalError;
    }

    public synchronized double getLearningRate() {
        if (this.parent != null) {
            return this.parent.getLearningRate();
        }
        return this.learningRate;
    }

    public double getMomentum() {
        if (this.parent != null) {
            return this.parent.getMomentum();
        }
        return this.momentum;
    }

    public int getTrainingPatterns() {
        if (this.parent != null) {
            return this.parent.getTrainingPatterns();
        }
        return this.patterns;
    }

    public void setTrainingPatterns(int n) {
        if (this.parent != null) {
            this.parent.setTrainingPatterns(n);
        } else {
            this.patterns = n;
        }
    }

    public int getPreLearning() {
        if (this.parent != null) {
            return this.parent.getPreLearning();
        }
        return this.preLearning;
    }

    public synchronized int getStep() {
        if (this.parent != null) {
            return this.parent.getStep();
        }
        return this.run;
    }

    public int getTotCicles() {
        if (this.parent != null) {
            return this.parent.getTotCicles();
        }
        return this.totCicles;
    }

    public synchronized void Go() {
        if (this.parent != null) {
            this.parent.Go();
        } else {
            this.setSingleThreadMode(false);
            this.run = this.getNumOfPatterns();
            this.currentCicle = this.totCicles;
            this.firstTime = false;
            this.running = true;
            this.notifyAll();
        }
    }

    public boolean isLearning() {
        return this.learning;
    }

    public boolean isLearningCicle(int n) {
        if (this.parent != null) {
            boolean bl = this.parent.isLearningCicle(n);
            return bl & this.isLearning();
        }
        if (n > this.preLearning) {
            return this.isLearning();
        }
        return false;
    }

    public synchronized void resetCycle() {
        this.run = 0;
    }

    public synchronized boolean nextStep() {
        if (this.parent != null) {
            return this.parent.nextStep();
        }
        while (this.run == 0) {
            try {
                if (!this.firstTime) {
                    if (this.currentCicle > 0) {
                        this.fireCicleTerminated();
                        --this.currentCicle;
                        if (this.currentCicle < 0) {
                            this.currentCicle = 0;
                        }
                        this.run = this.getNumOfPatterns();
                    }
                    if (this.currentCicle != 0) continue;
                    this.running = false;
                    if (!this.isSupervised() || !this.isLearning() && !this.isValidation()) {
                        new NetStoppedEventNotifier(this).start();
                    }
                    if (this.saveRun == 0) {
                        this.saveRun = this.getNumOfPatterns();
                        this.saveCurrentCicle = this.totCicles;
                    }
                    this.run = 0;
                    this.firstTime = true;
                    return false;
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                this.run = 0;
                this.firstTime = true;
                return false;
            }
        }
        if (this.run == this.getNumOfPatterns() && this.currentCicle == this.totCicles) {
            this.fireNetStarted();
        }
        if (this.run > 0) {
            --this.run;
        }
        return true;
    }

    protected Object readResolve() {
        this.firstTime = true;
        return this;
    }

    public synchronized void removeNeuralNetListener(NeuralNetListener neuralNetListener) {
        if (this.parent != null) {
            this.parent.removeNeuralNetListener(neuralNetListener);
        } else {
            this.getListeners().removeElement(neuralNetListener);
            this.getNoDetachListeners().removeElement(neuralNetListener);
        }
    }

    public synchronized void runAgain() {
        if (this.parent != null) {
            this.parent.runAgain();
        } else {
            this.run = this.getNumOfPatterns();
            this.currentCicle = this.saveCurrentCicle;
            this.firstTime = false;
            this.running = true;
            this.notifyAll();
        }
    }

    public synchronized void setCurrentCicle(int n) {
        if (this.parent != null) {
            this.parent.setCurrentCicle(n);
        } else {
            this.currentCicle = n;
        }
    }

    public void setGlobalError(double d) {
        if (this.parent != null) {
            this.parent.setGlobalError(d);
        } else {
            this.globalError = d;
            this.fireErrorChanged();
        }
    }

    public void setLearning(boolean bl) {
        this.learning = bl;
    }

    public synchronized void setLearningRate(double d) {
        if (this.parent != null) {
            this.parent.setLearningRate(d);
        } else {
            this.learningRate = d;
        }
    }

    public void setMomentum(double d) {
        if (this.parent != null) {
            this.parent.setMomentum(d);
        } else {
            this.momentum = d;
        }
    }

    public void setPreLearning(int n) {
        if (this.parent != null) {
            this.parent.setPreLearning(n);
        } else {
            this.preLearning = n;
        }
    }

    public void setTotCicles(int n) {
        if (this.parent != null) {
            this.parent.setTotCicles(n);
        } else {
            this.totCicles = n;
        }
    }

    public synchronized void Stop() {
        if (this.parent != null) {
            this.parent.Stop();
        } else {
            this.saveRun = this.run;
            this.saveCurrentCicle = this.currentCicle;
            this.run = 0;
            this.currentCicle = 0;
        }
    }

    public boolean isExporting() {
        if (this.parent != null) {
            return this.parent.isExporting();
        }
        return this.exporting;
    }

    public void setExporting(boolean bl) {
        if (this.parent != null) {
            this.parent.setExporting(bl);
        } else {
            this.exporting = bl;
        }
    }

    public synchronized int getRun() {
        return this.run;
    }

    public boolean isValidation() {
        if (this.parent != null) {
            return this.parent.isValidation();
        }
        return this.validation;
    }

    public void setValidation(boolean bl) {
        if (this.parent != null) {
            this.parent.setValidation(bl);
        } else {
            this.validation = bl;
        }
    }

    public boolean isTrainingDataForValidation() {
        if (this.parent != null) {
            return this.parent.isTrainingDataForValidation();
        }
        return this.trainingDataForValidation;
    }

    public void setTrainingDataForValidation(boolean bl) {
        if (this.parent != null) {
            this.parent.setTrainingDataForValidation(bl);
        } else {
            this.trainingDataForValidation = bl;
        }
    }

    public void removeAllListeners() {
        if (this.parent != null) {
            this.parent.removeAllListeners();
        } else {
            this.netListeners = this.internalListeners != null ? (Vector)this.internalListeners.clone() : null;
        }
    }

    public Monitor getParent() {
        return this.parent;
    }

    public void setParent(Monitor monitor) {
        this.parent = monitor;
    }

    public int getValidationPatterns() {
        if (this.parent != null) {
            return this.parent.getValidationPatterns();
        }
        return this.validationPatterns;
    }

    public void setValidationPatterns(int n) {
        if (this.parent != null) {
            this.parent.setValidationPatterns(n);
        } else {
            this.validationPatterns = n;
        }
    }

    public int getNumOfPatterns() {
        if (this.parent != null) {
            return this.parent.getNumOfPatterns();
        }
        if (this.isValidation() && !this.isTrainingDataForValidation()) {
            return this.validationPatterns;
        }
        return this.patterns;
    }

    public TreeSet check() {
        TreeSet<NetCheck> treeSet = new TreeSet<NetCheck>();
        if (this.getLearningRate() <= 0.0 && this.isLearning()) {
            treeSet.add(new NetCheck(0, "Learning Rate must be greater than zero.", this));
        }
        if (this.isValidation() && this.getValidationPatterns() <= 0) {
            treeSet.add(new NetCheck(0, "Validation Patterns not set.", this));
        }
        if (this.isLearning() && this.getTrainingPatterns() <= 0) {
            treeSet.add(new NetCheck(0, "Training Patterns not set.", this));
        }
        if (!this.isValidation() && this.getTrainingPatterns() <= 0) {
            treeSet.add(new NetCheck(0, "Training Patterns not set.", this));
        }
        if (this.getTotCicles() <= 0) {
            treeSet.add(new NetCheck(0, "TotCicles (epochs) not set.", this));
        }
        return treeSet;
    }

    public boolean isSupervised() {
        if (this.parent != null) {
            return this.parent.isSupervised();
        }
        return this.supervisioned;
    }

    public void setSupervised(boolean bl) {
        if (this.parent != null) {
            this.parent.setSupervised(bl);
        } else {
            this.supervisioned = bl;
        }
    }

    public int getBatchSize() {
        if (this.parent != null) {
            return this.parent.getBatchSize();
        }
        return this.batchSize;
    }

    public void setBatchSize(int n) {
        if (this.parent != null) {
            this.parent.setBatchSize(n);
        } else {
            this.batchSize = n;
        }
    }

    public int getLearningMode() {
        return this.learningMode;
    }

    public void setLearningMode(int n) {
        this.learningMode = n;
    }

    public Learner getLearner(int n) {
        Learner learner = null;
        List list = this.getLearners();
        if (n < list.size() && n >= 0) {
            String string = (String)list.get(n);
            try {
                Class<?> clazz = Class.forName(string);
                learner = (Learner)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.error("Class " + string + " not found");
            }
            catch (InstantiationException instantiationException) {
                log.error("Error instantiating the class " + string);
            }
            catch (IllegalAccessException illegalAccessException) {
                log.error("Illegal access instantiating the class " + string);
            }
        }
        if (learner == null) {
            learner = new BasicLearner();
        }
        learner.setMonitor(this);
        return learner;
    }

    public Learner getLearner() {
        Learner learner = null;
        if (this.theLearnerFactory != null) {
            learner = this.theLearnerFactory.getLearner(this);
            learner.setMonitor(this);
        }
        if (learner == null) {
            learner = this.getLearner(this.getLearningMode());
        }
        return learner;
    }

    protected List getLearners() {
        if (this.learners == null) {
            this.learners = new ArrayList(10);
        }
        return this.learners;
    }

    protected void setLearners(List list) {
        this.learners = list;
    }

    public void addLearner(int n, String string) {
        if (!this.getLearners().contains(string)) {
            this.getLearners().add(n, string);
        }
    }

    public Object getParam(String string) {
        if (this.params == null) {
            return null;
        }
        return this.params.get(string);
    }

    public void setParam(String string, Object object) {
        if (this.params == null) {
            this.params = new Hashtable();
        } else if (this.params.containsKey(string)) {
            this.params.remove(string);
        }
        this.params.put(string, object);
    }

    public String[] getKeys() {
        if (this.params == null) {
            return null;
        }
        String[] stringArray = new String[this.params.keySet().size()];
        Enumeration enumeration = this.params.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n] = (String)enumeration.nextElement();
            ++n;
        }
        return stringArray;
    }

    public void setUseRMSE(boolean bl) {
        this.useRMSE = bl;
    }

    public boolean isUseRMSE() {
        return this.useRMSE;
    }

    public void setLearnerFactory(LearnerFactory learnerFactory) {
        this.theLearnerFactory = learnerFactory;
    }

    public boolean isSingleThreadMode() {
        if (this.parent != null) {
            return this.parent.isSingleThreadMode();
        }
        return this.singleThreadMode;
    }

    public void setSingleThreadMode(boolean bl) {
        if (this.parent != null) {
            this.parent.setSingleThreadMode(bl);
        } else {
            this.singleThreadMode = bl;
        }
    }
}

