/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.util.ArrayList;
import java.util.Collection;
import org.joone.engine.SimpleLayer;
import org.joone.inspection.implementations.BiasInspection;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class LinearLayer
extends SimpleLayer {
    private double beta = 1.0;
    private static final ILogger log = LoggerFactory.getLogger(LinearLayer.class);
    private static final long serialVersionUID = 2243109263560495304L;

    public LinearLayer() {
    }

    public LinearLayer(String string) {
        super(string);
    }

    public void backward(double[] dArray) {
        int n = this.getRows();
        for (int i = 0; i < n; ++i) {
            this.gradientOuts[i] = dArray[i] * this.beta;
        }
    }

    public void forward(double[] dArray) {
        int n = this.getRows();
        for (int i = 0; i < n; ++i) {
            this.outs[i] = this.beta * dArray[i];
        }
    }

    public double getBeta() {
        return this.beta;
    }

    public void setBeta(double d) {
        this.beta = d;
    }

    public Collection Inspections() {
        ArrayList<BiasInspection> arrayList = new ArrayList<BiasInspection>();
        arrayList.add(new BiasInspection(null));
        return arrayList;
    }
}

