/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import java.util.Vector;
import org.joone.engine.InputPatternListener;
import org.joone.engine.LearnableLayer;
import org.joone.engine.Learner;
import org.joone.engine.Matrix;
import org.joone.engine.Monitor;
import org.joone.engine.NetErrorManager;
import org.joone.engine.NeuralElement;
import org.joone.engine.NeuralLayer;
import org.joone.engine.NeuralNetListener;
import org.joone.engine.OutputPatternListener;
import org.joone.engine.OutputSwitchSynapse;
import org.joone.engine.Pattern;
import org.joone.engine.Synapse;
import org.joone.engine.learning.TeacherSynapse;
import org.joone.engine.learning.TeachingSynapse;
import org.joone.exception.JooneRuntimeException;
import org.joone.inspection.Inspectable;
import org.joone.inspection.implementations.BiasInspection;
import org.joone.io.InputSynapse;
import org.joone.io.StreamInputSynapse;
import org.joone.io.StreamOutputSynapse;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NetCheck;
import org.joone.util.NotSerialize;

public abstract class Layer
implements NeuralLayer,
Runnable,
Serializable,
Inspectable,
LearnableLayer {
    public static final int STOP_FLAG = -1;
    private static final long serialVersionUID = -1572591602454639355L;
    private String LayerName;
    private int rows = 0;
    protected Matrix bias;
    protected Monitor monitor;
    protected int m_batch;
    protected boolean learning;
    protected boolean learnable = false;
    protected Vector inputPatternListeners = null;
    protected Vector outputPatternListeners = null;
    private transient Thread myThread = null;
    private volatile transient Object myThreadMonitor = new Object();
    protected transient double[] outs;
    protected transient double[] inps;
    protected transient double[] gradientInps;
    protected transient double[] gradientOuts;
    protected transient int step = 0;
    protected volatile transient boolean running = false;
    protected transient Learner myLearner = null;
    private static final ILogger log = LoggerFactory.getLogger(Layer.class);

    public Layer() {
    }

    public Layer(String string) {
        this.LayerName = string;
    }

    public void addNoise(double d) {
        this.bias.addNoise(d);
        if (this.inputPatternListeners == null) {
            return;
        }
        int n = this.inputPatternListeners.size();
        for (int i = 0; i < n; ++i) {
            InputPatternListener inputPatternListener = (InputPatternListener)this.inputPatternListeners.elementAt(i);
            if (inputPatternListener == null || !(inputPatternListener instanceof Synapse)) continue;
            ((Synapse)inputPatternListener).addNoise(d);
        }
    }

    public void randomize(double d) {
        this.randomizeBias(d);
        this.randomizeWeights(d);
    }

    public void randomizeWeights(double d) {
        if (this.inputPatternListeners == null) {
            return;
        }
        int n = this.inputPatternListeners.size();
        for (int i = 0; i < n; ++i) {
            InputPatternListener inputPatternListener = (InputPatternListener)this.inputPatternListeners.elementAt(i);
            if (inputPatternListener == null || !(inputPatternListener instanceof Synapse)) continue;
            ((Synapse)inputPatternListener).randomize(d);
        }
    }

    public void randomizeBias(double d) {
        this.bias.randomizeConditionally(d);
    }

    protected abstract void backward(double[] var1) throws JooneRuntimeException;

    public NeuralLayer copyInto(NeuralLayer neuralLayer) {
        neuralLayer.setMonitor(this.getMonitor());
        neuralLayer.setRows(this.getRows());
        neuralLayer.setBias(this.getBias());
        neuralLayer.setLayerName(this.getLayerName());
        neuralLayer.setAllInputs((Vector)this.getAllInputs().clone());
        neuralLayer.setAllOutputs((Vector)this.getAllOutputs().clone());
        this.removeAllInputs();
        this.removeAllOutputs();
        return neuralLayer;
    }

    protected void fireFwdGet() {
        int n = this.inputPatternListeners.size();
        this.step = 0;
        for (int i = 0; i < n && this.running; ++i) {
            Pattern pattern;
            InputPatternListener inputPatternListener = (InputPatternListener)this.inputPatternListeners.elementAt(i);
            if (inputPatternListener == null || (pattern = inputPatternListener.fwdGet()) == null) continue;
            double[] dArray = pattern.getArray();
            if (dArray.length != this.inps.length) {
                this.adjustSizeToFwdPattern(dArray);
            }
            this.sumInput(dArray);
            if (this.step == -1 || this.step >= pattern.getCount() && !pattern.isMarkedAsStoppingPattern()) continue;
            this.step = pattern.getCount();
        }
    }

    protected void fireFwdPut(Pattern pattern) {
        if (this.outputPatternListeners == null) {
            return;
        }
        int n = this.outputPatternListeners.size();
        boolean bl = this.getMonitor().isLearningCicle(pattern.getCount());
        for (int i = 0; i < n && this.running; ++i) {
            OutputPatternListener outputPatternListener = (OutputPatternListener)this.outputPatternListeners.elementAt(i);
            if (outputPatternListener == null) continue;
            boolean bl2 = false;
            if (outputPatternListener instanceof Synapse) {
                bl2 = ((Synapse)outputPatternListener).isLoopBack();
            }
            if (n == 1 && bl && !bl2) {
                outputPatternListener.fwdPut(pattern);
                continue;
            }
            outputPatternListener.fwdPut((Pattern)pattern.clone());
        }
    }

    protected void fireRevGet() {
        if (this.outputPatternListeners == null) {
            return;
        }
        int n = this.outputPatternListeners.size();
        for (int i = 0; i < n && this.running; ++i) {
            Pattern pattern;
            OutputPatternListener outputPatternListener = (OutputPatternListener)this.outputPatternListeners.elementAt(i);
            if (outputPatternListener == null || (pattern = outputPatternListener.revGet()) == null) continue;
            double[] dArray = pattern.getArray();
            if (dArray.length != this.gradientInps.length) {
                this.adjustSizeToRevPattern(dArray);
            }
            this.sumBackInput(dArray);
        }
    }

    protected void fireRevPut(Pattern pattern) {
        if (this.inputPatternListeners == null) {
            return;
        }
        int n = this.inputPatternListeners.size();
        InputPatternListener inputPatternListener = null;
        for (int i = 0; i < n && this.running; ++i) {
            inputPatternListener = (InputPatternListener)this.inputPatternListeners.elementAt(i);
            if (inputPatternListener == null) continue;
            boolean bl = false;
            if (inputPatternListener instanceof Synapse) {
                bl = ((Synapse)inputPatternListener).isLoopBack();
            }
            if (n == 1 && !bl) {
                inputPatternListener.revPut(pattern);
                continue;
            }
            inputPatternListener.revPut((Pattern)pattern.clone());
        }
    }

    protected void adjustSizeToFwdPattern(double[] dArray) {
        int n = this.getRows();
        this.setRows(dArray.length);
        log.warn("Pattern size mismatches #neurons. #neurons in layer '" + this.getLayerName() + "' adjusted [fwd pass, " + n + " -> " + this.getRows() + "].");
    }

    protected void adjustSizeToRevPattern(double[] dArray) {
        int n = this.getRows();
        this.setRows(dArray.length);
        log.warn("Pattern size mismatches #neurons. #neurons in layer '" + this.getLayerName() + "' adjusted [rev pass, " + n + " -> " + this.getRows() + "].");
    }

    protected abstract void forward(double[] var1) throws JooneRuntimeException;

    public Vector getAllInputs() {
        return this.inputPatternListeners;
    }

    public Vector getAllOutputs() {
        return this.outputPatternListeners;
    }

    public Matrix getBias() {
        return this.bias;
    }

    public int getDimension() {
        return this.getRows();
    }

    public String getLayerName() {
        return this.LayerName;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public int getRows() {
        return this.rows;
    }

    public void removeAllInputs() {
        if (this.inputPatternListeners != null) {
            Vector vector = (Vector)this.inputPatternListeners.clone();
            for (int i = 0; i < vector.size(); ++i) {
                this.removeInputSynapse((InputPatternListener)vector.elementAt(i));
            }
            this.inputPatternListeners = null;
        }
    }

    public void removeAllOutputs() {
        if (this.outputPatternListeners != null) {
            Vector vector = (Vector)this.outputPatternListeners.clone();
            for (int i = 0; i < vector.size(); ++i) {
                this.removeOutputSynapse((OutputPatternListener)vector.elementAt(i));
            }
            this.outputPatternListeners = null;
        }
    }

    public void removeInputSynapse(InputPatternListener inputPatternListener) {
        if (this.inputPatternListeners != null) {
            this.inputPatternListeners.removeElement(inputPatternListener);
            inputPatternListener.setInputFull(false);
            if (inputPatternListener instanceof NeuralNetListener) {
                this.removeListener((NeuralNetListener)((Object)inputPatternListener));
            }
            if (this.inputPatternListeners.size() == 0) {
                this.inputPatternListeners = null;
            }
        }
    }

    public void removeOutputSynapse(OutputPatternListener outputPatternListener) {
        if (this.outputPatternListeners != null) {
            this.outputPatternListeners.removeElement(outputPatternListener);
            outputPatternListener.setOutputFull(false);
            if (outputPatternListener instanceof NeuralNetListener) {
                this.removeListener((NeuralNetListener)((Object)outputPatternListener));
            }
            if (this.outputPatternListeners.size() == 0) {
                this.outputPatternListeners = null;
            }
        }
    }

    protected void removeListener(NeuralNetListener neuralNetListener) {
        if (this.getMonitor() != null) {
            this.getMonitor().removeNeuralNetListener(neuralNetListener);
        }
    }

    public double[] getLastOutputs() {
        return (double[])this.outs.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws JooneRuntimeException {
        Pattern pattern = new Pattern();
        while (this.running) {
            String string;
            this.inps = new double[this.getRows()];
            try {
                this.fireFwdGet();
                if (this.running) {
                    this.forward(this.inps);
                    pattern.setArray(this.outs);
                    pattern.setCount(this.step);
                    this.fireFwdPut(pattern);
                }
                if (this.step != -1) {
                    this.learning = this.monitor != null ? this.monitor.isLearningCicle(this.step) : false;
                } else {
                    this.running = false;
                }
            }
            catch (JooneRuntimeException jooneRuntimeException) {
                string = "JooneException thrown in run() method." + jooneRuntimeException.getMessage();
                log.error(string);
                this.running = false;
                new NetErrorManager(this.getMonitor(), string);
            }
            if (!this.learning || !this.running) continue;
            this.gradientInps = new double[this.getDimension()];
            try {
                this.fireRevGet();
                this.backward(this.gradientInps);
                pattern.setArray(this.gradientOuts);
                pattern.setOutArray(this.outs);
                pattern.setCount(this.step);
                this.fireRevPut(pattern);
            }
            catch (JooneRuntimeException jooneRuntimeException) {
                string = "In run() JooneException thrown." + jooneRuntimeException.getMessage();
                log.error(string);
                this.running = false;
                new NetErrorManager(this.getMonitor(), string);
            }
        }
        this.resetInputListeners();
        Object object = this.getThreadMonitor();
        synchronized (object) {
            this.myThread = null;
        }
    }

    public synchronized void setAllInputs(Vector vector) {
        this.inputPatternListeners = vector;
        if (this.inputPatternListeners != null) {
            for (int i = 0; i < this.inputPatternListeners.size(); ++i) {
                this.setInputDimension((InputPatternListener)this.inputPatternListeners.elementAt(i));
            }
        }
        this.notifyAll();
    }

    public void setInputSynapses(ArrayList arrayList) {
        this.setAllInputs(new Vector(arrayList));
    }

    public void setAllOutputs(Vector vector) {
        this.outputPatternListeners = vector;
        if (this.outputPatternListeners != null) {
            for (int i = 0; i < this.outputPatternListeners.size(); ++i) {
                this.setOutputDimension((OutputPatternListener)this.outputPatternListeners.elementAt(i));
            }
        }
    }

    public void setOutputSynapses(ArrayList arrayList) {
        this.setAllOutputs(new Vector(arrayList));
    }

    public void setBias(Matrix matrix) {
        this.bias = matrix;
    }

    protected abstract void setDimensions();

    protected void setInputDimension(InputPatternListener inputPatternListener) {
        if (inputPatternListener.getOutputDimension() != this.getRows()) {
            inputPatternListener.setOutputDimension(this.getRows());
        }
    }

    public synchronized boolean addInputSynapse(InputPatternListener inputPatternListener) {
        if (this.inputPatternListeners == null) {
            this.inputPatternListeners = new Vector();
        }
        boolean bl = false;
        if (!this.inputPatternListeners.contains(inputPatternListener) && !inputPatternListener.isInputFull()) {
            this.inputPatternListeners.addElement(inputPatternListener);
            if (inputPatternListener.getMonitor() == null) {
                inputPatternListener.setMonitor(this.getMonitor());
            }
            inputPatternListener.setInputFull(true);
            this.setInputDimension(inputPatternListener);
            bl = true;
        }
        this.notifyAll();
        return bl;
    }

    public void setLayerName(String string) {
        this.LayerName = string;
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
        this.setVectMonitor(this.inputPatternListeners, monitor);
        this.setVectMonitor(this.outputPatternListeners, monitor);
    }

    private void setVectMonitor(Vector vector, Monitor monitor) {
        if (vector == null) {
            log.warn("Null vector provided in setVectMonitor at " + this.getLayerName());
            return;
        }
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Object e = vector.elementAt(i);
            if (e == null) continue;
            ((NeuralElement)e).setMonitor(monitor);
        }
    }

    protected void setOutputDimension(OutputPatternListener outputPatternListener) {
        if (outputPatternListener.getInputDimension() != this.getRows()) {
            outputPatternListener.setInputDimension(this.getRows());
        }
    }

    public boolean addOutputSynapse(OutputPatternListener outputPatternListener) {
        if (this.outputPatternListeners == null) {
            this.outputPatternListeners = new Vector();
        }
        boolean bl = false;
        if (!this.outputPatternListeners.contains(outputPatternListener) && !outputPatternListener.isOutputFull()) {
            this.outputPatternListeners.addElement(outputPatternListener);
            outputPatternListener.setMonitor(this.getMonitor());
            outputPatternListener.setOutputFull(true);
            this.setOutputDimension(outputPatternListener);
            bl = true;
        }
        return bl;
    }

    public void setRows(int n) {
        if (this.rows != n) {
            this.rows = n;
            this.setDimensions();
            this.setConnDimensions();
            this.bias = new Matrix(this.getRows(), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        Object object = this.getThreadMonitor();
        synchronized (object) {
            if (this.myThread != null) {
                if (this.myThread.isAlive()) {
                    String string = "Ignoring start request in layer '" + this.getLayerName() + "': it appears to be running";
                    log.warn(string);
                    return;
                }
                this.myThread = null;
            }
            if (this.myThread != null) return;
            if (this.inputPatternListeners == null) {
                String string = "Can't start: '" + this.getLayerName() + "' has not input synapses connected";
                log.error(string);
                throw new JooneRuntimeException(string);
            }
            if (!this.checkInputEnabled()) {
                String string = "Can't start: '" + this.getLayerName() + "' has not input synapses connected and/or enabled";
                log.error(string);
                throw new JooneRuntimeException(string);
            }
            this.running = true;
            this.myThread = this.getLayerName() != null ? new Thread((Runnable)this, this.getLayerName()) : new Thread(this);
            this.init();
            this.myThread.start();
            return;
        }
    }

    public void init() {
        this.initLearner();
        if (this.getBias() != null) {
            this.getBias().clearDelta();
        }
        if (this.outputPatternListeners != null) {
            Vector vector = (Vector)this.outputPatternListeners.clone();
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.elementAt(i);
                if (!(e instanceof NeuralElement)) continue;
                ((NeuralElement)e).init();
            }
        }
    }

    protected boolean checkInputEnabled() {
        for (int i = 0; i < this.inputPatternListeners.size(); ++i) {
            InputPatternListener inputPatternListener = (InputPatternListener)this.inputPatternListeners.elementAt(i);
            if (!inputPatternListener.isEnabled()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.getThreadMonitor();
        synchronized (object) {
            if (this.myThread != null) {
                this.running = false;
                this.myThread.interrupt();
            }
        }
    }

    protected void resetInputListeners() {
        int n = this.inputPatternListeners.size();
        for (int i = 0; i < n; ++i) {
            InputPatternListener inputPatternListener = (InputPatternListener)this.inputPatternListeners.elementAt(i);
            if (inputPatternListener == null) continue;
            inputPatternListener.reset();
        }
    }

    protected void sumBackInput(double[] dArray) {
        int n;
        try {
            for (n = 0; n < this.gradientInps.length; ++n) {
                int n2 = n;
                this.gradientInps[n2] = this.gradientInps[n2] + dArray[n];
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            log.warn(this.getLayerName() + " gradInps.size:" + this.gradientInps.length + " pattern.size:" + dArray.length + " x:" + n);
        }
    }

    protected void sumInput(double[] dArray) {
        for (int i = 0; i < this.inps.length; ++i) {
            int n = i;
            this.inps[n] = this.inps[n] + dArray[i];
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (objectInputStream.getClass().getName().indexOf("xstream") != -1) {
            objectInputStream.defaultReadObject();
        } else {
            this.LayerName = (String)objectInputStream.readObject();
            this.rows = objectInputStream.readInt();
            this.bias = (Matrix)objectInputStream.readObject();
            this.monitor = (Monitor)objectInputStream.readObject();
            this.m_batch = objectInputStream.readInt();
            this.learning = objectInputStream.readBoolean();
            this.inputPatternListeners = this.readVector(objectInputStream);
            this.outputPatternListeners = this.readVector(objectInputStream);
        }
        this.setDimensions();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (objectOutputStream.getClass().getName().indexOf("xstream") != -1) {
            objectOutputStream.defaultWriteObject();
        } else {
            objectOutputStream.writeObject(this.LayerName);
            objectOutputStream.writeInt(this.rows);
            objectOutputStream.writeObject(this.bias);
            objectOutputStream.writeObject(this.monitor);
            objectOutputStream.writeInt(this.m_batch);
            objectOutputStream.writeBoolean(this.learning);
            this.writeVector(objectOutputStream, this.inputPatternListeners);
            this.writeVector(objectOutputStream, this.outputPatternListeners);
        }
    }

    private void writeVector(ObjectOutputStream objectOutputStream, Vector vector) throws IOException {
        if (vector != null) {
            boolean bl = false;
            if (this.monitor != null && this.monitor.isExporting()) {
                bl = true;
            }
            for (int i = 0; i < vector.size(); ++i) {
                Object e = vector.elementAt(i);
                if (e instanceof NotSerialize && bl) continue;
                objectOutputStream.writeObject(e);
            }
        }
        objectOutputStream.writeObject(null);
    }

    private Vector readVector(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Vector<Object> vector = new Vector<Object>();
        Object object = objectInputStream.readObject();
        while (object != null) {
            vector.addElement(object);
            object = objectInputStream.readObject();
        }
        return vector;
    }

    protected void setConnDimensions() {
        NeuralElement neuralElement;
        int n;
        int n2;
        if (this.inputPatternListeners != null) {
            n2 = this.inputPatternListeners.size();
            for (n = 0; n < n2; ++n) {
                neuralElement = (InputPatternListener)this.inputPatternListeners.elementAt(n);
                if (neuralElement == null) continue;
                this.setInputDimension((InputPatternListener)neuralElement);
            }
        }
        if (this.outputPatternListeners != null) {
            n2 = this.outputPatternListeners.size();
            for (n = 0; n < n2; ++n) {
                neuralElement = (OutputPatternListener)this.outputPatternListeners.elementAt(n);
                if (neuralElement == null) continue;
                this.setOutputDimension((OutputPatternListener)neuralElement);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.getThreadMonitor();
        synchronized (object) {
            return this.myThread != null && this.myThread.isAlive();
            {
            }
        }
    }

    public TreeSet check() {
        NeuralElement neuralElement;
        int n;
        TreeSet<NetCheck> treeSet = new TreeSet<NetCheck>();
        if (this.inputPatternListeners == null || this.inputPatternListeners.isEmpty()) {
            treeSet.add(new NetCheck(0, "Layer has no input synapses attached.", this));
        }
        if (this.inputPatternListeners != null) {
            for (n = 0; n < this.inputPatternListeners.size(); ++n) {
                StreamInputSynapse streamInputSynapse;
                int n2;
                neuralElement = (InputPatternListener)this.inputPatternListeners.elementAt(n);
                treeSet.addAll(neuralElement.check());
                if (!(neuralElement instanceof StreamInputSynapse) || (n2 = (streamInputSynapse = (StreamInputSynapse)neuralElement).numColumns()) == this.rows) continue;
                treeSet.add(new NetCheck(0, "Rows parameter does not match the number of columns for the attached input stream .", this));
            }
        }
        if (this.outputPatternListeners != null) {
            for (n = 0; n < this.outputPatternListeners.size(); ++n) {
                neuralElement = (OutputPatternListener)this.outputPatternListeners.elementAt(n);
                treeSet.addAll(neuralElement.check());
            }
        }
        return treeSet;
    }

    public String toString() {
        return this.getLayerName();
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.LayerName = null;
        this.bias = null;
        this.monitor = null;
        if (this.inputPatternListeners != null) {
            this.inputPatternListeners.clear();
            this.inputPatternListeners = null;
        }
        if (this.outputPatternListeners != null) {
            this.outputPatternListeners.clear();
            this.outputPatternListeners = null;
        }
    }

    public Collection Inspections() {
        ArrayList<BiasInspection> arrayList = new ArrayList<BiasInspection>();
        arrayList.add(new BiasInspection(this.bias));
        return arrayList;
    }

    public String InspectableTitle() {
        return this.getLayerName();
    }

    public boolean hasStepCounter() {
        Vector vector = this.getAllInputs();
        if (vector == null) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            InputSynapse inputSynapse;
            if (!(vector.elementAt(i) instanceof InputSynapse) || !(inputSynapse = (InputSynapse)vector.elementAt(i)).isStepCounter()) continue;
            return true;
        }
        return false;
    }

    public boolean isInputLayer() {
        Vector vector = this.getAllInputs();
        return this.checkInputs(vector);
    }

    protected boolean checkInputs(Vector vector) {
        if (vector == null || vector.isEmpty()) {
            return true;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.elementAt(i) instanceof StreamInputSynapse)) continue;
            return true;
        }
        return false;
    }

    public boolean isOutputLayer() {
        Vector vector = this.getAllOutputs();
        return this.checkOutputs(vector);
    }

    protected boolean checkOutputs(Vector vector) {
        boolean bl = false;
        if (vector == null || vector.isEmpty()) {
            return true;
        }
        for (int i = 0; i < vector.size(); ++i) {
            OutputPatternListener outputPatternListener;
            Object e = vector.elementAt(i);
            if (e instanceof StreamOutputSynapse || e instanceof TeachingSynapse || e instanceof TeacherSynapse) {
                bl = true;
                continue;
            }
            if (e instanceof OutputSwitchSynapse) {
                outputPatternListener = (OutputSwitchSynapse)e;
                if (this.checkOutputs(((OutputSwitchSynapse)outputPatternListener).getAllOutputs())) {
                    bl = true;
                    continue;
                }
                return false;
            }
            if (!(e instanceof Synapse)) continue;
            outputPatternListener = (Synapse)e;
            if (((Synapse)outputPatternListener).isLoopBack()) {
                bl = true;
                continue;
            }
            return false;
        }
        return bl;
    }

    public Learner getLearner() {
        if (!this.learnable) {
            return null;
        }
        return this.getMonitor().getLearner();
    }

    public void initLearner() {
        this.myLearner = this.getLearner();
        if (this.myLearner != null) {
            this.myLearner.registerLearnable(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getThreadMonitor() {
        if (this.myThreadMonitor == null) {
            Layer layer = this;
            synchronized (layer) {
                if (this.myThreadMonitor == null) {
                    this.myThreadMonitor = new Object();
                }
            }
        }
        return this.myThreadMonitor;
    }

    public void join() {
        try {
            if (this.myThread != null) {
                this.myThread.join();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void fwdRun(Pattern pattern) {
        this.running = true;
        if (pattern == null) {
            this.inps = new double[this.getRows()];
            this.fireFwdGet();
        } else {
            this.inps = pattern.getArray();
        }
        if (this.running) {
            Pattern pattern2 = new Pattern();
            if (pattern != null && pattern.isMarkedAsStoppingPattern()) {
                pattern2.setArray(this.outs);
                pattern2.markAsStoppingPattern();
            } else {
                this.forward(this.inps);
                pattern2.setArray(this.outs);
                pattern2.setCount(this.step);
            }
            this.fireFwdPut(pattern2);
        }
        this.running = false;
    }

    public void revRun(Pattern pattern) {
        this.running = true;
        if (pattern == null) {
            this.gradientInps = new double[this.getDimension()];
            this.fireRevGet();
        } else {
            this.gradientInps = pattern.getArray();
        }
        if (this.running) {
            Pattern pattern2 = new Pattern();
            this.backward(this.gradientInps);
            pattern2.setArray(this.gradientOuts);
            pattern2.setOutArray(this.outs);
            pattern2.setCount(this.step);
            this.fireRevPut(pattern2);
        }
        this.running = false;
    }
}

