/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.TreeSet;
import org.joone.engine.FullSynapse;
import org.joone.engine.Learner;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;

public class KohonenSynapse
extends FullSynapse
implements NeuralNetListener {
    private static final long serialVersionUID = -4966435217407942471L;
    double currentLearningRate = 1.0;
    private double timeConstant = 200.0;
    private int orderingPhase = 1000;

    public KohonenSynapse() {
        this.learnable = false;
    }

    protected void backward(double[] dArray) {
        double d = 0.0;
        int n = this.getOutputDimension();
        double[] dArray2 = this.b_pattern.getOutArray();
        for (int i = 0; i < n; ++i) {
            d = dArray2[i];
            this.adjustNodeWeight(i, this.currentLearningRate, d, this.inps);
        }
    }

    protected void forward(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        int n = this.getOutputDimension();
        for (int i = 0; i < n; ++i) {
            d2 = 0.0;
            for (int j = 0; j < dArray.length; ++j) {
                d = this.array.value[j][i] - dArray[j];
                d *= d;
                d2 += d;
            }
            this.outs[i] = d2;
        }
    }

    private void adjustNodeWeight(int n, double d, double d2, double[] dArray) {
        int n2 = n;
        for (int i = 0; i < this.getInputDimension(); ++i) {
            double d3 = this.array.value[i][n2];
            double d4 = dArray[i];
            d3 += d2 * d * (d4 - d3);
            this.array.value[i][n2] = d3;
        }
    }

    public void setMonitor(Monitor monitor) {
        super.setMonitor(monitor);
        if (this.getMonitor() != null) {
            this.getMonitor().addNeuralNetListener(this, false);
        }
    }

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
        int n = this.getMonitor().getTotCicles() - this.getMonitor().getCurrentCicle();
        this.currentLearningRate = n < this.getOrderingPhase() ? this.getMonitor().getLearningRate() * Math.exp(-((double)n / this.getTimeConstant())) : 0.01;
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
        this.currentLearningRate = this.getMonitor().getLearningRate();
    }

    public void netStopped(NeuralNetEvent neuralNetEvent) {
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
    }

    public TreeSet check() {
        TreeSet treeSet = super.check();
        return treeSet;
    }

    public int getOrderingPhase() {
        return this.orderingPhase;
    }

    public void setOrderingPhase(int n) {
        this.orderingPhase = n;
    }

    public double getTimeConstant() {
        return this.timeConstant;
    }

    public void setTimeConstant(double d) {
        this.timeConstant = d;
    }

    public Learner getLearner() {
        this.learnable = false;
        return super.getLearner();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.getMonitor() != null) {
            this.getMonitor().addNeuralNetListener(this, false);
        }
    }
}

