/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import org.joone.engine.MemoryLayer;
import org.joone.inspection.implementations.BiasInspection;
import org.joone.net.NetCheck;

public class DelayLayer
extends MemoryLayer {
    private static final long serialVersionUID = 1547734529107850525L;

    public DelayLayer() {
    }

    public DelayLayer(String string) {
        super(string);
    }

    protected void backward(double[] dArray) {
        int n = this.getRows();
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            for (int j = 0; j < this.getTaps(); ++j) {
                this.backmemory[n2] = this.backmemory[n2 + n];
                int n3 = n2;
                this.backmemory[n3] = this.backmemory[n3] + dArray[n2];
                n2 += n;
            }
            this.backmemory[n2] = dArray[n2];
            this.gradientOuts[i] = this.backmemory[i];
        }
    }

    protected void forward(double[] dArray) {
        int n = this.getRows();
        for (int i = 0; i < n; ++i) {
            int n2 = i + this.getTaps() * n;
            for (int j = this.getTaps(); j > 0; --j) {
                this.memory[n2] = this.memory[n2 - n];
                this.outs[n2] = this.memory[n2];
                n2 -= n;
            }
            this.memory[i] = dArray[i];
            this.outs[i] = this.memory[i];
        }
    }

    public TreeSet check() {
        TreeSet treeSet = super.check();
        if (this.getTaps() == 0) {
            treeSet.add(new NetCheck(0, "The Taps parameter cannot be equal to zero.", this));
        }
        if (this.monitor != null && this.monitor.getPreLearning() != this.getTaps() + 1) {
            treeSet.add(new NetCheck(1, "The correct value for the Monitor PreLearning parameter is Taps + 1", this));
        }
        return treeSet;
    }

    public Collection Inspections() {
        ArrayList<BiasInspection> arrayList = new ArrayList<BiasInspection>();
        arrayList.add(new BiasInspection(null));
        return arrayList;
    }
}

