/*
 * Decompiled with CFR 0.152.
 */
package org.joone.engine;

import java.util.ArrayList;
import java.util.Collection;
import org.joone.engine.SimpleLayer;
import org.joone.inspection.implementations.BiasInspection;

public class ContextLayer
extends SimpleLayer {
    private double beta = 1.0;
    private double timeConstant = 0.5;
    private static final long serialVersionUID = -8773800970295287404L;

    public ContextLayer() {
    }

    public ContextLayer(String string) {
        super(string);
    }

    public void backward(double[] dArray) {
        int n = this.getRows();
        for (int i = 0; i < n; ++i) {
            this.gradientOuts[i] = dArray[i] * this.beta;
        }
    }

    public void forward(double[] dArray) {
        int n = this.getRows();
        for (int i = 0; i < n; ++i) {
            this.outs[i] = this.beta * (dArray[i] + this.timeConstant * this.outs[i]);
        }
    }

    public double getBeta() {
        return this.beta;
    }

    public void setBeta(double d) {
        this.beta = d;
    }

    public double getTimeConstant() {
        return this.timeConstant;
    }

    public void setTimeConstant(double d) {
        this.timeConstant = d;
    }

    public Collection Inspections() {
        ArrayList<BiasInspection> arrayList = new ArrayList<BiasInspection>();
        arrayList.add(new BiasInspection(null));
        return arrayList;
    }
}

