/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit.jedit;

import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;
import org.joone.edit.jedit.tokenmarker.TokenMarker;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class SyntaxDocument
extends PlainDocument {
    private static final ILogger log = LoggerFactory.getLogger(SyntaxDocument.class);
    protected TokenMarker tokenMarker;

    public TokenMarker getTokenMarker() {
        return this.tokenMarker;
    }

    public void setTokenMarker(TokenMarker tokenMarker) {
        this.tokenMarker = tokenMarker;
        if (tokenMarker == null) {
            return;
        }
        this.tokenMarker.insertLines(0, this.getDefaultRootElement().getElementCount());
        this.tokenizeLines();
    }

    public void tokenizeLines() {
        this.tokenizeLines(0, this.getDefaultRootElement().getElementCount());
    }

    public void tokenizeLines(int n, int n2) {
        if (this.tokenMarker == null || !this.tokenMarker.supportsMultilineTokens()) {
            return;
        }
        Segment segment = new Segment();
        Element element = this.getDefaultRootElement();
        n2 += n;
        try {
            for (int i = n; i < n2; ++i) {
                Element element2 = element.getElement(i);
                int n3 = element2.getStartOffset();
                this.getText(n3, element2.getEndOffset() - n3 - 1, segment);
                this.tokenMarker.markTokens(segment, i);
            }
        }
        catch (BadLocationException badLocationException) {
            log.warn("BadLocationException was thrown. Message is : " + badLocationException.getMessage(), badLocationException);
        }
    }

    public void beginCompoundEdit() {
    }

    public void endCompoundEdit() {
    }

    public void addUndoableEdit(UndoableEdit undoableEdit) {
    }

    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        DocumentEvent.ElementChange elementChange;
        if (this.tokenMarker != null && (elementChange = documentEvent.getChange(this.getDefaultRootElement())) != null) {
            this.tokenMarker.insertLines(elementChange.getIndex() + 1, elementChange.getChildrenAdded().length - elementChange.getChildrenRemoved().length);
        }
        super.fireInsertUpdate(documentEvent);
    }

    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        DocumentEvent.ElementChange elementChange;
        if (this.tokenMarker != null && (elementChange = documentEvent.getChange(this.getDefaultRootElement())) != null) {
            this.tokenMarker.deleteLines(elementChange.getIndex() + 1, elementChange.getChildrenRemoved().length - elementChange.getChildrenAdded().length);
        }
        super.fireRemoveUpdate(documentEvent);
    }
}

