/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit.inspection;

import CH.ifa.draw.framework.HJDError;
import CH.ifa.draw.util.Iconkit;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.joone.inspection.Inspectable;
import org.joone.inspection.Inspection;

public class InspectionFrame
extends JFrame {
    Collection inspections = new ArrayList();
    JTabbedPane center;
    JTable[] tables;

    public InspectionFrame(Inspectable inspectable) {
        Collection collection;
        Iconkit iconkit = Iconkit.instance();
        Collection collection2 = collection = inspectable == null ? null : inspectable.Inspections();
        if (iconkit == null) {
            throw new HJDError("Iconkit instance isn't set");
        }
        Image image = iconkit.loadImageResource("/org/joone/images/JooneIcon.gif");
        this.setIconImage(image);
        if (inspectable != null) {
            this.inspections = inspectable.Inspections();
            this.setTitle("Inspection - " + inspectable.InspectableTitle());
        } else {
            this.setTitle("Inspection");
        }
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JButton jButton = new JButton("Close");
        jButton.setToolTipText("Close the inspection frame");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InspectionFrame.this.dispose();
            }
        });
        JButton jButton2 = new JButton("Copy");
        jButton2.setToolTipText("Copy data as tab delimeted");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                String string = "";
                if (collection != null) {
                    for (Object e : collection) {
                        if (!(e instanceof Inspection)) continue;
                        Inspection inspection = (Inspection)e;
                        Component component = InspectionFrame.this.makeTable(inspection);
                        try {
                            if (!component.getClass().isInstance(new JTable())) continue;
                            JTable jTable = (JTable)component;
                            int n = inspection.rowNumbers() ? 1 : 0;
                            for (int i = 0; i < jTable.getRowCount(); ++i) {
                                for (int j = n; j < jTable.getColumnCount(); ++j) {
                                    if (j > n) {
                                        string = string + "\t";
                                    }
                                    string = string + jTable.getModel().getValueAt(i, j).toString();
                                }
                                string = string + "\n";
                            }
                            StringSelection stringSelection = new StringSelection(string);
                            clipboard.setContents(stringSelection, null);
                        }
                        catch (Throwable throwable) {}
                    }
                }
            }
        });
        JButton jButton3 = new JButton("Paste");
        jButton3.setToolTipText("Paste data from tab delimeted source");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable transferable = clipboard.getContents(null);
                if (transferable != null) {
                    try {
                        Object object;
                        String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        StringReader stringReader = new StringReader(string);
                        LineNumberReader lineNumberReader = new LineNumberReader(stringReader);
                        int n = InspectionFrame.this.center.getSelectedIndex();
                        Object[] objectArray = InspectionFrame.this.inspections.toArray();
                        Inspection inspection = (Inspection)objectArray[n];
                        Object[][] objectArray2 = inspection.getComponent();
                        if (objectArray2 == null) {
                            return;
                        }
                        String string2 = null;
                        for (int i = 0; (string2 = lineNumberReader.readLine()) != null && i < objectArray2.length; ++i) {
                            object = new StringTokenizer(string2, " ;,\t\n\r\f");
                            int n2 = 0;
                            if (inspection.rowNumbers()) {
                                n2 = 1;
                            }
                            while (((StringTokenizer)object).hasMoreTokens() && n2 < objectArray2[0].length) {
                                String string3 = ((StringTokenizer)object).nextToken();
                                try {
                                    Double d = new Double(string3);
                                    objectArray2[i][n2] = d;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                ++n2;
                            }
                        }
                        inspection.setComponent(objectArray2);
                        InspectionFrame.this.center.removeTabAt(n);
                        object = InspectionFrame.this.createPanel(InspectionFrame.this.makeTable(inspection));
                        InspectionFrame.this.center.insertTab(inspection.getTitle(), null, (Component)object, null, n);
                        InspectionFrame.this.center.setSelectedIndex(n);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(6, 1));
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(jButton3);
        container.add((Component)jPanel, "East");
        this.center = new JTabbedPane();
        if (inspectable == null) {
            this.addTab(this.center, "error", new JLabel("Inspectable object is null."));
        } else {
            Collection collection3 = inspectable.Inspections();
            if (collection3 == null) {
                this.addTab(this.center, "Error", new JLabel("Inspectable object Collection is null."));
            } else {
                for (Object e : collection3) {
                    if (e instanceof Inspection) {
                        Inspection inspection = (Inspection)e;
                        String string = inspection.getTitle();
                        this.addTab(this.center, string, this.makeTable(inspection));
                        continue;
                    }
                    this.addTab(this.center, "Error", new Label("Object is not an Inspection."));
                }
            }
        }
        container.add((Component)this.center, "Center");
    }

    private void addTab(JTabbedPane jTabbedPane, String string, Component component) {
        jTabbedPane.addTab(string, this.createPanel(component));
    }

    private Component createPanel(Component component) {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(component);
        JScrollPane jScrollPane = new JScrollPane(jPanel, 20, 30);
        return jScrollPane;
    }

    public void show() {
        this.pack();
        if (this.getWidth() < 250) {
            this.setSize(250, this.getHeight());
        }
        if (this.getWidth() > 500) {
            this.setSize(500, this.getHeight());
        }
        if (this.getHeight() > 200) {
            this.setSize(this.getWidth(), 200);
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getWidth()) / 2, (dimension.height - this.getHeight()) / 2);
        super.show();
    }

    private Component makeTable(Inspection inspection) {
        Object[][] objectArray = inspection.getComponent();
        Object[] objectArray2 = inspection.getNames();
        boolean bl = inspection.rowNumbers();
        if (objectArray != null && objectArray2 != null) {
            JTable jTable = new JTable(objectArray, objectArray2);
            if (bl) {
                TableColumn tableColumn = jTable.getColumnModel().getColumn(0);
                DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
                defaultTableCellRenderer.setToolTipText("Row Number");
                defaultTableCellRenderer.setBackground(new Color(178, 178, 255));
                tableColumn.setCellRenderer(defaultTableCellRenderer);
            }
            jTable.setAutoResizeMode(2);
            jTable.doLayout();
            jTable.setEnabled(false);
            return jTable;
        }
        return new JLabel("There are no values set for this item.");
    }
}

