/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import CH.ifa.draw.framework.ConnectionFigure;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.standard.ConnectionTool;
import java.util.Hashtable;
import org.joone.edit.LayerConnection;
import org.joone.edit.NeuralNetDrawing;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class SynapseCreationTool
extends ConnectionTool {
    public static final ILogger log = LoggerFactory.getLogger(SynapseCreationTool.class);
    protected Hashtable params = new Hashtable();
    String objType;
    DrawingView view;

    public SynapseCreationTool(DrawingView drawingView, String string) {
        super(drawingView, null);
        this.objType = string;
        this.view = drawingView;
    }

    protected ConnectionFigure createConnection() {
        try {
            Class<?> clazz = Class.forName(this.objType);
            LayerConnection layerConnection = (LayerConnection)clazz.newInstance();
            layerConnection.setParams(this.params);
            NeuralNetDrawing neuralNetDrawing = (NeuralNetDrawing)this.view.drawing();
            layerConnection.setParam("NeuralNet", neuralNetDrawing.getNeuralNet());
            return layerConnection;
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.warn("ClassNotFoundException exception thrown while ConnectionFigure. Message is : " + classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            log.warn("InstantiationException exception thrown while ConnectionFigure. Message is : " + instantiationException.getMessage(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.warn("IllegalAccessException exception thrown while ConnectionFigure. Message is : " + illegalAccessException.getMessage(), illegalAccessException);
        }
        return null;
    }

    public Object getParam(Object object) {
        return this.params.get(object);
    }

    public void setParam(Object object, Object object2) {
        this.params.put(object, object2);
    }

    public void setParams(Hashtable hashtable) {
        this.params = hashtable;
    }
}

