/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.filechooser.FileFilter;
import org.joone.edit.NetStorageFormat;
import org.joone.net.NeuralNet;

public class StandardNetStorageFormat
implements NetStorageFormat {
    private FileFilter myFileFilter;
    private String myFileExtension;
    private String myFileDescription;

    public StandardNetStorageFormat() {
        this.setFileExtension(this.createFileExtension());
        this.setFileDescription(this.createFileDescription());
        this.setFileFilter(this.createFileFilter());
    }

    protected String createFileExtension() {
        this.myFileExtension = "snet";
        return "snet";
    }

    public void setFileExtension(String string) {
        this.myFileExtension = string;
    }

    public String getFileExtension() {
        return this.myFileExtension;
    }

    public String createFileDescription() {
        return "Serialized NeuralNet (" + this.getFileExtension() + ")";
    }

    public void setFileDescription(String string) {
        this.myFileDescription = string;
    }

    public String getFileDescription() {
        return this.myFileDescription;
    }

    protected FileFilter createFileFilter() {
        return new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                return file.getName().endsWith("." + StandardNetStorageFormat.this.myFileExtension);
            }

            public String getDescription() {
                return StandardNetStorageFormat.this.getFileDescription();
            }
        };
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.myFileFilter = fileFilter;
    }

    public FileFilter getFileFilter() {
        return this.myFileFilter;
    }

    public String store(String string, NeuralNet neuralNet) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(this.adjustFileName(string));
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(neuralNet);
        objectOutputStream.close();
        return this.adjustFileName(string);
    }

    public NeuralNet restore(String string) throws IOException {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            return (NeuralNet)objectInputStream.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Could not restore NeuralNet '" + string + "': class not found!");
        }
    }

    public boolean equals(Object object) {
        if (object instanceof StandardNetStorageFormat) {
            return this.getFileExtension().equals(((StandardNetStorageFormat)object).getFileExtension());
        }
        return false;
    }

    public int hashCode() {
        return this.getFileExtension().hashCode();
    }

    protected String adjustFileName(String string) {
        if (!this.hasCorrectFileExtension(string)) {
            return string + "." + this.getFileExtension();
        }
        return string;
    }

    protected boolean hasCorrectFileExtension(String string) {
        return string.endsWith("." + this.getFileExtension());
    }
}

