/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertySheetPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.joone.edit.Wrapper;

public class PropertyPanel
extends JPanel {
    final PropertySheetPanel sheet;
    Wrapper source;

    public PropertyPanel() {
        this.setLayout(new BorderLayout());
        this.sheet = new PropertySheetPanel();
        this.sheet.setMode(0);
        this.sheet.setToolBarVisible(false);
        this.sheet.setDescriptionVisible(false);
        this.sheet.setPreferredSize(new Dimension(60, 170));
        JScrollPane jScrollPane = new JScrollPane((Component)this.sheet);
        this.add((Component)jScrollPane, "Center");
    }

    public void setTarget(Wrapper wrapper) {
        this.source = wrapper;
        Object object = wrapper.getBean();
        PropertyChangeListener propertyChangeListener = (PropertyChangeListener)this.sheet.getClientProperty((Object)"listener");
        if (propertyChangeListener != null) {
            this.sheet.removePropertySheetChangeListener(propertyChangeListener);
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
            this.sheet.setMode(0);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            this.sheet.setProperties(this.getFilteredProperties(propertyDescriptorArray));
            Property[] propertyArray = this.sheet.getProperties();
            int n = propertyArray.length;
            for (int i = 0; i < n; ++i) {
                try {
                    propertyArray[i].readFromObject(object);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.setListener(object, this.sheet);
        }
        catch (IntrospectionException introspectionException) {
            introspectionException.printStackTrace();
        }
    }

    public void update() {
        this.source.updateFigure();
    }

    private PropertyDescriptor[] getFilteredProperties(PropertyDescriptor[] propertyDescriptorArray) {
        ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[i];
            Method method = propertyDescriptor.getReadMethod();
            Method method2 = propertyDescriptor.getWriteMethod();
            if (propertyDescriptor.isHidden() || propertyDescriptor.isExpert() || method2 == null || method == null) continue;
            arrayList.add(propertyDescriptor);
        }
        return arrayList.toArray(new PropertyDescriptor[arrayList.size()]);
    }

    private void setListener(final Object object, PropertySheetPanel propertySheetPanel) {
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Property property = (Property)propertyChangeEvent.getSource();
                property.writeToObject(object);
                if (object instanceof JComponent) {
                    ((JComponent)object).repaint();
                }
                PropertyPanel.this.source.updateFigure();
            }
        };
        propertySheetPanel.addPropertySheetChangeListener(propertyChangeListener);
        propertySheetPanel.putClientProperty((Object)"listener", (Object)propertyChangeListener);
        propertySheetPanel.repaint();
    }
}

