/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import CH.ifa.draw.framework.HJDError;
import CH.ifa.draw.util.Iconkit;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.joone.edit.JooneFileChooser;
import org.joone.edit.jedit.JEditTextArea;
import org.joone.edit.jedit.tokenmarker.JavaTokenMarker;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;
import org.joone.net.NeuralNet;
import org.joone.script.MacroInterface;
import org.joone.util.GroovyMacroPlugin;
import org.joone.util.MacroPlugin;
import org.joone.util.MonitorPlugin;

public class JMacroEditor
extends JFrame {
    private static final ILogger log = LoggerFactory.getLogger(JMacroEditor.class);
    private JEditTextArea ta;
    private NeuralNet neuralNet;
    private char[] m_buf;
    private String m_dir;
    private String[] FileExtension = new String[]{"bsh", "groovy"};
    private String FileDescription = "BeanShell scripts (.bsh) | Groovy scripts (.groovy)";
    private String fileName = null;
    private String actualMacro = null;
    private DefaultListModel list;
    private JMenuItem addMenuItem;
    private JRadioButtonMenuItem beanShellMenuItem;
    private ButtonGroup buttonGroup1;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JMenu editMenu;
    private JCheckBoxMenuItem enableMacroMenuItem;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JRadioButtonMenuItem groovyMenuItem;
    private JMenuItem importMenuItem;
    private JList jList1;
    private JMenu jMenuLanguage;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSplitPane jSplitPane1;
    private JMenu macroMenu;
    private JMenuBar menuBar;
    private JMenuItem pasteMenuItem;
    private JMenuItem removeMenuItem;
    private JMenuItem renameMenuItem;
    private JMenuItem runMenuItem;
    private JMenuItem saveAsMenuItem;
    private JMenuItem selectAllMenuItem;
    private JMenuItem setRateMenuItem;

    public JMacroEditor(NeuralNet neuralNet) {
        this.initComponents();
        this.setNeuralNet(neuralNet);
        this.ta = new JEditTextArea();
        this.ta.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                JMacroEditor.this.taFocusLost(focusEvent);
            }
        });
        this.ta.setTokenMarker(new JavaTokenMarker());
        this.jSplitPane1.setRightComponent(this.ta);
        Iconkit iconkit = Iconkit.instance();
        if (iconkit == null) {
            throw new HJDError("Iconkit instance isn't set");
        }
        Image image = iconkit.loadImageResource("/org/joone/images/JooneIcon.gif");
        this.setIconImage(image);
        this.fillList();
        this.enableMacroMenuItem.setSelected(this.getNeuralNet().isScriptingEnabled());
        if (this.getNeuralNet().getMacroPlugin() instanceof MacroPlugin) {
            this.beanShellMenuItem.setSelected(true);
        } else {
            this.groovyMenuItem.setSelected(true);
        }
        this.pack();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jSplitPane1 = new JSplitPane();
        this.jList1 = new JList();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.importMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.selectAllMenuItem = new JMenuItem();
        this.macroMenu = new JMenu();
        this.enableMacroMenuItem = new JCheckBoxMenuItem();
        this.jSeparator3 = new JSeparator();
        this.addMenuItem = new JMenuItem();
        this.removeMenuItem = new JMenuItem();
        this.renameMenuItem = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.runMenuItem = new JMenuItem();
        this.setRateMenuItem = new JMenuItem();
        this.jSeparator5 = new JSeparator();
        this.jMenuLanguage = new JMenu();
        this.beanShellMenuItem = new JRadioButtonMenuItem();
        this.groovyMenuItem = new JRadioButtonMenuItem();
        this.setTitle("JavaScript Macro Editor");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JMacroEditor.this.exitForm(windowEvent);
            }
        });
        this.jList1.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JMacroEditor.this.jList1ValueChanged(listSelectionEvent);
            }
        });
        this.jSplitPane1.setLeftComponent(this.jList1);
        this.getContentPane().add((Component)this.jSplitPane1, "Center");
        this.fileMenu.setText("File");
        this.importMenuItem.setText("Import Macro...");
        this.importMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMacroEditor.this.importMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.importMenuItem);
        this.saveAsMenuItem.setText("Save Macro As ...");
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMacroEditor.this.saveAsMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        this.fileMenu.add(this.jSeparator1);
        this.exitMenuItem.setMnemonic('x');
        this.exitMenuItem.setText("Close");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMacroEditor.this.exitMenuItemActionPerformed(actionEvent);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.cutMenuItem.setText("Cut");
        this.cutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMacroEditor.this.cutMenuItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMacroEditor.this.copyMenuItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setText("Paste");
        this.pasteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMacroEditor.this.pasteMenuItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.pasteMenuItem);
        this.editMenu.add(this.jSeparator4);
        this.selectAllMenuItem.setText("Select All");
        this.selectAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMacroEditor.this.selectAllMenuItemActionPerformed(actionEvent);
            }
        });
        this.editMenu.add(this.selectAllMenuItem);
        this.menuBar.add(this.editMenu);
        this.macroMenu.setText("Macro");
        this.macroMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMacroEditor.this.macroMenuActionPerformed(actionEvent);
            }
        });
        this.enableMacroMenuItem.setText("Enable Scripting");
        this.enableMacroMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMacroEditor.this.enableMacroMenuItemActionPerformed(actionEvent);
            }
        });
        this.macroMenu.add(this.enableMacroMenuItem);
        this.macroMenu.add(this.jSeparator3);
        this.addMenuItem.setText("Add...");
        this.addMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMacroEditor.this.addMenuItemActionPerformed(actionEvent);
            }
        });
        this.macroMenu.add(this.addMenuItem);
        this.removeMenuItem.setText("Remove");
        this.removeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMacroEditor.this.removeMenuItemActionPerformed(actionEvent);
            }
        });
        this.macroMenu.add(this.removeMenuItem);
        this.renameMenuItem.setText("Rename");
        this.renameMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMacroEditor.this.renameMenuItemActionPerformed(actionEvent);
            }
        });
        this.macroMenu.add(this.renameMenuItem);
        this.macroMenu.add(this.jSeparator2);
        this.runMenuItem.setText("Run");
        this.runMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMacroEditor.this.runMenuItemActionPerformed(actionEvent);
            }
        });
        this.macroMenu.add(this.runMenuItem);
        this.setRateMenuItem.setText("set Rate...");
        this.setRateMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMacroEditor.this.setRateMenuItemActionPerformed(actionEvent);
            }
        });
        this.macroMenu.add(this.setRateMenuItem);
        this.macroMenu.add(this.jSeparator5);
        this.jMenuLanguage.setText("Language");
        this.buttonGroup1.add(this.beanShellMenuItem);
        this.beanShellMenuItem.setSelected(true);
        this.beanShellMenuItem.setText("BeanShell");
        this.beanShellMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMacroEditor.this.beanShellMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenuLanguage.add(this.beanShellMenuItem);
        this.buttonGroup1.add(this.groovyMenuItem);
        this.groovyMenuItem.setText("Groovy");
        this.groovyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMacroEditor.this.groovyMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenuLanguage.add(this.groovyMenuItem);
        this.macroMenu.add(this.jMenuLanguage);
        this.menuBar.add(this.macroMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void groovyMenuItemActionPerformed(ActionEvent actionEvent) {
        GroovyMacroPlugin groovyMacroPlugin = new GroovyMacroPlugin();
        this.setNewMacroPlugin(groovyMacroPlugin);
    }

    private void beanShellMenuItemActionPerformed(ActionEvent actionEvent) {
        MacroPlugin macroPlugin = new MacroPlugin();
        this.setNewMacroPlugin(macroPlugin);
    }

    private void setNewMacroPlugin(MacroInterface macroInterface) {
        MacroInterface macroInterface2 = this.getNeuralNet().getMacroPlugin();
        macroInterface.setMacroManager(macroInterface2.getMacroManager());
        this.getNeuralNet().setMacroPlugin(macroInterface);
    }

    private void taFocusLost(FocusEvent focusEvent) {
        this.saveMacro();
    }

    private void setRateMenuItemActionPerformed(ActionEvent actionEvent) {
        int n = ((MonitorPlugin)((Object)this.getNeuralNet().getMacroPlugin())).getRate();
        String string = this.showInputDialog("Set Rate", "Insert the new rate's value:", Integer.toString(n));
        if (string != null) {
            int n2;
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = n;
            }
            if (n2 < 0) {
                n2 *= -1;
            }
            ((MonitorPlugin)((Object)this.getNeuralNet().getMacroPlugin())).setRate(n2);
        }
    }

    private void renameMenuItemActionPerformed(ActionEvent actionEvent) {
        String string = this.getNewName("Rename a macro", "Insert the new name of the Macro:", this.actualMacro);
        if (string != null) {
            this.getNeuralNet().getMacroPlugin().getMacroManager().renameMacro(this.actualMacro, string);
            this.actualMacro = string;
            this.list.setElementAt(string, this.jList1.getSelectedIndex());
        }
    }

    private void beanShellRadioButtonMenuItemActionPerformed(ActionEvent actionEvent) {
    }

    private void groovyRadioButtonMenuItemActionPerformed(ActionEvent actionEvent) {
    }

    private void removeMenuItemActionPerformed(ActionEvent actionEvent) {
        int n = JOptionPane.showConfirmDialog(this, "OK to remove '" + this.actualMacro + "' ?", "Macro Editor", 0);
        if (n == 0) {
            this.getNeuralNet().getMacroPlugin().getMacroManager().removeMacro(this.actualMacro);
            String string = this.actualMacro;
            this.actualMacro = null;
            this.list.removeElement(string);
        }
    }

    private void addMenuItemActionPerformed(ActionEvent actionEvent) {
        String string = this.getNewName("Add a macro", "Insert the name of the new Macro:", "newMacro");
        if (string != null) {
            this.getNeuralNet().getMacroPlugin().getMacroManager().addMacro(string, "");
            this.list.addElement(string);
            this.jList1.setSelectedIndex(this.list.size() - 1);
        }
    }

    private String getNewName(String string, String string2, String string3) {
        boolean bl = false;
        String string4 = "ERROR: The name already exists.\n";
        String string5 = this.showInputDialog(string, string2, string3);
        if (string5 != null) {
            while (!bl) {
                if (this.getNeuralNet().getMacroPlugin().getMacroManager().getMacro(string5) != null) {
                    string5 = this.showInputDialog(string, string4 + string2, string5);
                    if (string5 != null) continue;
                    bl = true;
                    continue;
                }
                bl = true;
            }
        }
        return string5;
    }

    private void jList1ValueChanged(ListSelectionEvent listSelectionEvent) {
        this.saveMacro();
        int n = this.jList1.getSelectedIndex();
        if (n > -1) {
            String string = (String)this.jList1.getModel().getElementAt(n);
            String string2 = this.getNeuralNet().getMacroPlugin().getMacroManager().getMacro(string);
            if (string2.trim().equals("")) {
                string2 = "/* " + string + " */\n";
            }
            this.ta.setText(string2);
            this.actualMacro = string;
            this.enableMenuItems(this.actualMacro);
        } else {
            this.jList1.setSelectedIndex(0);
        }
    }

    private void enableMenuItems(String string) {
        boolean bl = this.getNeuralNet().getMacroPlugin().getMacroManager().isEventMacro(string);
        if (bl) {
            this.removeMenuItem.setEnabled(false);
            this.renameMenuItem.setEnabled(false);
        } else {
            this.removeMenuItem.setEnabled(true);
            this.renameMenuItem.setEnabled(true);
        }
    }

    private void enableMacroMenuItemActionPerformed(ActionEvent actionEvent) {
        this.neuralNet.setScriptingEnabled(this.enableMacroMenuItem.isSelected());
    }

    private void selectAllMenuItemActionPerformed(ActionEvent actionEvent) {
        this.ta.selectAll();
    }

    private void saveAsMenuItemActionPerformed(ActionEvent actionEvent) {
        this.saveAs();
    }

    private void importMenuItemActionPerformed(ActionEvent actionEvent) {
        JooneFileChooser jooneFileChooser = new JooneFileChooser();
        jooneFileChooser.setDialogTitle("Macro Editor - Import File...");
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                boolean bl = false;
                String[] stringArray = JMacroEditor.this.getFileExtension();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!file.getName().endsWith("." + stringArray[i])) continue;
                    bl = true;
                    break;
                }
                return bl;
            }

            public String getDescription() {
                return JMacroEditor.this.getFileDescription();
            }
        };
        jooneFileChooser.addChoosableFileFilter(fileFilter);
        if (jooneFileChooser.showOpenDialog(this) == 0) {
            this.setFileName(jooneFileChooser.getSelectedFile().getAbsolutePath());
            File file = new File(this.fileName);
            String string = this.readFile(file);
            if (string != null) {
                this.ta.setText(string);
            }
        }
    }

    private void pasteMenuItemActionPerformed(ActionEvent actionEvent) {
        this.ta.paste();
    }

    private void copyMenuItemActionPerformed(ActionEvent actionEvent) {
        this.ta.copy();
    }

    private void cutMenuItemActionPerformed(ActionEvent actionEvent) {
        this.ta.cut();
    }

    private void runMenuItemActionPerformed(ActionEvent actionEvent) {
        this.getNeuralNet().getMacroPlugin().runMacro(this.ta.getText());
    }

    private void macroMenuActionPerformed(ActionEvent actionEvent) {
    }

    private void exitMenuItemActionPerformed(ActionEvent actionEvent) {
        this.saveMacro();
        this.setVisible(false);
    }

    private void exitForm(WindowEvent windowEvent) {
        this.saveMacro();
    }

    public static void main(String[] stringArray) {
        NeuralNet neuralNet = new NeuralNet();
        neuralNet.setMacroPlugin(new MacroPlugin());
        JMacroEditor jMacroEditor = new JMacroEditor(neuralNet);
        jMacroEditor.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jMacroEditor.show();
    }

    public void setText(String string) {
        this.ta.setText(string);
    }

    public String getText() {
        return this.ta.getText();
    }

    public NeuralNet getNeuralNet() {
        return this.neuralNet;
    }

    public void setNeuralNet(NeuralNet neuralNet) {
        this.neuralNet = neuralNet;
    }

    private String readFile(File file) {
        String string = null;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            int n = new Long(file.length()).intValue();
            this.m_buf = new char[n];
            int n2 = fileReader.read(this.m_buf);
            if (n2 != -1) {
                string = new String(this.m_buf, 0, n2);
            }
            fileReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.warn("File '" + file + "' not found. MEssage is : " + fileNotFoundException.getMessage(), fileNotFoundException);
            return string;
        }
        catch (IOException iOException) {
            log.error("File '" + this.m_dir + "' input/output error. Message is : " + iOException.getMessage(), iOException);
        }
        return string;
    }

    public String getFileDescription() {
        return this.FileDescription;
    }

    public void setFileDescription(String string) {
        this.FileDescription = string;
    }

    public String[] getFileExtension() {
        return (String[])this.FileExtension.clone();
    }

    public void setFileExtension(String[] stringArray) {
        this.FileExtension = (String[])stringArray.clone();
    }

    private void saveAs() {
        JFileChooser jFileChooser = this.fileName == null ? new JFileChooser() : new JFileChooser(new File(this.fileName));
        jFileChooser.setDialogTitle("Macro Editor - Save as...");
        if (jFileChooser.showSaveDialog(this) == 0) {
            this.setFileName(jFileChooser.getSelectedFile().getAbsolutePath());
            this.save();
        }
    }

    private void save() {
        try {
            FileWriter fileWriter = new FileWriter(new File(this.fileName));
            fileWriter.write(this.ta.getText());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            log.warn("IOException thrown. Message is +" + iOException.getMessage(), iOException);
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
        if (string != null) {
            this.setTitle(string);
        } else {
            this.setTitle("New File");
        }
    }

    private void fillList() {
        Hashtable hashtable = this.getNeuralNet().getMacroPlugin().getMacroManager().getMacros();
        this.list = new DefaultListModel();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.list.addElement(string);
        }
        this.jList1.setModel(this.list);
        this.jList1.setSelectedIndex(0);
    }

    private String showInputDialog(String string, String string2, String string3) {
        Object object;
        JOptionPane jOptionPane = new JOptionPane(string2, 3);
        jOptionPane.setWantsInput(true);
        jOptionPane.setInitialSelectionValue(string3);
        jOptionPane.setOptionType(2);
        JDialog jDialog = jOptionPane.createDialog(this, string);
        jDialog.show();
        int n = (Integer)jOptionPane.getValue();
        if (n == 0 && (object = jOptionPane.getInputValue()) != null && object instanceof String) {
            return (String)object;
        }
        return null;
    }

    private void saveMacro() {
        String string;
        if (this.actualMacro != null && !(string = this.getNeuralNet().getMacroPlugin().getMacroManager().getMacro(this.actualMacro)).equals(this.ta.getText())) {
            this.getNeuralNet().getMacroPlugin().getMacroManager().addMacro(this.actualMacro, this.ta.getText());
        }
    }
}

