/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class IniFile {
    String fileName;
    Collection cache = new ArrayList();

    public IniFile(String string) throws IOException {
        this.fileName = string;
        File file = new File(this.fileName);
        if (!file.exists()) {
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            printWriter.flush();
            printWriter.close();
        }
    }

    public void setParameter(String string, String string2, String string3) throws IOException, IllegalArgumentException {
        String string4;
        if (string == null || string.trim().equals("")) {
            throw new IllegalArgumentException("Section is null or blank.");
        }
        if (string2 == null || string2.trim().equals("")) {
            throw new IllegalArgumentException("Item is null or blank.");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("Value is null.");
        }
        this.cache = new ArrayList();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.fileName));
        boolean bl = false;
        while ((string4 = bufferedReader.readLine()) != null) {
            this.cache.add(string4);
            if (!string4.toUpperCase().equals("[" + string.toUpperCase() + "]")) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.cache.add("[" + string.toUpperCase() + "]");
            bl = true;
        }
        boolean bl2 = false;
        while ((string4 = bufferedReader.readLine()) != null) {
            if (string4.startsWith(string2.toLowerCase() + "=")) {
                this.cache.add(string2.toLowerCase() + "=" + string3.toLowerCase());
                bl2 = true;
                continue;
            }
            if (string4.startsWith("[") && !bl2) {
                this.cache.add(string2.toLowerCase() + "=" + string3.toLowerCase());
                bl = false;
                bl2 = true;
            }
            this.cache.add(string4);
        }
        if (!bl2 && bl) {
            this.cache.add(string2.toLowerCase() + "=" + string3.toLowerCase());
        }
        bufferedReader.close();
        PrintWriter printWriter = new PrintWriter(new FileWriter(this.fileName));
        Iterator iterator = this.cache.iterator();
        while (iterator.hasNext()) {
            printWriter.println((String)iterator.next());
        }
        printWriter.flush();
        printWriter.close();
    }

    public String getParameter(String string, String string2) throws IOException, IllegalArgumentException {
        if (!this.cache.isEmpty()) {
            String string3 = null;
            boolean bl = false;
            for (String string4 : this.cache) {
                if (string4.toUpperCase().equals("[" + string.toUpperCase() + "]")) {
                    bl = true;
                    continue;
                }
                if (bl && string4.startsWith(string2 + "=")) {
                    string3 = string4.substring(1 + string4.indexOf("="));
                }
                if (!bl || !string4.startsWith("[")) continue;
                break;
            }
            if (string3 != null) {
                return string3;
            }
        } else {
            String string5;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.fileName));
            boolean bl = false;
            String string6 = null;
            while ((string5 = bufferedReader.readLine()) != null) {
                this.cache.add(string5);
                if (string5.toUpperCase().equals("[" + string.toUpperCase() + "]")) {
                    bl = true;
                    continue;
                }
                if (bl && string5.startsWith(string2 + "=")) {
                    string6 = string5.substring(1 + string5.indexOf("="));
                }
                if (!bl || !string5.startsWith("[")) continue;
                bl = false;
            }
            if (string6 != null) {
                return string6;
            }
        }
        throw new IllegalArgumentException("Section {" + string + "} item {" + string2 + "} not found.");
    }

    public String getParameter(String string, String string2, String string3) throws IOException {
        try {
            return this.getParameter(string, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return string3;
        }
    }

    public static void main(String[] stringArray) {
        try {
            IniFile iniFile = new IniFile("q.ini");
            iniFile.setParameter("section 1", "item 1", "value 1");
            iniFile.setParameter("sec 2", "item 2", "val 2");
            iniFile.setParameter("section 1", "item 3", "val 3");
            System.out.println(iniFile.getParameter("section 1", "item 3", "55"));
            System.out.println(iniFile.getParameter("sec 2", "item 2"));
            System.out.println(iniFile.getParameter("section 1", "item 4", "55"));
            System.out.println(iniFile.getParameter("section 2", "item 2"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

