/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.Hashtable;
import org.joone.edit.ChartingHandle;
import org.joone.edit.SharedBuffer;
import org.joone.log.ILogger;
import org.joone.log.LoggerFactory;

public class DrawingRegion
extends Canvas
implements Runnable {
    private static final ILogger log = LoggerFactory.getLogger(DrawingRegion.class);
    private static final int ERROR = 0;
    private static final int CYCLE = 1;
    private int X_ENHETER = 0;
    private double X_INTERVALL = 0.0;
    private int Y_ENHETER = 10;
    private int MAX_X;
    private int MAX_Y;
    private double[] grafData;
    private Hashtable grafDataMul;
    private SharedBuffer grafBuffer;
    private Hashtable buffers;
    private Thread myThread;
    private Dimension myDim;
    private int currentCycle = 0;
    private boolean keepPlotting = true;
    private Color original;
    private Color background;
    private Color gray;
    private int max_x_value;
    private double max_y_value;
    private double stepY;
    private double stepX;
    private int X = 45;
    private int Y = 25;
    private BufferedImage bi;
    private Graphics big;
    private static final long serialVersionUID = -1681735154132358889L;

    public DrawingRegion(Dimension dimension, double d, int n) {
        if (dimension.width < this.X && dimension.height < this.Y) {
            log.warn("Drawing area too small, use min " + this.X + " * " + this.Y + " pixels.");
        } else if (n < 2) {
            log.warn("X Spredning must be > 1");
        } else if (d <= 0.0) {
            log.warn("Y Spredning must be > 0.0");
        } else {
            this.myDim = dimension;
            this.max_x_value = n;
            this.max_y_value = d;
            this.setSize(this.myDim);
            this.getXEnhet(n);
            this.constructorInit();
        }
    }

    public DrawingRegion(Dimension dimension, int n) {
        this(dimension, 1.0, n);
    }

    public DrawingRegion(int n) {
        this(new Dimension(550, 350), n);
    }

    private void constructorInit() {
        this.buffers = new Hashtable();
        this.grafData = new double[this.max_x_value + 1];
        this.grafDataMul = new Hashtable();
        this.original = new Color(0, 0, 0);
        this.background = new Color(200, 200, 200);
        this.gray = new Color(160, 160, 160);
        this.setBackground(this.background);
        this.setDimensions(this.myDim);
        this.start();
    }

    private void setDimensions(Dimension dimension) {
        this.myDim = dimension;
        double d = this.myDim.width - 2 * this.X;
        double d2 = this.myDim.height - 2 * this.Y;
        this.MAX_X = new Double(d).intValue();
        this.MAX_Y = new Double(d2).intValue();
        this.stepX = (double)this.MAX_X / (double)this.max_x_value;
        this.stepY = (double)this.MAX_Y / this.max_y_value;
    }

    private void getXEnhet(int n) {
        this.X_INTERVALL = n / 5;
        this.X_ENHETER = new Double((double)n / this.X_INTERVALL).intValue();
    }

    public void stopPloting() {
        this.keepPlotting = false;
    }

    public SharedBuffer getBuffer() {
        if (this.grafBuffer == null) {
            this.grafBuffer = new SharedBuffer();
        }
        return this.grafBuffer;
    }

    public SharedBuffer getBuffer(ChartingHandle chartingHandle) {
        SharedBuffer sharedBuffer = (SharedBuffer)this.buffers.get(chartingHandle);
        if (sharedBuffer == null) {
            sharedBuffer = new SharedBuffer();
            sharedBuffer.setHandle(chartingHandle);
            this.buffers.put(chartingHandle, sharedBuffer);
        }
        return sharedBuffer;
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.bi == null || this.bi.getWidth() != dimension.width || this.bi.getHeight() != dimension.height) {
            this.bi = new BufferedImage(dimension.width, dimension.height, 1);
            this.big = this.bi.getGraphics();
        }
        this.big.setColor(this.background);
        this.big.fillRect(0, 0, dimension.width, dimension.height);
        if (this.myDim.height != dimension.height || this.myDim.width != dimension.width) {
            this.setDimensions(dimension);
        }
        this.initDrawingRegion(this.big);
        if (this.grafBuffer != null) {
            this.plot(this.big, this.grafData, new Color(0, 0, 200));
        }
        Enumeration enumeration = this.buffers.keys();
        while (enumeration.hasMoreElements()) {
            ChartingHandle chartingHandle = (ChartingHandle)enumeration.nextElement();
            double[] dArray = (double[])this.grafDataMul.get(chartingHandle);
            Color color = new Color(chartingHandle.getRedColor(), chartingHandle.getGreenColor(), chartingHandle.getBlueColor());
            if (dArray == null) continue;
            this.plot(this.big, dArray, color);
        }
        this.big.setColor(this.original);
        int n = new Double((double)this.myDim.width * 0.5).intValue();
        this.big.drawString("Current cycle is " + this.currentCycle, n, 70);
        graphics.drawImage(this.bi, 0, 0, this);
    }

    private void initDrawingRegion(Graphics graphics) {
        graphics.setColor(this.original);
        graphics.drawRect(0, 0, this.myDim.width - 1, this.myDim.height - 1);
        graphics.drawString("Y", 20, 12);
        this.plotLine(graphics, 0, 0.0, 0, this.max_y_value);
        graphics.drawString("X", this.myDim.width - 20, this.myDim.height - 20);
        this.plotLine(graphics, 0, 0.0, this.max_x_value, 0.0);
        graphics.drawString("0,0", 10, this.myDim.height - 10);
        int n = new Float(this.max_x_value / this.X_ENHETER).intValue();
        int n2 = 0;
        String string = new Integer(new Double(this.X_INTERVALL).intValue()).toString();
        int n3 = 1;
        while (n3 < this.X_ENHETER + 1) {
            graphics.drawString(string, this.getAbsX(n2 += n) - 15, this.myDim.height - 2);
            this.plotLine(graphics, n2, 5.0 / this.stepY, n2, -5.0 / this.stepY);
            this.plotXGridLine(graphics, n2);
            string = new Integer(new Double(this.X_INTERVALL * (double)(++n3)).intValue()).toString();
        }
        this.Y_ENHETER = 10;
        double d = this.max_y_value / (double)this.Y_ENHETER;
        double d2 = 0.0;
        int n4 = this.getPrecision(this.max_y_value);
        int n5 = (int)Math.pow(10.0, n4);
        for (int i = 1; i < this.Y_ENHETER + 1; ++i) {
            double d3 = this.max_y_value / (double)this.Y_ENHETER * (double)(this.Y_ENHETER + 1 - i);
            int n6 = new Double(d3 * (double)n5).intValue();
            d3 = new Double(n6) / (double)n5;
            string = new Double(d3).toString();
            this.plotLine(graphics, new Double(-5.0 / this.stepX).intValue(), d2 += d, new Double(5.0 / this.stepX).intValue(), d2);
            this.plotYGridLine(graphics, d2);
            graphics.drawString(string, 2, this.getAbsY(this.max_y_value - d2 + d) + 2);
        }
    }

    private int getPrecision(double d) {
        int n = new Double(10.0 / d).intValue();
        if (n == 0) {
            n = 1;
        }
        double d2 = Math.log(n) / Math.log(10.0);
        int n2 = new Double(d2).intValue() + 2;
        return n2;
    }

    private void plotLine(Graphics graphics, int n, double d, int n2, double d2) {
        int n3 = this.getAbsX(n);
        int n4 = this.getAbsY(d);
        int n5 = this.getAbsX(n2);
        int n6 = this.getAbsY(d2);
        graphics.drawLine(n3, n4, n5, n6);
    }

    private int getAbsX(int n) {
        int n2 = new Double((double)n * this.stepX).intValue();
        return n2 + this.X;
    }

    private int getAbsY(double d) {
        int n = new Double(d * this.stepY).intValue();
        return this.myDim.height - this.Y - n;
    }

    private void plotYGridLine(Graphics graphics, double d) {
        graphics.setColor(this.gray);
        this.plotLine(graphics, 0, d, this.max_x_value, d);
        graphics.setColor(this.original);
    }

    private void plotXGridLine(Graphics graphics, int n) {
        graphics.setColor(this.gray);
        this.plotLine(graphics, n, 0.0, n, this.max_y_value);
        graphics.setColor(this.original);
    }

    private void plot(Graphics graphics, double[] dArray, Color color) {
        boolean bl = false;
        graphics.setColor(color);
        for (int i = 2; i <= this.currentCycle; ++i) {
            if (dArray[i - 1] == 0.0 && !bl) continue;
            this.plotLine(graphics, i - 1, dArray[i - 1], i, dArray[i]);
            bl = true;
        }
    }

    public void start() {
        if (this.myThread == null) {
            this.myThread = new Thread((Runnable)this, "DrawingRegion");
            try {
                this.myThread.start();
            }
            catch (Exception exception) {
                String string = "DrawingRegion:start() : " + exception.getMessage();
                log.fatal(string, exception);
                System.exit(1);
            }
        }
    }

    public void run() {
        int n = 0;
        while (this.keepPlotting) {
            if (this.grafBuffer != null) {
                n = this.getData(null);
            }
            int n2 = n;
            Enumeration enumeration = this.buffers.keys();
            while (enumeration.hasMoreElements()) {
                ChartingHandle chartingHandle = (ChartingHandle)enumeration.nextElement();
                n = this.getData(chartingHandle);
                if (n <= n2) continue;
                n2 = n;
            }
            if (n2 > 0) {
                this.currentCycle = n2;
                this.repaint();
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.myThread = null;
    }

    private int getData(ChartingHandle chartingHandle) {
        double[] dArray;
        double[][] dArray2;
        if (chartingHandle == null) {
            dArray2 = this.grafBuffer.get();
            dArray = this.grafData;
        } else {
            SharedBuffer sharedBuffer = (SharedBuffer)this.buffers.get(chartingHandle);
            dArray2 = sharedBuffer.getNoWait();
            dArray = (double[])this.grafDataMul.get(chartingHandle);
            if (dArray == null) {
                dArray = new double[this.max_x_value + 1];
                this.grafDataMul.put(chartingHandle, dArray);
            }
        }
        int n = 0;
        if (dArray2 != null) {
            int n2;
            for (int i = 0; i < dArray2.length && (n2 = new Double(dArray2[i][1]).intValue()) != -1 && n2 < dArray.length; ++i) {
                dArray[n2] = dArray2[i][0];
                n = n2;
            }
        }
        return n;
    }

    public int getMaxXvalue() {
        return this.max_x_value;
    }

    public void setMaxXvalue(int n) {
        this.max_x_value = n;
        this.copyBuffer(n);
        this.getXEnhet(n);
        this.setDimensions(this.myDim);
        this.repaint();
    }

    public double getMaxYvalue() {
        return this.max_y_value;
    }

    public void setMaxYvalue(double d) {
        this.max_y_value = d;
        this.setDimensions(this.myDim);
        this.repaint();
    }

    private void copyBuffer(int n) {
        double[] dArray = new double[n + 1];
        int n2 = n;
        if (n2 > this.grafData.length) {
            n2 = this.grafData.length;
        }
        for (int i = 0; i < n2; ++i) {
            dArray[i] = this.grafData[i];
        }
        if (this.currentCycle >= n2) {
            this.currentCycle = n2 - 1;
        }
        this.grafData = dArray;
    }

    protected void removeHandle(ChartingHandle chartingHandle) {
        if (this.buffers != null) {
            this.buffers.remove(chartingHandle);
        }
        if (this.grafDataMul != null) {
            this.grafDataMul.remove(chartingHandle);
        }
    }
}

