/*
 * Decompiled with CFR 0.152.
 */
package org.joone.edit;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.joone.edit.EditorParameters;
import org.joone.edit.PropertySheet;
import org.joone.engine.Monitor;
import org.joone.engine.NeuralNetEvent;
import org.joone.engine.NeuralNetListener;
import org.joone.net.NetChecker;
import org.joone.net.NeuralNet;

public class ControlPanel
extends JPanel
implements NeuralNetListener {
    private Monitor monitor;
    private NeuralNet nNet;
    private PropertySheet parent;
    private NetChecker netChecker;
    private boolean printCycle = false;
    private JButton continueButton;
    private JLabel cicleLabel;
    private JButton stopButton;
    private JPanel jPanel2;
    private JLabel cicleValue;
    private JButton runButton;
    private JLabel rmsLabel;
    private JPanel jPanel1;
    private JLabel rmsValue;
    private static final long serialVersionUID = 1310288899683080017L;
    private EditorParameters parameters;

    public ControlPanel(NeuralNet neuralNet, PropertySheet propertySheet) {
        this.setMonitor(neuralNet.getMonitor());
        this.parent = propertySheet;
        this.nNet = neuralNet;
        this.netChecker = new NetChecker(this.nNet);
        this.initComponents();
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
        this.monitor.addNeuralNetListener(this);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.runButton = new JButton();
        this.continueButton = new JButton();
        this.stopButton = new JButton();
        this.jPanel2 = new JPanel();
        this.cicleLabel = new JLabel();
        this.cicleValue = new JLabel();
        this.rmsLabel = new JLabel();
        this.rmsValue = new JLabel();
        this.setLayout(new GridLayout(2, 1, 0, 10));
        this.setBorder(new TitledBorder("Controls"));
        this.jPanel1.setLayout(new GridLayout(1, 3));
        this.runButton.setForeground(Color.green);
        this.runButton.setText("Run");
        this.runButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.runButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.runButton);
        this.continueButton.setForeground(new Color(0, 51, 255));
        this.continueButton.setText("Continue");
        this.continueButton.setEnabled(false);
        this.continueButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.continueButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.continueButton);
        this.stopButton.setForeground(Color.red);
        this.stopButton.setText("Pause");
        this.stopButton.setEnabled(false);
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.stopButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.stopButton);
        this.add(this.jPanel1);
        this.jPanel2.setLayout(new GridLayout(2, 2, 0, 8));
        this.cicleLabel.setHorizontalAlignment(4);
        this.cicleLabel.setText("Epochs :  ");
        this.cicleLabel.setHorizontalTextPosition(4);
        this.jPanel2.add(this.cicleLabel);
        this.cicleValue.setHorizontalAlignment(2);
        this.cicleValue.setText("0");
        this.jPanel2.add(this.cicleValue);
        this.rmsLabel.setHorizontalAlignment(4);
        this.rmsLabel.setText("RMSE :  ");
        this.jPanel2.add(this.rmsLabel);
        this.rmsValue.setHorizontalAlignment(2);
        this.rmsValue.setText("0.0");
        this.jPanel2.add(this.rmsValue);
        this.add(this.jPanel2);
    }

    private void continueButtonActionPerformed(ActionEvent actionEvent) {
        if (this.netChecker.hasErrors()) {
            this.displayNogo("Network could not be run.", "See 'To Do List' to check all the errors.");
        } else {
            this.setLearners();
            this.nNet.restore();
            this.setState(false);
        }
    }

    private void stopButtonActionPerformed(ActionEvent actionEvent) {
        this.nNet.stop();
    }

    private void runButtonActionPerformed(ActionEvent actionEvent) {
        if (this.netChecker.hasErrors()) {
            this.displayNogo("Network could not be run.", "See 'To Do List' to check all the errors.");
        } else {
            this.setLearners();
            this.nNet.go();
        }
    }

    public void netStopped(NeuralNetEvent neuralNetEvent) {
        this.setState(true);
        this.printCycle = true;
        this.parent.update();
    }

    public void cicleTerminated(NeuralNetEvent neuralNetEvent) {
        int n = this.monitor.getTotCicles() - this.monitor.getCurrentCicle() + 1;
        int n2 = n / this.parameters.getRefreshingRate();
        if (n2 * this.parameters.getRefreshingRate() == n || this.monitor.getCurrentCicle() == 1) {
            this.cicleValue.setText(Integer.toString(n));
            this.printCycle = true;
        }
    }

    public void setParameters(EditorParameters editorParameters) {
        this.parameters = editorParameters;
    }

    private void setState(boolean bl) {
        this.runButton.setEnabled(bl);
        this.continueButton.setEnabled(bl);
        this.stopButton.setEnabled(!bl);
        this.parent.setControlsEnabled(bl);
    }

    public void netStarted(NeuralNetEvent neuralNetEvent) {
        this.setState(false);
    }

    public void errorChanged(NeuralNetEvent neuralNetEvent) {
        if (this.printCycle || this.monitor.getTotCicles() < this.parameters.getRefreshingRate()) {
            this.rmsValue.setText(Double.toString(this.monitor.getGlobalError()));
            this.printCycle = false;
        }
    }

    private void displayNogo(String string, String string2) {
        final JDialog jDialog = new JDialog(this.parent, "Critical Network Error", true);
        jDialog.getContentPane().setLayout(new BorderLayout(10, 10));
        Button button = new Button("  OK  ");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1));
        panel.add(button);
        jDialog.getContentPane().add((Component)panel, "South");
        JLabel jLabel = new JLabel(string);
        jLabel.setHorizontalAlignment(0);
        jDialog.getContentPane().add((Component)jLabel, "North");
        jLabel = new JLabel(string2);
        jLabel.setHorizontalAlignment(0);
        jDialog.getContentPane().add((Component)jLabel, "Center");
        jDialog.pack();
        Point point = new Point(this.parent.getX() + this.parent.getWidth() / 2, this.parent.getY() + this.parent.getHeight() / 2);
        jDialog.setLocation((int)(point.getX() - (double)(jDialog.getWidth() / 2)), (int)(point.getY() - (double)(jDialog.getHeight() / 2)));
        jDialog.setVisible(true);
    }

    public void netStoppedError(NeuralNetEvent neuralNetEvent, String string) {
        this.setState(true);
        this.printCycle = true;
        this.parent.update();
        this.displayNogo("Runtime Error!", string);
    }

    public void setLearners() {
        this.monitor.addLearner(0, "org.joone.engine.BasicLearner");
        this.monitor.addLearner(1, "org.joone.engine.BatchLearner");
        this.monitor.addLearner(2, "org.joone.engine.RpropLearner");
    }
}

